/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.math.Vec3;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.FaceParameterValue;
import artofillusion.texture.FaceVertexParameterValue;
import artofillusion.texture.ParameterValue;
import artofillusion.texture.VertexParameterValue;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import buoy.widget.BButton;
import buoy.widget.BDialog;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.BOutline;
import buoy.widget.BorderContainer;
import buoy.widget.GridContainer;
import buoy.widget.LayoutInfo;

public class TriMeshSimplifier
implements Runnable {
    private TriangleMesh mesh;
    private VertexInfo[] vertex;
    private MeshEdge[] edge;
    private MeshFace[] face;
    private Vec3 temp1;
    private Vec3 temp2;
    private Vec3 temp3;
    private int faces;
    private BDialog dial;
    private BButton cancelButton;
    private BLabel status;
    private BLabel numLabel;
    private boolean cancel;
    private double tol;

    public TriMeshSimplifier(TriangleMesh theMesh, boolean[] selection, double tolerance, BFrame fr) {
        this.mesh = theMesh;
        this.tol = tolerance * tolerance;
        this.buildDataStructures(selection);
        if (fr == null) {
            this.run();
        } else {
            this.createDialog(fr);
            new Thread(this).start();
            Thread update = new Thread(){

                @Override
                public void run() {
                    try {
                        while (!TriMeshSimplifier.this.cancel) {
                            1.sleep(200L);
                            TriMeshSimplifier.this.status.setText(String.valueOf(TriMeshSimplifier.this.faces));
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            update.start();
            this.dial.setVisible(true);
        }
    }

    @Override
    public void run() {
        this.doSimplification();
        if (!this.cancel) {
            this.buildMesh();
        }
        this.cancel = true;
        if (this.numLabel != null) {
            this.numLabel.setText(Translate.text("Final") + ":");
            this.status.setText(String.valueOf(this.faces));
            this.cancelButton.setText(Translate.text("Done"));
            this.dial.setDefaultButton(this.cancelButton);
        }
    }

    private void createDialog(BFrame fr) {
        this.dial = new BDialog(fr, true);
        BorderContainer content = new BorderContainer();
        this.dial.setContent(BOutline.createEmptyBorder(content, UIUtilities.getStandardDialogInsets()));
        content.add(Translate.label("numTrianglesInMesh"), BorderContainer.NORTH);
        GridContainer grid = new GridContainer(2, 2);
        grid.add(new BLabel(Translate.text("Original") + ":"), 0, 0);
        this.numLabel = new BLabel(Translate.text("Current") + ":");
        grid.add(this.numLabel, 0, 1);
        grid.add(new BLabel(String.valueOf(this.faces)), 1, 0);
        this.status = new BLabel(String.valueOf(this.faces));
        grid.add(this.status, 1, 1);
        content.add(grid, BorderContainer.CENTER);
        this.cancelButton = Translate.button("cancel", new Object(){

            void processEvent() {
                TriMeshSimplifier.this.cancel = true;
                TriMeshSimplifier.this.dial.dispose();
            }
        }, "processEvent");
        content.add(this.cancelButton, BorderContainer.SOUTH, new LayoutInfo());
        this.dial.pack();
        this.dial.setResizable(false);
        UIUtilities.centerDialog(this.dial, fr);
    }

    private void buildMesh() {
        int j;
        int i;
        int[] index = new int[this.vertex.length];
        int[][] f = new int[this.faces][];
        int k = 0;
        block0: for (i = 0; i < this.vertex.length; ++i) {
            index[i] = k++;
            for (j = 0; j < i; ++j) {
                if (this.vertex[i] != this.vertex[j]) continue;
                index[i] = index[j];
                --k;
                continue block0;
            }
        }
        TriangleMesh.Vertex[] vert = new TriangleMesh.Vertex[k];
        for (i = 0; i < this.vertex.length; ++i) {
            int n = index[i];
            TriangleMesh triangleMesh = this.mesh;
            triangleMesh.getClass();
            vert[n] = new TriangleMesh.Vertex(triangleMesh, this.vertex[i].theVert);
            vert[index[i]].r = new Vec3(this.vertex[i].pos);
            vert[index[i]].smoothness = this.vertex[i].smoothness;
            vert[index[i]].edges = 0;
            vert[index[i]].firstEdge = -1;
        }
        for (i = 0; i < this.faces; ++i) {
            f[i] = new int[]{index[this.face[i].v1], index[this.face[i].v2], index[this.face[i].v3]};
        }
        this.mesh.setShape(vert, f);
        TriangleMesh.Edge[] ed = this.mesh.getEdges();
        block4: for (i = 0; i < ed.length; ++i) {
            for (j = 0; j < this.edge.length; ++j) {
                if (this.edge[j] == null || (index[this.edge[j].v1] != ed[i].v1 || index[this.edge[j].v2] != ed[i].v2) && (index[this.edge[j].v2] != ed[i].v1 || index[this.edge[j].v1] != ed[i].v2)) continue;
                ed[i].smoothness = this.edge[j].smoothness;
                continue block4;
            }
        }
        ParameterValue[] paramValue = this.mesh.getParameterValues();
        if (paramValue != null) {
            for (int i2 = 0; i2 < paramValue.length; ++i2) {
                int j2;
                double[] oldValue;
                ParameterValue value;
                if (paramValue[i2] instanceof VertexParameterValue) {
                    value = (VertexParameterValue)paramValue[i2];
                    oldValue = ((VertexParameterValue)value).getValue();
                    double[] newValue = new double[this.vertex.length];
                    for (j2 = 0; j2 < newValue.length; ++j2) {
                        newValue[index[j2]] = oldValue[j2];
                    }
                    ((VertexParameterValue)value).setValue(newValue);
                    continue;
                }
                if (paramValue[i2] instanceof FaceParameterValue) {
                    value = (FaceParameterValue)paramValue[i2];
                    oldValue = ((FaceParameterValue)value).getValue();
                    double[] newValue = new double[this.faces];
                    for (j2 = 0; j2 < newValue.length; ++j2) {
                        newValue[j2] = oldValue[this.face[j2].origIndex];
                    }
                    ((FaceParameterValue)value).setValue(newValue);
                    continue;
                }
                if (!(paramValue[i2] instanceof FaceVertexParameterValue)) continue;
                value = (FaceVertexParameterValue)paramValue[i2];
                double[][] newValue = new double[this.faces][3];
                for (int j3 = 0; j3 < newValue.length; ++j3) {
                    newValue[j3][0] = ((FaceVertexParameterValue)value).getValue(this.face[j3].origIndex, 0);
                    newValue[j3][1] = ((FaceVertexParameterValue)value).getValue(this.face[j3].origIndex, 1);
                    newValue[j3][2] = ((FaceVertexParameterValue)value).getValue(this.face[j3].origIndex, 2);
                }
                ((FaceVertexParameterValue)value).setValue(newValue);
            }
            this.mesh.setParameterValues(paramValue);
        }
    }

    private void buildDataStructures(boolean[] selection) {
        Constraint con;
        int i;
        TriangleMesh.Vertex[] v = (TriangleMesh.Vertex[])this.mesh.getVertices();
        TriangleMesh.Edge[] e = this.mesh.getEdges();
        TriangleMesh.Face[] f = this.mesh.getFaces();
        this.vertex = new VertexInfo[v.length];
        this.edge = new MeshEdge[e.length];
        this.face = new MeshFace[f.length];
        int[] edgeCount = new int[v.length];
        int[] faceCount = new int[v.length];
        this.faces = f.length;
        this.temp1 = new Vec3();
        this.temp2 = new Vec3();
        this.temp3 = new Vec3();
        for (i = 0; i < e.length; ++i) {
            int n = e[i].v1;
            edgeCount[n] = edgeCount[n] + 1;
            int n2 = e[i].v2;
            edgeCount[n2] = edgeCount[n2] + 1;
        }
        for (i = 0; i < f.length; ++i) {
            int n = f[i].v1;
            faceCount[n] = faceCount[n] + 1;
            int n3 = f[i].v2;
            faceCount[n3] = faceCount[n3] + 1;
            int n4 = f[i].v3;
            faceCount[n4] = faceCount[n4] + 1;
        }
        for (i = 0; i < v.length; ++i) {
            this.vertex[i] = new VertexInfo();
            this.vertex[i].theVert = v[i];
            this.vertex[i].pos = v[i].r;
            this.vertex[i].smoothness = v[i].smoothness;
            this.vertex[i].star = new MeshEdge[edgeCount[i]];
            this.vertex[i].crown = new MeshFace[faceCount[i]];
            this.vertex[i].zone = new Zone();
            this.vertex[i].zone.con = faceCount[i] == edgeCount[i] ? new Constraint[faceCount[i]] : new Constraint[faceCount[i] + 2];
        }
        for (i = 0; i < e.length; ++i) {
            this.edge[i] = new MeshEdge();
            this.edge[i].v1 = e[i].v1;
            this.edge[i].v2 = e[i].v2;
            this.edge[i].smoothness = e[i].smoothness;
            VertexInfo v1 = this.vertex[e[i].v1];
            VertexInfo v2 = this.vertex[e[i].v2];
            v1.star[v1.edges++] = this.edge[i];
            v2.star[v2.edges++] = this.edge[i];
            this.edge[i].selected = selection[i];
        }
        for (i = 0; i < f.length; ++i) {
            this.face[i] = new MeshFace();
            this.face[i].v1 = f[i].v1;
            this.face[i].v2 = f[i].v2;
            this.face[i].v3 = f[i].v3;
            this.face[i].e1 = this.edge[f[i].e1];
            this.face[i].e2 = this.edge[f[i].e2];
            this.face[i].e3 = this.edge[f[i].e3];
            this.face[i].index = i;
            this.face[i].origIndex = i;
            this.face[i].normal = new Vec3();
            this.findNormal(this.vertex[f[i].v1].pos, this.vertex[f[i].v2].pos, this.vertex[f[i].v3].pos, this.face[i].normal);
            this.vertex[f[i].v1].crown[this.vertex[f[i].v1].faces++] = this.face[i];
            this.vertex[f[i].v2].crown[this.vertex[f[i].v2].faces++] = this.face[i];
            this.vertex[f[i].v3].crown[this.vertex[f[i].v3].faces++] = this.face[i];
            con = new Constraint();
            if (this.face[i].normal.length2() == 0.0) {
                con.a = 1.0;
                con.b = 1.0;
                con.c = 1.0;
            } else {
                con.a = this.face[i].normal.x;
                con.b = this.face[i].normal.y;
                con.c = this.face[i].normal.z;
            }
            con.d = -(con.a * v[f[i].v1].r.x + con.b * v[f[i].v1].r.y + con.c * v[f[i].v1].r.z);
            this.vertex[f[i].v1].zone.con[this.vertex[f[i].v1].zone.constraints++] = con;
            this.vertex[f[i].v2].zone.con[this.vertex[f[i].v2].zone.constraints++] = con;
            this.vertex[f[i].v3].zone.con[this.vertex[f[i].v3].zone.constraints++] = con;
            if (this.edge[f[i].e1].f1 == null) {
                this.edge[f[i].e1].f1 = this.face[i];
            } else {
                this.edge[f[i].e1].f2 = this.face[i];
            }
            if (this.edge[f[i].e2].f1 == null) {
                this.edge[f[i].e2].f1 = this.face[i];
            } else {
                this.edge[f[i].e2].f2 = this.face[i];
            }
            if (this.edge[f[i].e3].f1 == null) {
                this.edge[f[i].e3].f1 = this.face[i];
                continue;
            }
            this.edge[f[i].e3].f2 = this.face[i];
        }
        for (i = 0; i < e.length; ++i) {
            if (this.edge[i].f2 != null) continue;
            this.temp1.set(v[this.edge[i].v1].r);
            this.temp1.subtract(v[this.edge[i].v2].r);
            this.temp2.set(this.edge[i].f1.normal);
            con = new Constraint();
            con.a = this.temp1.y * this.temp2.z - this.temp1.z * this.temp2.y;
            con.b = this.temp1.z * this.temp2.x - this.temp1.x * this.temp2.z;
            con.c = this.temp1.x * this.temp2.y - this.temp1.y * this.temp2.x;
            con.d = -(con.a * v[this.edge[i].v1].r.x + con.b * v[this.edge[i].v1].r.y + con.c * v[this.edge[i].v1].r.z);
            this.vertex[this.edge[i].v1].zone.con[this.vertex[this.edge[i].v1].zone.constraints++] = con;
            this.vertex[this.edge[i].v2].zone.con[this.vertex[this.edge[i].v2].zone.constraints++] = con;
        }
        for (i = 0; i < e.length; ++i) {
            this.updateCost(this.edge[i]);
        }
        int j = 0;
        for (i = 0; i < e.length; ++i) {
            if (!(this.edge[i].cost < this.edge[j].cost)) continue;
            j = i;
        }
        MeshEdge tempEdge = this.edge[j];
        this.edge[j] = this.edge[0];
        this.edge[0] = tempEdge;
    }

    private void doSimplification() {
        int skip;
        for (int i = 0; i < this.edge.length; i += skip) {
            Zone zone1;
            MeshEdge rem2;
            MeshEdge rep2;
            MeshEdge rep1;
            MeshEdge rem1;
            int k;
            int j;
            MeshEdge e = this.edge[i];
            if (e.cost >= this.tol || this.cancel) {
                return;
            }
            VertexInfo v1 = this.vertex[e.v1];
            VertexInfo v2 = this.vertex[e.v2];
            boolean boundary = e.f2 == null;
            v2.pos = v1.pos;
            MeshEdge[] star = v1.star;
            for (j = 0; j < v1.edges; ++j) {
                VertexInfo tempVert = this.vertex[star[j].v1] == v1 ? this.vertex[star[j].v2] : this.vertex[star[j].v1];
                for (k = 0; k < tempVert.edges; ++k) {
                    tempVert.star[k].cost = -1.0;
                }
            }
            star = v2.star;
            for (j = 0; j < v2.edges; ++j) {
                star[j].cost = -1.0;
            }
            if (e.f1.e1 == e) {
                if (this.vertex[e.f1.e2.v1] == v2 || this.vertex[e.f1.e2.v2] == v2) {
                    rem1 = e.f1.e2;
                    rep1 = e.f1.e3;
                } else {
                    rem1 = e.f1.e3;
                    rep1 = e.f1.e2;
                }
            } else if (e.f1.e2 == e) {
                if (this.vertex[e.f1.e3.v1] == v2 || this.vertex[e.f1.e3.v2] == v2) {
                    rem1 = e.f1.e3;
                    rep1 = e.f1.e1;
                } else {
                    rem1 = e.f1.e1;
                    rep1 = e.f1.e3;
                }
            } else if (this.vertex[e.f1.e1.v1] == v2 || this.vertex[e.f1.e1.v2] == v2) {
                rem1 = e.f1.e1;
                rep1 = e.f1.e2;
            } else {
                rem1 = e.f1.e2;
                rep1 = e.f1.e1;
            }
            if (boundary) {
                rep2 = null;
                rem2 = null;
            } else if (e.f2.e1 == e) {
                if (this.vertex[e.f2.e2.v1] == v2 || this.vertex[e.f2.e2.v2] == v2) {
                    rem2 = e.f2.e2;
                    rep2 = e.f2.e3;
                } else {
                    rem2 = e.f2.e3;
                    rep2 = e.f2.e2;
                }
            } else if (e.f2.e2 == e) {
                if (this.vertex[e.f2.e3.v1] == v2 || this.vertex[e.f2.e3.v2] == v2) {
                    rem2 = e.f2.e3;
                    rep2 = e.f2.e1;
                } else {
                    rem2 = e.f2.e1;
                    rep2 = e.f2.e3;
                }
            } else if (this.vertex[e.f2.e1.v1] == v2 || this.vertex[e.f2.e1.v2] == v2) {
                rem2 = e.f2.e1;
                rep2 = e.f2.e2;
            } else {
                rem2 = e.f2.e2;
                rep2 = e.f2.e1;
            }
            VertexInfo v3 = this.vertex[rep1.v1] == v1 ? this.vertex[rep1.v2] : this.vertex[rep1.v1];
            VertexInfo v4 = boundary ? null : (this.vertex[rep2.v1] == v1 ? this.vertex[rep2.v2] : this.vertex[rep2.v1]);
            MeshFace[] tempCrown = boundary && v1.faces + v2.faces - 2 > v1.crown.length ? new MeshFace[v1.faces + v2.faces - 2] : (v1.faces + v2.faces - 4 > v1.crown.length ? new MeshFace[v1.faces + v2.faces - 4] : v1.crown);
            j = 0;
            for (k = 0; k < v1.faces; ++k) {
                if (v1.crown[k] == e.f1 || v1.crown[k] == e.f2) continue;
                tempCrown[j++] = v1.crown[k];
            }
            for (k = 0; k < v2.faces; ++k) {
                if (v2.crown[k] == e.f1 || v2.crown[k] == e.f2) continue;
                tempCrown[j++] = v2.crown[k];
            }
            v1.crown = tempCrown;
            v1.faces = boundary ? v1.faces + v2.faces - 2 : v1.faces + v2.faces - 4;
            star = v1.edges + v2.edges - 2 > v1.star.length ? new MeshEdge[v1.edges + v2.edges - 2] : v1.star;
            j = 0;
            for (k = 0; k < v1.edges; ++k) {
                if (v1.star[k] == e) continue;
                star[j++] = v1.star[k];
            }
            for (k = 0; k < v2.edges; ++k) {
                if (v2.star[k] == e) continue;
                star[j++] = v2.star[k];
            }
            v1.star = star;
            v1.edges = v1.edges + v2.edges - 2;
            j = 0;
            for (k = 0; k < v3.faces; ++k) {
                if (v3.crown[k] == e.f1) continue;
                v3.crown[j++] = v3.crown[k];
            }
            --v3.faces;
            if (!boundary) {
                j = 0;
                for (k = 0; k < v4.faces; ++k) {
                    if (v4.crown[k] == e.f2) continue;
                    v4.crown[j++] = v4.crown[k];
                }
                --v4.faces;
            }
            j = 0;
            for (k = 0; k < v3.edges; ++k) {
                if (v3.star[k] == rem1) continue;
                v3.star[j++] = v3.star[k];
            }
            --v3.edges;
            if (!boundary) {
                j = 0;
                for (k = 0; k < v4.edges; ++k) {
                    if (v4.star[k] == rem2) continue;
                    v4.star[j++] = v4.star[k];
                }
                --v4.edges;
            }
            if (boundary) {
                j = e.f1.index;
                this.face[j] = this.face[this.faces - 1];
                this.face[j].index = j;
                --this.faces;
            } else {
                j = e.f1.index;
                k = e.f2.index;
                if (j < this.faces - 2 && k < this.faces - 2) {
                    this.face[j] = this.face[this.faces - 1];
                    this.face[k] = this.face[this.faces - 2];
                } else {
                    this.face[Math.min((int)j, (int)k)] = j != this.faces - 1 && k != this.faces - 1 ? this.face[this.faces - 1] : this.face[this.faces - 2];
                }
                this.face[j].index = j;
                this.face[k].index = k;
                this.faces -= 2;
            }
            Zone zone2 = v2.zone;
            while (zone2 != null) {
                zone1 = v1.zone;
                while (zone1 != null) {
                    for (j = 0; j < zone2.constraints; ++j) {
                        for (k = 0; k < zone1.constraints; ++k) {
                            if (zone2.con[j] != zone1.con[k]) continue;
                            zone2.con[j] = zone2.con[--zone2.constraints];
                        }
                    }
                    zone1 = zone1.next;
                }
                zone2 = zone2.next;
            }
            zone2 = v2.zone;
            while (zone2.next != null) {
                if (zone2.next.constraints == 0) {
                    zone2.next = zone2.next.next;
                    continue;
                }
                zone2 = zone2.next;
            }
            zone2 = v2.zone;
            zone1 = v1.zone;
            while (zone1.next != null) {
                zone1 = zone1.next;
            }
            zone1.next = zone2.constraints == 0 ? zone2.next : zone2;
            for (j = 0; j < v2.faces; ++j) {
                if (v2.crown[j].e1 == rem1) {
                    v2.crown[j].e1 = rep1;
                    continue;
                }
                if (v2.crown[j].e2 == rem1) {
                    v2.crown[j].e2 = rep1;
                    continue;
                }
                if (v2.crown[j].e3 != rem1) continue;
                v2.crown[j].e3 = rep1;
            }
            if (!boundary) {
                for (j = 0; j < v2.faces; ++j) {
                    if (v2.crown[j].e1 == rem2) {
                        v2.crown[j].e1 = rep2;
                        continue;
                    }
                    if (v2.crown[j].e2 == rem2) {
                        v2.crown[j].e2 = rep2;
                        continue;
                    }
                    if (v2.crown[j].e3 != rem2) continue;
                    v2.crown[j].e3 = rep2;
                }
            }
            if (rem1.f1 == e.f1) {
                if (rep1.f1 == e.f1) {
                    rep1.f1 = rem1.f2;
                } else {
                    rep1.f2 = rem1.f2;
                }
            } else if (rep1.f1 == e.f1) {
                rep1.f1 = rem1.f1;
            } else {
                rep1.f2 = rem1.f1;
            }
            if (rep1.f1 == null) {
                rep1.f1 = rep1.f2;
                rep1.f2 = null;
            }
            if (!boundary) {
                if (rem2.f1 == e.f2) {
                    if (rep2.f1 == e.f2) {
                        rep2.f1 = rem2.f2;
                    } else {
                        rep2.f2 = rem2.f2;
                    }
                } else if (rep2.f1 == e.f2) {
                    rep2.f1 = rem2.f1;
                } else {
                    rep2.f2 = rem2.f1;
                }
                if (rep2.f1 == null) {
                    rep2.f1 = rep2.f2;
                    rep2.f2 = null;
                }
            }
            for (j = 0; j < this.vertex.length; ++j) {
                if (this.vertex[j] != v2) continue;
                this.vertex[j] = v1;
            }
            v1.smoothness = Math.min(v1.smoothness, v2.smoothness);
            rep1.smoothness = Math.min(rep1.smoothness, rem1.smoothness);
            if (!boundary) {
                rep2.smoothness = Math.min(rep2.smoothness, rem2.smoothness);
            }
            k = this.edge.length - 1;
            for (j = this.edge.length - 1; j > i; --j) {
                if (this.edge[j] == rem1 || this.edge[j] == rem2) continue;
                this.edge[k--] = this.edge[j];
            }
            for (j = k; j > i; --j) {
                this.edge[j] = null;
            }
            skip = boundary ? 2 : 3;
            k = i + skip;
            for (j = i + skip; j < this.edge.length; ++j) {
                if (this.edge[j].cost == -1.0) {
                    this.updateCost(this.edge[j]);
                }
                if (!(this.edge[j].cost < this.edge[k].cost)) continue;
                k = j;
            }
            MeshEdge tempEdge = this.edge[i + skip];
            this.edge[i + skip] = this.edge[k];
            this.edge[k] = tempEdge;
        }
    }

    private void updateCost(MeshEdge ed) {
        double cost = this.findCost(ed);
        int v1 = ed.v1;
        ed.v1 = ed.v2;
        ed.v2 = v1;
        ed.cost = this.findCost(ed);
        if (ed.cost > cost) {
            ed.v2 = ed.v1;
            ed.v1 = v1;
            ed.cost = cost;
        }
        if (ed.cost < this.tol) {
            MeshFace f = ed.f1;
            if (!(f.e1 != ed && f.e1.f2 != null || f.e2 != ed && f.e2.f2 != null || f.e3 != ed && f.e3.f2 != null)) {
                ed.cost = this.tol;
                return;
            }
            f = ed.f2;
            if (!(f == null || f.e1 != ed && f.e1.f2 != null || f.e2 != ed && f.e2.f2 != null || f.e3 != ed && f.e3.f2 != null)) {
                ed.cost = this.tol;
                return;
            }
            if (ed.f2 != null) {
                int i;
                MeshEdge[] star = this.vertex[ed.v1].star;
                boolean v1IsBoundary = false;
                for (i = 0; i < star.length; ++i) {
                    if (star[i].f2 != null) continue;
                    v1IsBoundary = true;
                    break;
                }
                if (v1IsBoundary) {
                    star = this.vertex[ed.v2].star;
                    for (i = 0; i < star.length; ++i) {
                        if (star[i].f2 != null) continue;
                        ed.cost = this.tol;
                        return;
                    }
                }
            }
        }
    }

    private double findCost(MeshEdge ed) {
        double cost;
        int i;
        VertexInfo v1 = this.vertex[ed.v1];
        VertexInfo v2 = this.vertex[ed.v2];
        Zone zone = v2.zone;
        double max = 0.0;
        if (!ed.selected) {
            return this.tol;
        }
        for (i = 0; i < v2.faces; ++i) {
            if (v2.crown[i] == ed.f1 || v2.crown[i] == ed.f2) continue;
            MeshFace f = v2.crown[i];
            if (this.vertex[f.v1] == v2) {
                this.findNormal(v1.pos, this.vertex[f.v2].pos, this.vertex[f.v3].pos, this.temp3);
            } else if (this.vertex[f.v2] == v2) {
                this.findNormal(this.vertex[f.v1].pos, v1.pos, this.vertex[f.v3].pos, this.temp3);
            } else {
                this.findNormal(this.vertex[f.v1].pos, this.vertex[f.v2].pos, v1.pos, this.temp3);
            }
            cost = this.tol * (1.0 - this.temp3.dot(f.normal));
            if (cost >= this.tol || Double.isNaN(cost)) {
                return this.tol;
            }
            if (!(cost > max)) continue;
            max = cost;
        }
        while (zone != null) {
            for (i = 0; i < zone.constraints; ++i) {
                cost = zone.con[i].a * v1.pos.x + zone.con[i].b * v1.pos.y + zone.con[i].c * v1.pos.z + zone.con[i].d;
                if ((cost *= cost) >= this.tol) {
                    return this.tol;
                }
                if (!(cost > max)) continue;
                max = cost;
            }
            zone = zone.next;
        }
        return max;
    }

    private void findNormal(Vec3 v1, Vec3 v2, Vec3 v3, Vec3 normal) {
        this.temp1.set(v2.x, v2.y, v2.z);
        this.temp1.subtract(v1);
        this.temp2.set(v3.x, v3.y, v3.z);
        this.temp2.subtract(v1);
        normal.set(this.temp1.y * this.temp2.z - this.temp1.z * this.temp2.y, this.temp1.z * this.temp2.x - this.temp1.x * this.temp2.z, this.temp1.x * this.temp2.y - this.temp1.y * this.temp2.x);
        double length = normal.length();
        if (length < 1.0E-10) {
            normal.set(0.0, 0.0, 0.0);
        } else {
            normal.scale(1.0 / length);
        }
    }

    private class VertexInfo {
        TriangleMesh.Vertex theVert;
        Vec3 pos;
        int faces;
        int edges;
        float smoothness;
        MeshEdge[] star;
        MeshFace[] crown;
        Zone zone;

        private VertexInfo() {
        }
    }

    private class MeshFace {
        int v1;
        int v2;
        int v3;
        int index;
        int origIndex;
        MeshEdge e1;
        MeshEdge e2;
        MeshEdge e3;
        Vec3 normal;

        private MeshFace() {
        }
    }

    private class MeshEdge {
        int v1;
        int v2;
        MeshFace f1;
        MeshFace f2;
        float smoothness;
        double cost;
        boolean selected;

        private MeshEdge() {
        }
    }

    private class Zone {
        int constraints;
        Constraint[] con;
        Zone next;

        private Zone() {
        }
    }

    private class Constraint {
        double a;
        double b;
        double c;
        double d;

        private Constraint() {
        }
    }
}

