/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.LayoutWindow;
import artofillusion.Property;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.animation.ArrayKeyframe;
import artofillusion.animation.Keyframe;
import artofillusion.animation.Smoothness;
import artofillusion.animation.Timecourse;
import artofillusion.animation.Track;
import artofillusion.image.filter.ImageFilter;
import artofillusion.math.RGBColor;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.PropertyEditor;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import buoy.event.ValueChangedEvent;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.BLabel;
import buoy.widget.BTextField;
import buoy.widget.Widget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.util.ArrayList;

public class FilterParameterTrack
extends Track {
    private Object parent;
    private ImageFilter filter;
    private Timecourse tc;
    private int smoothingMethod;

    public FilterParameterTrack(Object parent, ImageFilter filter) {
        super(filter.getName());
        this.parent = parent;
        this.filter = filter;
        this.tc = new Timecourse(new Keyframe[0], new double[0], new Smoothness[0]);
        this.smoothingMethod = 2;
    }

    public ImageFilter getFilter() {
        return this.filter;
    }

    @Override
    public void apply(double time) {
        ArrayKeyframe k = (ArrayKeyframe)this.tc.evaluate(time, this.smoothingMethod);
        if (k == null) {
            return;
        }
        int index = 0;
        Property[] properties = this.filter.getProperties();
        for (int i = 0; i < properties.length; ++i) {
            if (properties[i].getType() == Property.DOUBLE) {
                this.filter.setPropertyValue(i, k.val[index++]);
                continue;
            }
            if (properties[i].getType() != Property.COLOR) continue;
            this.filter.setPropertyValue(i, new RGBColor(k.val[index++], k.val[index++], k.val[index++]));
        }
    }

    @Override
    public Track duplicate(Object obj) {
        FilterParameterTrack t = new FilterParameterTrack(obj, this.filter);
        t.name = this.name;
        t.enabled = this.enabled;
        t.quantized = this.quantized;
        t.smoothingMethod = this.smoothingMethod;
        t.tc = this.tc.duplicate(this.filter);
        return t;
    }

    @Override
    public void copy(Track tr) {
        FilterParameterTrack t = (FilterParameterTrack)tr;
        this.name = t.name;
        this.enabled = t.enabled;
        this.quantized = t.quantized;
        this.smoothingMethod = t.smoothingMethod;
        this.tc = t.tc.duplicate(this.filter);
    }

    @Override
    public double[] getKeyTimes() {
        return this.tc.getTimes();
    }

    @Override
    public Timecourse getTimecourse() {
        return this.tc;
    }

    @Override
    public void setKeyframe(double time, Keyframe k, Smoothness s) {
        this.tc.addTimepoint(k, time, s);
    }

    @Override
    public Keyframe setKeyframe(double time, Scene sc) {
        double[] key = this.getCurrentValues();
        ArrayKeyframe k = new ArrayKeyframe(key);
        this.tc.addTimepoint(k, time, new Smoothness());
        return k;
    }

    @Override
    public Keyframe setKeyframeIfModified(double time, Scene sc) {
        if (this.tc.getTimes().length == 0) {
            return this.setKeyframe(time, sc);
        }
        double[] val1 = ((ArrayKeyframe)this.tc.evaluate((double)time, (int)this.smoothingMethod)).val;
        double[] val2 = this.getCurrentValues();
        for (int i = 0; i < val1.length; ++i) {
            if (val1[i] == val2[i]) continue;
            return this.setKeyframe(time, sc);
        }
        return null;
    }

    private double[] getCurrentValues() {
        ArrayList<Double> values = new ArrayList<Double>();
        Property[] properties = this.filter.getProperties();
        for (int i = 0; i < properties.length; ++i) {
            if (properties[i].getType() == Property.DOUBLE) {
                values.add((Double)this.filter.getPropertyValue(i));
                continue;
            }
            if (properties[i].getType() != Property.COLOR) continue;
            RGBColor color = (RGBColor)this.filter.getPropertyValue(i);
            values.add(Double.valueOf(color.getRed()));
            values.add(Double.valueOf(color.getGreen()));
            values.add(Double.valueOf(color.getBlue()));
        }
        double[] val = new double[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            val[i] = (Double)values.get(i);
        }
        return val;
    }

    @Override
    public int moveKeyframe(int which, double time) {
        return this.tc.moveTimepoint(which, time);
    }

    @Override
    public void deleteKeyframe(int which) {
        this.tc.removeTimepoint(which);
    }

    @Override
    public boolean isNullTrack() {
        return this.tc.getTimes().length == 0;
    }

    @Override
    public Track[] getSubtracks() {
        return new Track[0];
    }

    @Override
    public boolean canAcceptAsParent(Object obj) {
        return false;
    }

    @Override
    public Object getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Object obj) {
        this.parent = obj;
    }

    @Override
    public int getSmoothingMethod() {
        return this.smoothingMethod;
    }

    public void setSmoothingMethod(int method) {
        this.smoothingMethod = method;
    }

    @Override
    public String[] getValueNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Property property : this.filter.getProperties()) {
            if (property.getType() == Property.DOUBLE) {
                names.add(property.getName());
                continue;
            }
            if (property.getType() != Property.COLOR) continue;
            names.add(property.getName() + " (" + Translate.text("Red") + ")");
            names.add(property.getName() + " (" + Translate.text("Green") + ")");
            names.add(property.getName() + " (" + Translate.text("Blue") + ")");
        }
        return names.toArray(new String[names.size()]);
    }

    @Override
    public double[] getDefaultGraphValues() {
        return this.getCurrentValues();
    }

    @Override
    public double[][] getValueRange() {
        ArrayList<double[]> ranges = new ArrayList<double[]>();
        for (Property property : this.filter.getProperties()) {
            if (property.getType() == Property.DOUBLE) {
                ranges.add(new double[]{property.getMinimum(), property.getMaximum()});
                continue;
            }
            if (property.getType() != Property.COLOR) continue;
            ranges.add(new double[]{0.0, Double.MAX_VALUE});
            ranges.add(new double[]{0.0, Double.MAX_VALUE});
            ranges.add(new double[]{0.0, Double.MAX_VALUE});
        }
        return (double[][])ranges.toArray((T[])new double[ranges.size()][]);
    }

    @Override
    public void writeToStream(DataOutputStream out, Scene sc) throws IOException {
        double[] t = this.tc.getTimes();
        Smoothness[] s = this.tc.getSmoothness();
        Keyframe[] v = this.tc.getValues();
        out.writeShort(0);
        out.writeUTF(this.name);
        out.writeBoolean(this.enabled);
        out.writeInt(this.smoothingMethod);
        out.writeInt(t.length);
        for (int i = 0; i < t.length; ++i) {
            out.writeDouble(t[i]);
            v[i].writeToStream(out);
            s[i].writeToStream(out);
        }
    }

    @Override
    public void initFromStream(DataInputStream in, Scene scene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.name = in.readUTF();
        this.enabled = in.readBoolean();
        this.smoothingMethod = in.readInt();
        int keys = in.readInt();
        double[] t = new double[keys];
        Smoothness[] s = new Smoothness[keys];
        Keyframe[] v = new Keyframe[keys];
        for (int i = 0; i < keys; ++i) {
            t[i] = in.readDouble();
            v[i] = new ArrayKeyframe(in, this.filter);
            s[i] = new Smoothness(in);
        }
        this.tc = new Timecourse(v, t, s);
    }

    @Override
    public void editKeyframe(LayoutWindow win, int which) {
        ArrayKeyframe key = (ArrayKeyframe)this.tc.getValues()[which];
        Smoothness s = this.tc.getSmoothness()[which];
        double time = this.tc.getTimes()[which];
        ValueField timeField = new ValueField(time, 0, 5);
        ValueSlider s1Slider = new ValueSlider(0.0, 1.0, 100, s.getLeftSmoothness());
        final ValueSlider s2Slider = new ValueSlider(0.0, 1.0, 100, s.getRightSmoothness());
        final BCheckBox sameBox = new BCheckBox(Translate.text("separateSmoothness"), !s.isForceSame());
        Property[] properties = this.filter.getProperties();
        ArrayList<PropertyEditor> editors = new ArrayList<PropertyEditor>();
        int index = 0;
        for (Property property : properties) {
            if (property.getType() == Property.DOUBLE) {
                editors.add(new PropertyEditor(property, key.val[index++]));
                continue;
            }
            if (property.getType() != Property.COLOR) continue;
            editors.add(new PropertyEditor(property, new RGBColor(key.val[index++], key.val[index++], key.val[index++])));
        }
        Widget[] widget = new Widget[editors.size() + 5];
        String[] label = new String[editors.size() + 5];
        for (int i = 0; i < editors.size(); ++i) {
            widget[i] = ((PropertyEditor)editors.get(i)).getWidget();
            label[i] = ((PropertyEditor)editors.get(i)).getLabel();
        }
        sameBox.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                s2Slider.setEnabled(sameBox.getState());
            }
        });
        s2Slider.setEnabled(sameBox.getState());
        int n = editors.size();
        widget[n] = timeField;
        widget[n + 1] = sameBox;
        widget[n + 2] = new BLabel(Translate.text("Smoothness") + ':');
        widget[n + 3] = s1Slider;
        widget[n + 4] = s2Slider;
        label[n] = Translate.text("Time");
        label[n + 3] = "(" + Translate.text("left") + ")";
        label[n + 4] = "(" + Translate.text("right") + ")";
        ComponentsDialog dlg = new ComponentsDialog(win, Translate.text("editKeyframe"), widget, label);
        if (!dlg.clickedOk()) {
            return;
        }
        win.setUndoRecord(new UndoRecord(win, false, 12, new Object[]{this, this.duplicate(this.filter)}));
        index = 0;
        for (PropertyEditor editor : editors) {
            if (editor.getProperty().getType() == Property.DOUBLE) {
                key.val[index++] = (Double)editor.getValue();
                continue;
            }
            RGBColor color = (RGBColor)editor.getValue();
            key.val[index++] = color.getRed();
            key.val[index++] = color.getGreen();
            key.val[index++] = color.getBlue();
        }
        if (sameBox.getState()) {
            s.setSmoothness(s1Slider.getValue(), s2Slider.getValue());
        } else {
            s.setSmoothness(s1Slider.getValue());
        }
        this.moveKeyframe(which, timeField.getValue());
    }

    @Override
    public void edit(LayoutWindow win) {
        BTextField nameField = new BTextField(this.getName());
        BComboBox smoothChoice = new BComboBox(new String[]{Translate.text("Discontinuous"), Translate.text("Linear"), Translate.text("Interpolating"), Translate.text("Approximating")});
        smoothChoice.setSelectedIndex(this.smoothingMethod);
        ComponentsDialog dlg = new ComponentsDialog(win, Translate.text("filterTrackTitle"), new Widget[]{nameField, smoothChoice}, new String[]{Translate.text("trackName"), Translate.text("SmoothingMethod")});
        if (!dlg.clickedOk()) {
            return;
        }
        win.setUndoRecord(new UndoRecord(win, false, 12, new Object[]{this, this.duplicate(this.filter)}));
        this.setName(nameField.getText());
        this.smoothingMethod = smoothChoice.getSelectedIndex();
    }
}

