/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.LayoutWindow;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.animation.Keyframe;
import artofillusion.animation.ScalarKeyframe;
import artofillusion.animation.Smoothness;
import artofillusion.animation.Timecourse;
import artofillusion.animation.Track;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import buoy.event.ValueChangedEvent;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.BLabel;
import buoy.widget.BTextField;
import buoy.widget.Widget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class WeightTrack
extends Track {
    Track parent;
    Timecourse tc;
    int smoothingMethod;

    public WeightTrack(Track parent) {
        super("Weight");
        this.parent = parent;
        this.tc = new Timecourse(new Keyframe[0], new double[0], new Smoothness[0]);
        this.smoothingMethod = 1;
    }

    public double getWeight(double time) {
        if (!this.enabled) {
            return 1.0;
        }
        ScalarKeyframe w = (ScalarKeyframe)this.tc.evaluate(time, this.smoothingMethod);
        if (w == null) {
            return 1.0;
        }
        if (w.val > 1.0) {
            return 1.0;
        }
        if (w.val < 0.0) {
            return 0.0;
        }
        return w.val;
    }

    @Override
    public void apply(double time) {
    }

    @Override
    public Track duplicate(Object parent) {
        WeightTrack t = new WeightTrack((Track)parent);
        t.name = this.name;
        t.enabled = this.enabled;
        t.quantized = this.quantized;
        t.smoothingMethod = this.smoothingMethod;
        t.tc = this.tc.duplicate(null);
        return t;
    }

    @Override
    public void copy(Track tr) {
        WeightTrack t = (WeightTrack)tr;
        this.name = t.name;
        this.enabled = t.enabled;
        this.quantized = t.quantized;
        this.smoothingMethod = t.smoothingMethod;
        this.tc = t.tc.duplicate(null);
    }

    @Override
    public Timecourse getTimecourse() {
        return this.tc;
    }

    public void setTimecourse(Timecourse t) {
        this.tc = t;
    }

    @Override
    public int getSmoothingMethod() {
        return this.smoothingMethod;
    }

    public void setSmoothingMethod(int method) {
        this.smoothingMethod = method;
    }

    @Override
    public double[] getKeyTimes() {
        return this.tc.getTimes();
    }

    @Override
    public void setKeyframe(double time, Keyframe k, Smoothness s) {
        this.tc.addTimepoint(k, time, s);
    }

    @Override
    public Keyframe setKeyframe(double time, Scene sc) {
        ScalarKeyframe k = new ScalarKeyframe(1.0);
        this.tc.addTimepoint(k, time, new Smoothness());
        return k;
    }

    @Override
    public int moveKeyframe(int which, double time) {
        return this.tc.moveTimepoint(which, time);
    }

    @Override
    public void deleteKeyframe(int which) {
        this.tc.removeTimepoint(which);
    }

    @Override
    public boolean isNullTrack() {
        return true;
    }

    @Override
    public Object getParent() {
        return this.parent;
    }

    @Override
    public String[] getValueNames() {
        return new String[]{"Weight"};
    }

    @Override
    public double[] getDefaultGraphValues() {
        return new double[]{1.0};
    }

    @Override
    public double[][] getValueRange() {
        return new double[][]{{0.0, 1.0}};
    }

    @Override
    public void writeToStream(DataOutputStream out, Scene scene) throws IOException {
        double[] t = this.tc.getTimes();
        Smoothness[] s = this.tc.getSmoothness();
        Keyframe[] v = this.tc.getValues();
        out.writeShort(0);
        out.writeUTF(this.name);
        out.writeBoolean(this.enabled);
        out.writeInt(this.smoothingMethod);
        out.writeInt(t.length);
        for (int i = 0; i < t.length; ++i) {
            out.writeDouble(t[i]);
            v[i].writeToStream(out);
            s[i].writeToStream(out);
        }
    }

    @Override
    public void initFromStream(DataInputStream in, Scene scene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.name = in.readUTF();
        this.enabled = in.readBoolean();
        this.smoothingMethod = in.readInt();
        int keys = in.readInt();
        double[] t = new double[keys];
        Smoothness[] s = new Smoothness[keys];
        Keyframe[] v = new Keyframe[keys];
        for (int i = 0; i < keys; ++i) {
            t[i] = in.readDouble();
            v[i] = new ScalarKeyframe(in, this.parent);
            s[i] = new Smoothness(in);
        }
        this.tc = new Timecourse(v, t, s);
    }

    @Override
    public void editKeyframe(LayoutWindow win, int which) {
        ScalarKeyframe key = (ScalarKeyframe)this.tc.getValues()[which];
        Smoothness s = this.tc.getSmoothness()[which];
        double time = this.tc.getTimes()[which];
        ValueSlider weightSlider = new ValueSlider(0.0, 1.0, 100, key.val);
        ValueField timeField = new ValueField(time, 0, 5);
        ValueSlider s1Slider = new ValueSlider(0.0, 1.0, 100, s.getLeftSmoothness());
        final ValueSlider s2Slider = new ValueSlider(0.0, 1.0, 100, s.getRightSmoothness());
        final BCheckBox sameBox = new BCheckBox(Translate.text("separateSmoothness"), !s.isForceSame());
        sameBox.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                s2Slider.setEnabled(sameBox.getState());
            }
        });
        s2Slider.setEnabled(sameBox.getState());
        ComponentsDialog dlg = new ComponentsDialog(win, Translate.text("editKeyframe"), new Widget[]{weightSlider, timeField, sameBox, new BLabel(Translate.text("Smoothness") + ':'), s1Slider, s2Slider}, new String[]{Translate.text("Weight"), Translate.text("Time"), null, null, "(" + Translate.text("left") + ")", "(" + Translate.text("right") + ")"});
        if (!dlg.clickedOk()) {
            return;
        }
        win.setUndoRecord(new UndoRecord(win, false, 12, new Object[]{this, this.duplicate(this.parent)}));
        key.val = weightSlider.getValue();
        if (sameBox.getState()) {
            s.setSmoothness(s1Slider.getValue(), s2Slider.getValue());
        } else {
            s.setSmoothness(s1Slider.getValue());
        }
        this.moveKeyframe(which, timeField.getValue());
    }

    @Override
    public void edit(LayoutWindow win) {
        BTextField nameField = new BTextField(this.getName());
        BComboBox smoothChoice = new BComboBox(new String[]{Translate.text("Discontinuous"), Translate.text("Linear"), Translate.text("Interpolating"), Translate.text("Approximating")});
        smoothChoice.setSelectedIndex(this.smoothingMethod);
        ComponentsDialog dlg = new ComponentsDialog(win, Translate.text("weightTrackTitle"), new Widget[]{nameField, smoothChoice}, new String[]{Translate.text("trackName"), Translate.text("SmoothingMethod")});
        if (!dlg.clickedOk()) {
            return;
        }
        win.setUndoRecord(new UndoRecord(win, false, 12, new Object[]{this, this.duplicate(this.parent)}));
        this.setName(nameField.getText());
        this.smoothingMethod = smoothChoice.getSelectedIndex();
    }
}

