/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation.distortion;

import artofillusion.animation.distortion.Distortion;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;

public class TransformDistortion
extends Distortion {
    private Mat4 transform;

    public TransformDistortion(Mat4 transform) {
        this.transform = transform;
    }

    @Override
    public boolean isIdenticalTo(Distortion d) {
        if (!(d instanceof TransformDistortion)) {
            return false;
        }
        TransformDistortion t = (TransformDistortion)d;
        if (this.previous != null && !this.previous.isIdenticalTo(t.previous)) {
            return false;
        }
        if (this.previous == null && t.previous != null) {
            return false;
        }
        if (this.transform == t.transform) {
            return true;
        }
        return this.transform != null && this.transform.equals(t.transform);
    }

    @Override
    public Distortion duplicate() {
        TransformDistortion d = new TransformDistortion(this.transform);
        if (this.previous != null) {
            d.previous = this.previous.duplicate();
        }
        return d;
    }

    @Override
    public Mesh transform(Mesh obj) {
        if (this.previous != null) {
            obj = this.previous.transform(obj);
        }
        Mesh newmesh = (Mesh)((Object)obj.duplicate());
        MeshVertex[] vert = newmesh.getVertices();
        Vec3[] newvert = new Vec3[vert.length];
        for (int i = 0; i < newvert.length; ++i) {
            newvert[i] = vert[i].r;
            this.transform.transform(newvert[i]);
        }
        newmesh.setVertexPositions(newvert);
        return newmesh;
    }
}

