/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.image;

import artofillusion.Scene;
import artofillusion.image.ExternalImage;
import artofillusion.image.HDREncoder;
import artofillusion.image.HDRImage;
import artofillusion.image.ImageMap;
import artofillusion.image.MIPMappedImage;
import artofillusion.image.SVGImage;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.ImageFileChooser;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import buoy.event.KeyPressedEvent;
import buoy.event.MouseClickedEvent;
import buoy.event.MouseEnteredEvent;
import buoy.event.MouseExitedEvent;
import buoy.event.ValueChangedEvent;
import buoy.event.WindowClosingEvent;
import buoy.widget.BButton;
import buoy.widget.BCheckBox;
import buoy.widget.BDialog;
import buoy.widget.BFileChooser;
import buoy.widget.BLabel;
import buoy.widget.BStandardDialog;
import buoy.widget.BTextField;
import buoy.widget.ColumnContainer;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import buoy.widget.WindowWidget;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class ImageDetailsDialog
extends BDialog {
    private WindowWidget parent;
    private Scene scene;
    private ImageMap im;
    private ArrayList<String> texturesUsing;
    private ArrayList<Integer> indicesUsing;
    private ColumnContainer fields;
    private BLabel imageField;
    private FormContainer infoTable;
    private RowContainer buttonField;
    private RowContainer dataField;
    private BufferedImage canvasImage;
    private BButton okButton;
    private BButton cancelButton;
    private BButton refreshButton;
    private BButton reconnectButton;
    private BButton convertButton;
    private BButton exportButton;
    private BLabel[] title;
    private BLabel[] data;
    private Color defaultTextColor;
    private Color errorTextColor;
    private Color hilightTextColor;
    private Color currentTextColor;

    public ImageDetailsDialog(WindowWidget parent, Scene scene, ImageMap im) {
        super(parent, "Image data", true);
        this.parent = parent;
        this.scene = scene;
        this.im = im;
        LayoutInfo left = new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, new Insets(0, 0, 0, 10), null);
        LayoutInfo top = new LayoutInfo(LayoutInfo.NORTH, LayoutInfo.NONE);
        this.createWhereUsedLists();
        this.fields = new ColumnContainer();
        this.setContent(this.fields);
        this.imageField = new BLabel();
        this.fields.add(this.imageField);
        this.infoTable = new FormContainer(2, 7 + this.texturesUsing.size());
        this.fields.add(this.infoTable);
        this.buttonField = new RowContainer();
        this.fields.add(this.buttonField);
        Font boldFont = new BLabel().getFont().deriveFont(1);
        this.title = new BLabel[7];
        this.data = new BLabel[7 + this.texturesUsing.size()];
        this.title[0] = Translate.label("imageName", ":");
        this.infoTable.add(this.title[0], 0, 0, left);
        this.title[1] = Translate.label("imageType", ":");
        this.infoTable.add(this.title[1], 0, 1, left);
        this.title[2] = Translate.label("imageSize", ":");
        this.infoTable.add(this.title[2], 0, 2, left);
        this.title[3] = Translate.label("imageLink", ":");
        this.infoTable.add(this.title[3], 0, 3, left);
        this.title[4] = Translate.label("imageCreated", ":");
        this.infoTable.add(this.title[4], 0, 4, left);
        this.title[5] = Translate.label("imageEdited", ":");
        this.infoTable.add(this.title[5], 0, 5, left);
        this.title[6] = Translate.label("imageUsedIn", ":");
        this.infoTable.add(this.title[6], 0, 6, left);
        for (int j = 0; j < 7; ++j) {
            this.data[j] = new BLabel();
            this.infoTable.add(this.data[j], 1, j, left);
            this.title[j].setFont(boldFont);
        }
        for (int q = 0; q < this.texturesUsing.size(); ++q) {
            BLabel bLabel = new BLabel(this.texturesUsing.get(q));
            this.data[q + 7] = bLabel;
            this.infoTable.add(bLabel, 1, 6 + q, left);
        }
        this.imageField.getComponent().setPreferredSize(new Dimension(600, 600));
        this.createBackground();
        this.paintImage();
        this.refreshButton = Translate.button("refreshImage", this, "refreshImage");
        this.buttonField.add(this.refreshButton);
        this.reconnectButton = Translate.button("reconnectImage", "...", this, "reconnectImage");
        this.buttonField.add(this.reconnectButton);
        this.convertButton = Translate.button("convertImage", this, "convertToLocal");
        this.buttonField.add(this.convertButton);
        this.exportButton = Translate.button("exportImage", "...", this, "exportImage");
        this.buttonField.add(this.exportButton);
        this.okButton = Translate.button("ok", this, "closeDetailsDialog");
        this.buttonField.add(this.okButton);
        if (im instanceof ExternalImage) {
            this.exportButton.setEnabled(false);
        } else {
            this.refreshButton.setEnabled(false);
            this.reconnectButton.setEnabled(false);
            this.convertButton.setEnabled(false);
        }
        this.defaultTextColor = this.currentTextColor = this.title[0].getComponent().getForeground();
        this.hilightTextColor = new Color(0, 191, 191);
        this.errorTextColor = new Color(143, 0, 0);
        this.data[0].addEventLink(MouseClickedEvent.class, (Object)this, "nameClicked");
        this.data[0].addEventLink(MouseEnteredEvent.class, (Object)this, "nameEntered");
        this.data[0].addEventLink(MouseExitedEvent.class, (Object)this, "nameExited");
        this.title[0].addEventLink(MouseClickedEvent.class, (Object)this, "nameClicked");
        this.title[0].addEventLink(MouseEnteredEvent.class, (Object)this, "nameEntered");
        this.title[0].addEventLink(MouseExitedEvent.class, (Object)this, "nameExited");
        this.addAsListener(this);
        this.addEventLink(WindowClosingEvent.class, (Object)this, "closeDetailsDialog");
        this.setDataTexts();
        this.pack();
        this.setResizable(false);
        UIUtilities.centerDialog(this, parent);
        this.setVisible(true);
    }

    private void setDataTexts() {
        for (int d = 0; d < 7; ++d) {
            this.data[d].setText(new String());
            this.currentTextColor = this.im instanceof ExternalImage && !((ExternalImage)this.im).isConnected() ? this.errorTextColor : this.defaultTextColor;
            this.data[d].getComponent().setForeground(this.currentTextColor);
        }
        this.data[0].setText(this.im.getName());
        this.data[1].setText(this.im.getType());
        this.data[2].setText(this.im.getWidth() + " x " + this.im.getHeight());
        if (this.im instanceof ExternalImage) {
            this.data[3].setText(((ExternalImage)this.im).getPath());
        }
        if (!this.im.getUserCreated().isEmpty()) {
            this.data[4].setText(this.im.getUserCreated() + " - " + this.im.getDateCreated() + " - " + this.im.getZoneCreated());
        }
        if (!this.im.getUserEdited().isEmpty()) {
            this.data[5].setText(this.im.getUserEdited() + " - " + this.im.getDateEdited() + " - " + this.im.getZoneEdited());
        }
    }

    private void createBackground() {
        int midShade = 207;
        int difference = 12;
        Color bgColor1 = new Color(midShade - difference, midShade - difference, midShade - difference);
        Color bgColor2 = new Color(midShade + difference, midShade + difference, midShade + difference);
        int rgb1 = bgColor1.getRGB();
        int rgb2 = bgColor2.getRGB();
        this.canvasImage = new BufferedImage(600, 600, 2);
        for (int x = 0; x < 600; ++x) {
            for (int y = 0; y < 600; ++y) {
                if (x % 20 < 10 && y % 20 < 10 || x % 20 >= 10 && y % 20 >= 10) {
                    this.canvasImage.setRGB(x, y, rgb1);
                    continue;
                }
                this.canvasImage.setRGB(x, y, rgb2);
            }
        }
    }

    private void createWhereUsedLists() {
        this.texturesUsing = new ArrayList();
        this.indicesUsing = new ArrayList();
        for (int t = 0; t < this.scene.getNumTextures(); ++t) {
            if (!this.scene.getTexture(t).usesImage(this.im)) continue;
            this.texturesUsing.add(this.scene.getTexture(t).getName());
            this.indicesUsing.add(t);
        }
    }

    private void paintImage() {
        try {
            Graphics2D g = this.canvasImage.createGraphics();
            Image image = this.im.getPreview(600);
            if (image == null) {
                return;
            }
            int xOffset = (600 - image.getWidth(null)) / 2;
            int yOffset = (600 - image.getHeight(null)) / 2;
            g.drawImage(image, xOffset, yOffset, null);
            this.imageField.setIcon(new ImageIcon(this.canvasImage));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void refreshImage() {
        if (!this.refreshButton.isEnabled()) {
            return;
        }
        ((ExternalImage)this.im).refreshImage();
        this.createBackground();
        this.paintImage();
        this.setDataTexts();
    }

    private void reconnectImage() {
        if (!this.reconnectButton.isEnabled()) {
            return;
        }
        ImageFileChooser fc = new ImageFileChooser(Translate.text("selectImageToLink"));
        fc.setMultipleSelectionEnabled(false);
        if (!((BFileChooser)fc).showDialog(this)) {
            return;
        }
        File file = fc.getSelectedFile();
        try {
            Scene sc = null;
            if (this.parent instanceof EditingWindow) {
                sc = ((EditingWindow)((Object)this.parent)).getScene();
            }
            ((ExternalImage)this.im).reconnectImage(file, sc);
            this.createBackground();
            this.paintImage();
            this.setDataTexts();
            if (this.parent instanceof EditingWindow) {
                ((EditingWindow)((Object)this.parent)).setModified();
            }
        }
        catch (Exception e) {
            new BStandardDialog("", Translate.text("errorLoadingImage " + file.getName()), BStandardDialog.ERROR).showMessageDialog(this);
        }
    }

    private void exportImage() {
        File imageFile;
        if (!this.exportButton.isEnabled()) {
            return;
        }
        String ext = ".png";
        if (this.im instanceof SVGImage) {
            ext = ".svg";
        }
        if (this.im instanceof HDRImage) {
            ext = ".hdr";
        }
        BFileChooser chooser = new BFileChooser(BFileChooser.SAVE_FILE, Translate.text("exportImage"));
        String imageName = this.im.getName();
        if (imageName.isEmpty()) {
            imageName = Translate.text("unTitled");
        }
        chooser.setSelectedFile(new File(imageName + ext));
        if (!chooser.showDialog(this)) {
            return;
        }
        String fileName = chooser.getSelectedFile().getName();
        if (!fileName.toLowerCase().endsWith(ext)) {
            fileName = fileName + ext;
        }
        if ((imageFile = new File(chooser.getDirectory(), fileName)).isFile()) {
            String[] options = new String[]{Translate.text("Yes"), Translate.text("No")};
            int choice = new BStandardDialog("", Translate.text("overwriteFile", (Object)fileName), BStandardDialog.QUESTION).showOptionDialog(this, options, options[1]);
            if (choice == 1) {
                return;
            }
        }
        try {
            BufferedOutputStream out;
            if (this.im instanceof HDRImage) {
                out = new BufferedOutputStream(new FileOutputStream(imageFile));
                HDREncoder.writeImage((HDRImage)this.im, (OutputStream)out);
                out.close();
                return;
            }
            if (this.im instanceof SVGImage) {
                out = new BufferedOutputStream(new FileOutputStream(imageFile));
                out.write(((SVGImage)this.im).getXML());
                out.close();
                return;
            }
            out = new BufferedOutputStream(new FileOutputStream(imageFile));
            ImageIO.write((RenderedImage)((MIPMappedImage)this.im).getImage(), "png", out);
            out.close();
            return;
        }
        catch (Exception ex) {
            this.setCursor(Cursor.getDefaultCursor());
            new BStandardDialog("", Translate.text("errorExportingImage", (Object)this.im.getName()), BStandardDialog.ERROR).showMessageDialog(this);
            ex.printStackTrace();
            return;
        }
    }

    private void convertToLocal() {
        if (!this.convertButton.isEnabled()) {
            return;
        }
        String name = this.im.getName();
        if (name.isEmpty()) {
            // empty if block
        }
        if (this.confirmConvert(name = Translate.text("unNamed"))) {
            int s;
            for (s = 0; s < this.scene.getNumImages() && this.scene.getImage(s) != this.im; ++s) {
            }
            ((ExternalImage)this.im).getImageMap().setName(this.im.getName());
            this.im = ((ExternalImage)this.im).getImageMap();
            this.scene.replaceImage(s, this.im);
            this.exportButton.setEnabled(true);
            this.refreshButton.setEnabled(false);
            this.reconnectButton.setEnabled(false);
            this.convertButton.setEnabled(false);
            this.setDataTexts();
        }
    }

    private boolean confirmConvert(String name) {
        String title = Translate.text("confirmTitle");
        String question = Translate.text("convertQuestion", (Object)name);
        BStandardDialog confirm = new BStandardDialog(title, question, BStandardDialog.QUESTION);
        String[] options = new String[]{Translate.text("Yes"), Translate.text("No")};
        return confirm.showOptionDialog(this, options, options[1]) == 0;
    }

    private void closeDetailsDialog() {
        this.dispose();
        this.removeAsListener(this);
    }

    private void keyPressed(KeyPressedEvent ev) {
        int code = ev.getKeyCode();
        if (code == 27) {
            this.closeDetailsDialog();
        }
    }

    private void addAsListener(Widget w) {
        w.addEventLink(KeyPressedEvent.class, (Object)this, "keyPressed");
        if (w instanceof WidgetContainer) {
            Iterator<Widget> iter = ((WidgetContainer)w).getChildren().iterator();
            while (iter.hasNext()) {
                this.addAsListener(iter.next());
            }
        }
    }

    private void removeAsListener(Widget w) {
        w.removeEventLink(KeyPressedEvent.class, this);
        if (w instanceof WidgetContainer) {
            Iterator<Widget> iter = ((WidgetContainer)w).getChildren().iterator();
            while (iter.hasNext()) {
                this.removeAsListener(iter.next());
            }
        }
    }

    private void nameEntered() {
        this.title[0].getComponent().setForeground(this.hilightTextColor);
        this.data[0].getComponent().setForeground(this.hilightTextColor);
    }

    private void nameExited() {
        this.title[0].getComponent().setForeground(this.defaultTextColor);
        this.data[0].getComponent().setForeground(this.currentTextColor);
    }

    private void nameClicked() {
        new ImageNameEditor(this.im, this);
    }

    private class ImageNameEditor
    extends BDialog {
        private ColumnContainer content;
        private BTextField nameField;
        private BCheckBox autoBox;
        private BButton okButton;
        private BButton cancelButton;
        private String autoText;
        private String userText;
        private boolean automatic = false;

        private ImageNameEditor(ImageMap im, WindowWidget parent) {
            this.setTitle(Translate.text("nameDialogTitle"));
            this.content = new ColumnContainer();
            RowContainer buttons = new RowContainer();
            this.setContent(this.content);
            this.nameField = new BTextField(im.getName());
            this.content.add(this.nameField);
            this.autoText = this.userText = im.getName();
            if (im instanceof ExternalImage) {
                try {
                    String fileName = im.getFile().getName();
                    this.autoText = fileName.substring(0, fileName.lastIndexOf(46));
                }
                catch (Exception fileName) {
                    // empty catch block
                }
                this.automatic = ((ExternalImage)im).isNameAutomatic();
                this.autoBox = new BCheckBox(Translate.text("Automatic"), this.automatic);
                this.content.add(this.autoBox);
                this.autoBox.addEventLink(ValueChangedEvent.class, (Object)this, "autoChanged");
                this.autoChanged();
            }
            this.nameField.setColumns(50);
            this.nameField.addEventLink(ValueChangedEvent.class, (Object)this, "textChanged");
            this.content.add(buttons);
            this.okButton = Translate.button("ok", this, "okNameEditor");
            buttons.add(this.okButton);
            this.cancelButton = Translate.button("cancel", this, "cancelNameEditor");
            buttons.add(this.cancelButton);
            this.addEventLink(WindowClosingEvent.class, (Object)this, "cancelNameEditor");
            this.addAsListener(this);
            this.layoutChildren();
            this.pack();
            this.setResizable(false);
            this.setModal(true);
            Rectangle pb = parent.getBounds();
            Rectangle tb = this.getBounds();
            this.getComponent().setLocation(pb.x + (pb.width - tb.width) / 2, pb.y + (625 - tb.height));
            this.setVisible(true);
        }

        private void textChanged() {
            if (!this.automatic) {
                this.userText = this.nameField.getText();
            }
        }

        private void autoChanged() {
            this.automatic = this.autoBox.getState();
            this.nameField.setEnabled(!this.automatic);
            if (this.automatic) {
                this.nameField.setText(this.autoText);
            } else {
                this.nameField.setText(this.userText);
            }
        }

        private void cancelNameEditor() {
            this.dispose();
            this.removeAsListener(this);
        }

        private void okNameEditor() {
            if (this.automatic) {
                ImageDetailsDialog.this.im.setName(this.autoText);
            } else {
                ImageDetailsDialog.this.im.setName(this.userText);
            }
            if (ImageDetailsDialog.this.im instanceof ExternalImage) {
                ((ExternalImage)ImageDetailsDialog.this.im).setNameAutomatic(this.automatic);
            }
            ImageDetailsDialog.this.im.setDataEdited();
            ImageDetailsDialog.this.setDataTexts();
            this.dispose();
            this.removeAsListener(this);
        }

        private void keyPressed(KeyPressedEvent ev) {
            int code = ev.getKeyCode();
            if (code == 27) {
                this.cancelNameEditor();
            }
            if (code == 10) {
                this.okNameEditor();
            }
        }

        private void addAsListener(Widget w) {
            w.addEventLink(KeyPressedEvent.class, (Object)this, "keyPressed");
            if (w instanceof WidgetContainer) {
                Iterator<Widget> iter = ((WidgetContainer)w).getChildren().iterator();
                while (iter.hasNext()) {
                    this.addAsListener(iter.next());
                }
            }
        }

        private void removeAsListener(Widget w) {
            w.removeEventLink(KeyPressedEvent.class, this);
            if (w instanceof WidgetContainer) {
                Iterator<Widget> iter = ((WidgetContainer)w).getChildren().iterator();
                while (iter.hasNext()) {
                    this.removeAsListener(iter.next());
                }
            }
        }
    }
}

