/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.image;

import artofillusion.image.HDRDecoder;
import artofillusion.image.HDRImage;
import artofillusion.image.MIPMappedImage;
import artofillusion.image.SVGImage;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec2;
import java.awt.Image;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Date;

public abstract class ImageMap {
    protected String imageName = new String();
    protected String userCreated = new String();
    protected Date dateCreated;
    protected String zoneCreated = new String();
    protected String userEdited = new String();
    protected Date dateEdited;
    protected String zoneEdited = new String();
    public static final int PREVIEW_WIDTH = 50;
    public static final int PREVIEW_HEIGHT = 50;
    public static final int PREVIEW_SIZE_DEFAULT = 50;
    public static final int PREVIEW_SIZE_TEMPLATE = 256;
    public static final String IMAGE_TYPE_RGB = "RGB";
    public static final String IMAGE_TYPE_RGBA = "RGBA";
    public static final String IMAGE_TYPE_GRAY = "GRAY";
    public static final String IMAGE_TYPE_SVG = "SVG";
    public static final String IMAGE_TYPE_HDR = "HDR";
    private int id = nextID++;
    private static int nextID;

    public static ImageMap loadImage(File file) throws Exception {
        String name = file.getName().toLowerCase();
        if (name.endsWith(".hdr") || name.endsWith(".hdri") || name.endsWith(".pic")) {
            try {
                HDRImage im = HDRDecoder.createImage(file);
                im.setDataCreated(file);
                return im;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (name.endsWith(".svg")) {
            return new SVGImage(file);
        }
        return new MIPMappedImage(file);
    }

    public abstract int getWidth();

    public abstract int getHeight();

    public abstract float getAspectRatio();

    public abstract int getComponentCount();

    public abstract float getComponent(int var1, boolean var2, boolean var3, double var4, double var6, double var8, double var10);

    public abstract float getAverageComponent(int var1);

    public abstract void getColor(RGBColor var1, boolean var2, boolean var3, double var4, double var6, double var8, double var10);

    public abstract void getGradient(Vec2 var1, int var2, boolean var3, boolean var4, double var5, double var7, double var9, double var11);

    public abstract Image getPreview();

    public abstract Image getPreview(int var1);

    public int getID() {
        return this.id;
    }

    protected void setDataCreated(File file) {
        String fileName = file.getName();
        this.imageName = fileName.substring(0, fileName.lastIndexOf(46));
        this.userCreated = System.getProperty("user.name");
        this.zoneCreated = System.getProperty("user.timezone");
        this.dateCreated = new Date();
        this.userEdited = this.userCreated;
        this.zoneEdited = this.zoneCreated;
        this.dateEdited = (Date)this.dateCreated.clone();
    }

    protected void setDataEdited() {
        this.userEdited = System.getProperty("user.name");
        this.zoneEdited = System.getProperty("user.timezone");
        this.dateEdited = new Date();
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public String getZoneCreated() {
        return this.zoneCreated;
    }

    public String getUserCreated() {
        return this.userCreated;
    }

    public Date getDateEdited() {
        return this.dateEdited;
    }

    public String getZoneEdited() {
        return this.zoneEdited;
    }

    public String getUserEdited() {
        return this.userEdited;
    }

    public String getName() {
        return this.imageName;
    }

    public File getFile() {
        return null;
    }

    public String getType() {
        return new String();
    }

    public void setName(String newName) {
        this.imageName = newName;
        this.setDataEdited();
    }

    public abstract void writeToStream(DataOutputStream var1) throws IOException;
}

