/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.keystroke;

import artofillusion.keystroke.KeystrokePreferencesPanel;
import artofillusion.keystroke.KeystrokeRecord;
import artofillusion.script.ScriptEditor;
import artofillusion.script.ScriptRunner;
import artofillusion.ui.Translate;
import buoy.event.KeyPressedEvent;
import buoy.widget.BButton;
import buoy.widget.BComboBox;
import buoy.widget.BDialog;
import buoy.widget.BTextField;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.WindowWidget;
import java.awt.Insets;

public class KeystrokeEditor
extends BDialog {
    private BTextField keyField;
    private BTextField nameField;
    private BComboBox languageChoice;
    private ScriptEditor scriptArea;
    private BButton okButton;
    private KeystrokeRecord record;
    private static final int[] RESERVED_CODES = new int[]{37, 39, 38, 40, 10, 27, 9, 16, 18, 17, 157};

    public static KeystrokeRecord showEditorDialog(KeystrokeRecord record, WindowWidget parent) {
        KeystrokeEditor editor = new KeystrokeEditor(record, parent);
        editor.setVisible(true);
        return editor.record;
    }

    private KeystrokeEditor(KeystrokeRecord record, WindowWidget parent) {
        super(parent, true);
        FormContainer content = new FormContainer(new double[]{0.0, 1.0}, new double[]{0.0, 0.0, 0.0, 0.0, 1.0, 0.0});
        this.setContent(content);
        this.record = record.duplicate();
        this.keyField = new BTextField(KeystrokePreferencesPanel.getKeyDescription(record.getKeyCode(), record.getModifiers()));
        this.keyField.setEditable(false);
        this.keyField.addEventLink(KeyPressedEvent.class, (Object)this, "setKey");
        this.nameField = new BTextField(record.getName());
        this.languageChoice = new BComboBox(ScriptRunner.LANGUAGES);
        this.languageChoice.setSelectedValue(record.getLanguage());
        this.scriptArea = new ScriptEditor(record.getScript());
        LayoutInfo rightLayout = new LayoutInfo(LayoutInfo.EAST, LayoutInfo.NONE);
        LayoutInfo fillLayout = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.HORIZONTAL, new Insets(2, 2, 2, 2), null);
        content.add(Translate.label("Key"), 0, 0, rightLayout);
        content.add(Translate.label("Name"), 0, 1, rightLayout);
        content.add(Translate.label("language"), 0, 2, rightLayout);
        content.add(this.keyField, 1, 0, fillLayout);
        content.add(this.nameField, 1, 1, fillLayout);
        content.add(this.languageChoice, 1, 2, new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE));
        content.add(Translate.label("Script"), 0, 3, 2, 1, new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, null, null));
        content.add(this.scriptArea.createContainer(), 0, 4, 2, 1, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH));
        RowContainer buttons = new RowContainer();
        content.add(buttons, 0, 5, 2, 1);
        this.okButton = Translate.button("ok", this, "clickedOk");
        buttons.add(this.okButton);
        buttons.add(Translate.button("cancel", this, "clickedCancel"));
        this.enableOkButton();
        this.pack();
    }

    private void clickedOk() {
        this.record.setName(this.nameField.getText());
        this.record.setLanguage(this.languageChoice.getSelectedValue().toString());
        this.record.setScript(this.scriptArea.getText());
        this.dispose();
    }

    private void clickedCancel() {
        this.record = null;
        this.dispose();
    }

    private void enableOkButton() {
        this.okButton.setEnabled(this.record.getKeyCode() != 0);
    }

    private void setKey(KeyPressedEvent ev) {
        int code = ev.getKeyCode();
        for (int i = 0; i < RESERVED_CODES.length; ++i) {
            if (code != RESERVED_CODES[i]) continue;
            return;
        }
        int modifiers = ev.getModifiers() & 9;
        this.record.setKeyCode(code);
        this.record.setModifiers(modifiers);
        this.keyField.setText(KeystrokePreferencesPanel.getKeyDescription(code, modifiers));
        this.enableOkButton();
    }
}

