/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.material;

import artofillusion.MaterialPreviewer;
import artofillusion.material.Material;
import artofillusion.material.Material3D;
import artofillusion.material.MaterialMapping;
import artofillusion.material.MaterialSpec;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.Object3D;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import buoy.event.ValueChangedEvent;
import buoy.widget.BCheckBox;
import buoy.widget.BLabel;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.Widget;
import java.awt.Insets;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class LinearMaterialMapping
extends MaterialMapping {
    protected CoordinateSystem coords;
    protected double ax;
    protected double bx;
    protected double cx;
    protected double dx;
    protected double ay;
    protected double by;
    protected double cy;
    protected double dy;
    protected double az;
    protected double bz;
    protected double cz;
    protected double dz;
    protected double xscale;
    protected double yscale;
    protected double zscale;
    protected boolean scaleToObject;

    public LinearMaterialMapping(Object3D theObject, Material3D theMaterial) {
        super(theObject, theMaterial);
        this.coords = new CoordinateSystem(new Vec3(), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 1.0, 0.0));
        this.zscale = 1.0;
        this.yscale = 1.0;
        this.xscale = 1.0;
        this.dz = 0.0;
        this.dy = 0.0;
        this.dx = 0.0;
        this.findCoefficients();
    }

    public static String getName() {
        return "Linear";
    }

    public static boolean legalMapping(Object3D obj, Material mat) {
        return mat instanceof Material3D;
    }

    private void findCoefficients() {
        Vec3 zdir = this.coords.getZDirection();
        Vec3 ydir = this.coords.getUpDirection();
        Vec3 xdir = ydir.cross(zdir);
        this.ax = xdir.x / this.xscale;
        this.bx = xdir.y / this.xscale;
        this.cx = xdir.z / this.xscale;
        this.ay = ydir.x / this.yscale;
        this.by = ydir.y / this.yscale;
        this.cy = ydir.z / this.yscale;
        this.az = zdir.x / this.zscale;
        this.bz = zdir.y / this.zscale;
        this.cz = zdir.z / this.zscale;
    }

    public Vec3 getCenter() {
        return new Vec3(this.dx, this.dy, this.dz);
    }

    public void setCenter(Vec3 center) {
        this.dx = center.x;
        this.dy = center.y;
        this.dz = center.z;
        this.findCoefficients();
    }

    public Vec3 getScale() {
        return new Vec3(this.xscale, this.yscale, this.zscale);
    }

    public void setScale(Vec3 scale) {
        this.xscale = scale.x;
        this.yscale = scale.y;
        this.zscale = scale.z;
        this.findCoefficients();
    }

    public boolean isScaledToObject() {
        return this.scaleToObject;
    }

    public void setScaledToObject(boolean scaled) {
        this.scaleToObject = scaled;
    }

    public Vec3 getRotations() {
        double[] angles = this.coords.getRotationAngles();
        return new Vec3(angles[0], angles[1], angles[2]);
    }

    public void setRotations(Vec3 angles) {
        this.coords.setOrientation(angles.x, angles.y, angles.z);
        this.findCoefficients();
    }

    @Override
    public double getStepSize() {
        if (this.scaleToObject) {
            double sizez;
            double sizey = sizez = this.material.getStepSize();
            double sizex = sizez;
            BoundingBox bounds = this.getObject().getBounds();
            if (bounds.maxx > bounds.minx) {
                sizex /= bounds.maxx - bounds.minx;
            }
            if (bounds.maxy > bounds.miny) {
                sizey /= bounds.maxy - bounds.miny;
            }
            if (bounds.maxz > bounds.minz) {
                sizez /= bounds.maxz - bounds.minz;
            }
            return Math.abs(Math.min(Math.min(this.length(this.ax * sizex, this.bx * sizey, this.cx * sizez), this.length(this.ay * sizex, this.by * sizey, this.cy * sizez)), this.length(this.az * sizex, this.bz * sizey, this.cz * sizez)));
        }
        return Math.abs(this.material.getStepSize() / Math.max(Math.max(this.xscale, this.yscale), this.zscale));
    }

    @Override
    public void getMaterialSpec(Vec3 pos, MaterialSpec spec, double size, double time) {
        double x = pos.x;
        double y = pos.y;
        double z = pos.z;
        double sizex = size;
        double sizey = size;
        double sizez = size;
        if (this.scaleToObject) {
            double scale;
            BoundingBox bounds = this.getObject().getBounds();
            if (bounds.maxx > bounds.minx) {
                scale = 1.0 / (bounds.maxx - bounds.minx);
                x *= scale;
                sizex = size * scale;
            }
            if (bounds.maxy > bounds.miny) {
                scale = 1.0 / (bounds.maxy - bounds.miny);
                y *= scale;
                sizey = size * scale;
            }
            if (bounds.maxz > bounds.minz) {
                scale = 1.0 / (bounds.maxz - bounds.minz);
                z *= scale;
                sizez = size * scale;
            }
        }
        ((Material3D)this.material).getMaterialSpec(spec, x * this.ax + y * this.bx + z * this.cx - this.dx, x * this.ay + y * this.by + z * this.cy - this.dy, x * this.az + y * this.bz + z * this.cz - this.dz, this.length(this.ax * sizex, this.bx * sizey, this.cx * sizez), this.length(this.ay * sizex, this.by * sizey, this.cy * sizez), this.length(this.az * sizex, this.bz * sizey, this.cz * sizez), time);
    }

    private double length(double x, double y, double z) {
        return Math.sqrt(x * x + y * y + z * z);
    }

    @Override
    public MaterialMapping duplicate() {
        return this.duplicate(this.object, this.material);
    }

    @Override
    public MaterialMapping duplicate(Object3D obj, Material mat) {
        LinearMaterialMapping map = new LinearMaterialMapping(obj, (Material3D)mat);
        map.coords = this.coords.duplicate();
        map.dx = this.dx;
        map.dy = this.dy;
        map.dz = this.dz;
        map.xscale = this.xscale;
        map.yscale = this.yscale;
        map.zscale = this.zscale;
        map.scaleToObject = this.scaleToObject;
        map.findCoefficients();
        return map;
    }

    @Override
    public void copy(MaterialMapping mapping) {
        LinearMaterialMapping map = (LinearMaterialMapping)mapping;
        this.coords = map.coords.duplicate();
        this.dx = map.dx;
        this.dy = map.dy;
        this.dz = map.dz;
        this.xscale = map.xscale;
        this.yscale = map.yscale;
        this.zscale = map.zscale;
        this.scaleToObject = map.scaleToObject;
        this.findCoefficients();
    }

    @Override
    public Widget getEditingPanel(Object3D obj, MaterialPreviewer preview) {
        return new Editor(obj, preview);
    }

    public LinearMaterialMapping(DataInputStream in, Object3D theObject, Material theMaterial) throws IOException, InvalidObjectException {
        super(theObject, theMaterial);
        short version = in.readShort();
        if (version < 0 || version > 1) {
            throw new InvalidObjectException("");
        }
        this.coords = new CoordinateSystem(in);
        this.dx = in.readDouble();
        this.dy = in.readDouble();
        this.dz = in.readDouble();
        this.xscale = in.readDouble();
        this.yscale = in.readDouble();
        this.zscale = in.readDouble();
        this.scaleToObject = version > 0 ? in.readBoolean() : false;
        this.findCoefficients();
    }

    @Override
    public void writeToFile(DataOutputStream out) throws IOException {
        out.writeShort(1);
        this.coords.writeToFile(out);
        out.writeDouble(this.dx);
        out.writeDouble(this.dy);
        out.writeDouble(this.dz);
        out.writeDouble(this.xscale);
        out.writeDouble(this.yscale);
        out.writeDouble(this.zscale);
        out.writeBoolean(this.scaleToObject);
    }

    private class Editor
    extends FormContainer {
        ValueField xrotField;
        ValueField yrotField;
        ValueField zrotField;
        ValueField xscaleField;
        ValueField yscaleField;
        ValueField zscaleField;
        ValueField xtransField;
        ValueField ytransField;
        ValueField ztransField;
        BCheckBox scaleToObjectBox;
        Object3D theObject;
        MaterialPreviewer preview;

        public Editor(Object3D obj, MaterialPreviewer preview) {
            super(6, 7);
            this.theObject = obj;
            this.preview = preview;
            this.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(0, 0, 0, 5), null));
            this.add(new BLabel(Translate.text("Scale") + ":"), 0, 0, 3, 1);
            this.add(new BLabel("X"), 0, 1);
            this.xscaleField = new ValueField(LinearMaterialMapping.this.xscale, 2, 5);
            this.add(this.xscaleField, 1, 1);
            this.add(new BLabel("Y"), 2, 1);
            this.yscaleField = new ValueField(LinearMaterialMapping.this.yscale, 2, 5);
            this.add(this.yscaleField, 3, 1);
            this.add(new BLabel("Z"), 4, 1);
            this.zscaleField = new ValueField(LinearMaterialMapping.this.zscale, 2, 5);
            this.add(this.zscaleField, 5, 1);
            this.add(new BLabel(Translate.text("Center") + ":"), 0, 2, 3, 1);
            this.add(new BLabel("X"), 0, 3);
            this.xtransField = new ValueField(LinearMaterialMapping.this.dx, 0, 5);
            this.add(this.xtransField, 1, 3);
            this.add(new BLabel("Y"), 2, 3);
            this.ytransField = new ValueField(LinearMaterialMapping.this.dy, 0, 5);
            this.add(this.ytransField, 3, 3);
            this.add(new BLabel("Z"), 4, 3);
            this.ztransField = new ValueField(LinearMaterialMapping.this.dz, 0, 5);
            this.add(this.ztransField, 5, 3);
            double[] angles = LinearMaterialMapping.this.coords.getRotationAngles();
            this.add(new BLabel(Translate.text("Rotation") + ":"), 0, 4, 3, 1);
            this.add(new BLabel("X"), 0, 5);
            this.xrotField = new ValueField(angles[0], 0, 5);
            this.add(this.xrotField, 1, 5);
            this.add(new BLabel("Y"), 2, 5);
            this.yrotField = new ValueField(angles[1], 0, 5);
            this.add(this.yrotField, 3, 5);
            this.add(new BLabel("Z"), 4, 5);
            this.zrotField = new ValueField(angles[2], 0, 5);
            this.add(this.zrotField, 5, 5);
            this.scaleToObjectBox = new BCheckBox(Translate.text("scaleMatToObject"), LinearMaterialMapping.this.scaleToObject);
            this.add(this.scaleToObjectBox, 0, 6, 6, 1);
            this.xscaleField.addEventLink(ValueChangedEvent.class, this);
            this.yscaleField.addEventLink(ValueChangedEvent.class, this);
            this.zscaleField.addEventLink(ValueChangedEvent.class, this);
            this.xtransField.addEventLink(ValueChangedEvent.class, this);
            this.ytransField.addEventLink(ValueChangedEvent.class, this);
            this.ztransField.addEventLink(ValueChangedEvent.class, this);
            this.xrotField.addEventLink(ValueChangedEvent.class, this);
            this.yrotField.addEventLink(ValueChangedEvent.class, this);
            this.zrotField.addEventLink(ValueChangedEvent.class, this);
            this.scaleToObjectBox.addEventLink(ValueChangedEvent.class, this);
        }

        private void processEvent() {
            LinearMaterialMapping.this.xscale = this.xscaleField.getValue();
            LinearMaterialMapping.this.yscale = this.yscaleField.getValue();
            LinearMaterialMapping.this.zscale = this.zscaleField.getValue();
            LinearMaterialMapping.this.dx = this.xtransField.getValue();
            LinearMaterialMapping.this.dy = this.ytransField.getValue();
            LinearMaterialMapping.this.dz = this.ztransField.getValue();
            LinearMaterialMapping.this.coords.setOrientation(this.xrotField.getValue(), this.yrotField.getValue(), this.zrotField.getValue());
            LinearMaterialMapping.this.scaleToObject = this.scaleToObjectBox.getState();
            LinearMaterialMapping.this.findCoefficients();
            this.preview.render();
        }
    }
}

