/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.ArtOfIllusion;
import artofillusion.CompoundImplicitEditorWindow;
import artofillusion.animation.Keyframe;
import artofillusion.animation.RotationKeyframe;
import artofillusion.animation.VectorKeyframe;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.ImplicitObject;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.EditingWindow;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;

public class CompoundImplicitObject
extends ImplicitObject {
    private ArrayList<ImplicitObject> objects = new ArrayList();
    private ArrayList<CoordinateSystem> objectCoords = new ArrayList();
    private BoundingBox bounds;
    private volatile ArrayList<ArrayList<Integer>> grid;
    private int gridSize;
    private double cutoff = 1.0;

    public void addObject(ImplicitObject obj, CoordinateSystem coords) {
        this.objects.add(obj);
        this.objectCoords.add(coords.duplicate());
        this.objectsChanged();
    }

    public int getNumObjects() {
        return this.objects.size();
    }

    public ImplicitObject getObject(int index) {
        return this.objects.get(index);
    }

    public void setObject(int index, ImplicitObject obj) {
        this.objects.set(index, obj);
        this.objectsChanged();
    }

    public CoordinateSystem getObjectCoordinates(int index) {
        return this.objectCoords.get(index).duplicate();
    }

    public void setObjectCoordinates(int index, CoordinateSystem coords) {
        this.objectCoords.set(index, coords.duplicate());
        this.objectsChanged();
    }

    private void objectsChanged() {
        this.bounds = null;
        this.grid = null;
        this.clearCachedMesh();
    }

    @Override
    public double getCutoff() {
        return this.cutoff;
    }

    public void setCutoff(double cutoff) {
        this.cutoff = cutoff;
    }

    @Override
    public double getFieldValue(double x, double y, double z, double size, double time) {
        double value = 0.0;
        Vec3 pos = new Vec3();
        ArrayList<Integer> indices = this.findObjectsNearPoint(x, y, z);
        for (int i = 0; i < indices.size(); ++i) {
            int index = indices.get(i);
            Mat4 toLocal = this.objectCoords.get(index).toLocal();
            pos.set(x, y, z);
            toLocal.transform(pos);
            ImplicitObject obj = this.objects.get(index);
            if (!obj.getBounds().contains(pos)) continue;
            value += obj.getFieldValue(pos.x, pos.y, pos.z, size, time);
        }
        return value;
    }

    @Override
    public void getFieldGradient(double x, double y, double z, double size, double time, Vec3 grad) {
        double dx = 0.0;
        double dy = 0.0;
        double dz = 0.0;
        Vec3 pos = new Vec3();
        ArrayList<Integer> indices = this.findObjectsNearPoint(x, y, z);
        for (int i = 0; i < indices.size(); ++i) {
            int index = indices.get(i);
            Mat4 toLocal = this.objectCoords.get(index).toLocal();
            pos.set(x, y, z);
            toLocal.transform(pos);
            ImplicitObject obj = this.objects.get(index);
            if (!obj.getBounds().contains(pos)) continue;
            obj.getFieldGradient(pos.x, pos.y, pos.z, size, time, grad);
            dx += grad.x;
            dy += grad.y;
            dz += grad.z;
        }
        grad.set(dx, dy, dz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<Integer> findObjectsNearPoint(double x, double y, double z) {
        BoundingBox gridBounds = this.getBounds();
        if (this.grid == null) {
            int i;
            CompoundImplicitObject compoundImplicitObject = this;
            synchronized (compoundImplicitObject) {
                if (this.grid == null) {
                    this.gridSize = (int)Math.ceil(Math.pow(this.objects.size(), 0.3333333333333333));
                    this.grid = new ArrayList(this.gridSize * this.gridSize * this.gridSize);
                    for (i = 0; i < this.gridSize * this.gridSize * this.gridSize; ++i) {
                        this.grid.add(null);
                    }
                    for (int index = 0; index < this.objects.size(); ++index) {
                        BoundingBox objBounds = this.objects.get(index).getBounds().transformAndOutset(this.objectCoords.get(index).fromLocal());
                        int minx = (int)Math.floor((double)this.gridSize * (objBounds.minx - gridBounds.minx) / (gridBounds.maxx - gridBounds.minx));
                        int maxx = (int)Math.ceil((double)this.gridSize * (objBounds.maxx - gridBounds.minx) / (gridBounds.maxx - gridBounds.minx));
                        int miny = (int)Math.floor((double)this.gridSize * (objBounds.miny - gridBounds.miny) / (gridBounds.maxy - gridBounds.miny));
                        int maxy = (int)Math.ceil((double)this.gridSize * (objBounds.maxy - gridBounds.miny) / (gridBounds.maxy - gridBounds.miny));
                        int minz = (int)Math.floor((double)this.gridSize * (objBounds.minz - gridBounds.minz) / (gridBounds.maxz - gridBounds.minz));
                        int maxz = (int)Math.ceil((double)this.gridSize * (objBounds.maxz - gridBounds.minz) / (gridBounds.maxz - gridBounds.minz));
                        minx = Math.max(0, Math.min(this.gridSize - 1, minx));
                        maxx = Math.max(0, Math.min(this.gridSize - 1, maxx));
                        miny = Math.max(0, Math.min(this.gridSize - 1, miny));
                        maxy = Math.max(0, Math.min(this.gridSize - 1, maxy));
                        minz = Math.max(0, Math.min(this.gridSize - 1, minz));
                        maxz = Math.max(0, Math.min(this.gridSize - 1, maxz));
                        for (int i2 = minx; i2 <= maxx; ++i2) {
                            for (int j = miny; j <= maxy; ++j) {
                                for (int k = minz; k <= maxz; ++k) {
                                    int n = k + this.gridSize * (j + this.gridSize * i2);
                                    if (this.grid.get(n) == null) {
                                        this.grid.set(n, new ArrayList());
                                    }
                                    this.grid.get(n).add(index);
                                }
                            }
                        }
                    }
                }
            }
            ArrayList empty = new ArrayList();
            for (i = 0; i < this.gridSize * this.gridSize * this.gridSize; ++i) {
                if (this.grid.get(i) != null) continue;
                this.grid.set(i, empty);
            }
        }
        int i = (int)((double)this.gridSize * (x - gridBounds.minx) / (gridBounds.maxx - gridBounds.minx));
        int j = (int)((double)this.gridSize * (y - gridBounds.miny) / (gridBounds.maxy - gridBounds.miny));
        int k = (int)((double)this.gridSize * (z - gridBounds.minz) / (gridBounds.maxz - gridBounds.minz));
        i = Math.max(0, Math.min(this.gridSize - 1, i));
        j = Math.max(0, Math.min(this.gridSize - 1, j));
        k = Math.max(0, Math.min(this.gridSize - 1, k));
        return this.grid.get(k + this.gridSize * (j + this.gridSize * i));
    }

    @Override
    public boolean getPreferDirectRendering() {
        return true;
    }

    @Override
    public Object3D duplicate() {
        CompoundImplicitObject c = new CompoundImplicitObject();
        c.copyObject(this);
        return c;
    }

    @Override
    public void copyObject(Object3D obj) {
        CompoundImplicitObject c = (CompoundImplicitObject)obj;
        this.objects.clear();
        this.objectCoords.clear();
        for (int i = 0; i < c.getNumObjects(); ++i) {
            this.addObject((ImplicitObject)c.getObject(i).duplicate(), c.getObjectCoordinates(i).duplicate());
        }
    }

    @Override
    public synchronized BoundingBox getBounds() {
        if (this.bounds == null) {
            if (this.objects.isEmpty()) {
                this.bounds = new BoundingBox(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            } else {
                this.bounds = this.objects.get(0).getBounds().transformAndOutset(this.objectCoords.get(0).fromLocal());
                for (int i = 1; i < this.objects.size(); ++i) {
                    this.bounds = this.bounds.merge(this.objects.get(i).getBounds().transformAndOutset(this.objectCoords.get(i).fromLocal()));
                }
            }
        }
        return this.bounds;
    }

    @Override
    public void setSize(double xsize, double ysize, double zsize) {
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public void edit(EditingWindow parent, ObjectInfo info, Runnable cb) {
        new CompoundImplicitEditorWindow(parent, info.getName(), this, cb);
    }

    @Override
    public Keyframe getPoseKeyframe() {
        ArrayList<Keyframe> key = new ArrayList<Keyframe>();
        ArrayList<CoordinateSystem> coords = new ArrayList<CoordinateSystem>();
        for (int i = 0; i < this.getNumObjects(); ++i) {
            key.add(this.getObject(i).getPoseKeyframe());
            coords.add(this.getObjectCoordinates(i).duplicate());
        }
        return new CompoundImplicitKeyframe(key, coords);
    }

    @Override
    public void applyPoseKeyframe(Keyframe k) {
        CompoundImplicitKeyframe key = (CompoundImplicitKeyframe)k;
        for (int i = 0; i < this.getNumObjects(); ++i) {
            if (key.key.get(i) != null) {
                this.objects.get(i).applyPoseKeyframe(key.key.get(i));
            }
            this.objectCoords.get(i).copyCoords(key.coords.get(i));
        }
        this.objectsChanged();
    }

    @Override
    public void editKeyframe(EditingWindow parent, final Keyframe k, final ObjectInfo info) {
        final CompoundImplicitObject copy = (CompoundImplicitObject)this.duplicate();
        copy.applyPoseKeyframe(k);
        Runnable onClose = new Runnable(){

            @Override
            public void run() {
                CompoundImplicitKeyframe original = (CompoundImplicitKeyframe)k;
                CompoundImplicitKeyframe edited = (CompoundImplicitKeyframe)copy.getPoseKeyframe().duplicate(info);
                original.key = edited.key;
                original.coords = edited.coords;
            }
        };
        new CompoundImplicitEditorWindow(parent, info.getName(), copy, onClose);
    }

    public static class CompoundImplicitKeyframe
    implements Keyframe {
        public ArrayList<Keyframe> key;
        public ArrayList<CoordinateSystem> coords;

        public CompoundImplicitKeyframe(ArrayList<Keyframe> key, ArrayList<CoordinateSystem> coords) {
            this.key = key;
            this.coords = coords;
        }

        @Override
        public Keyframe duplicate() {
            ArrayList<Keyframe> newKey = new ArrayList<Keyframe>();
            ArrayList<CoordinateSystem> newCoords = new ArrayList<CoordinateSystem>();
            for (int i = 0; i < this.key.size(); ++i) {
                newKey.add(this.key.get(i).duplicate());
                newCoords.add(this.coords.get(i).duplicate());
            }
            return new CompoundImplicitKeyframe(newKey, newCoords);
        }

        @Override
        public Keyframe duplicate(Object owner) {
            CompoundImplicitObject other = (CompoundImplicitObject)((ObjectInfo)owner).getObject();
            ArrayList<Keyframe> newKey = new ArrayList<Keyframe>();
            ArrayList<CoordinateSystem> newCoords = new ArrayList<CoordinateSystem>();
            for (int i = 0; i < this.key.size(); ++i) {
                newKey.add(this.key.get(i).duplicate(other.getObject(i)));
                newCoords.add(this.coords.get(i).duplicate());
            }
            return new CompoundImplicitKeyframe(newKey, newCoords);
        }

        @Override
        public double[] getGraphValues() {
            return new double[0];
        }

        @Override
        public void setGraphValues(double[] values) {
        }

        @Override
        public Keyframe blend(Keyframe o2, double weight1, double weight2) {
            CompoundImplicitKeyframe k2 = (CompoundImplicitKeyframe)o2;
            ArrayList<Keyframe> newKey = new ArrayList<Keyframe>();
            ArrayList<CoordinateSystem> newCoords = new ArrayList<CoordinateSystem>();
            for (int i = 0; i < this.key.size(); ++i) {
                CoordinateSystem coords1 = this.coords.get(i);
                CoordinateSystem coords2 = k2.coords.get(i);
                RotationKeyframe rot1 = new RotationKeyframe(coords1);
                RotationKeyframe rot2 = new RotationKeyframe(coords2);
                rot1.setUseQuaternion(true);
                rot2.setUseQuaternion(true);
                VectorKeyframe orig1 = new VectorKeyframe(coords1.getOrigin());
                VectorKeyframe orig2 = new VectorKeyframe(coords2.getOrigin());
                CoordinateSystem c = new CoordinateSystem((Vec3)((Object)orig1.blend(orig2, weight1, weight2)), Vec3.vz(), Vec3.vy());
                ((RotationKeyframe)rot1.blend(rot2, weight1, weight2)).applyToCoordinates(c, 1.0, null, null, false, true, true, true);
                newCoords.add(c);
                newKey.add(this.key.get(i).blend(k2.key.get(i), weight1, weight2));
            }
            return new CompoundImplicitKeyframe(newKey, newCoords);
        }

        @Override
        public Keyframe blend(Keyframe o2, Keyframe o3, double weight1, double weight2, double weight3) {
            CompoundImplicitKeyframe k2 = (CompoundImplicitKeyframe)o2;
            CompoundImplicitKeyframe k3 = (CompoundImplicitKeyframe)o3;
            ArrayList<Keyframe> newKey = new ArrayList<Keyframe>();
            ArrayList<CoordinateSystem> newCoords = new ArrayList<CoordinateSystem>();
            for (int i = 0; i < this.key.size(); ++i) {
                CoordinateSystem coords1 = this.coords.get(i);
                CoordinateSystem coords2 = k2.coords.get(i);
                CoordinateSystem coords3 = k3.coords.get(i);
                RotationKeyframe rot1 = new RotationKeyframe(coords1);
                RotationKeyframe rot2 = new RotationKeyframe(coords2);
                RotationKeyframe rot3 = new RotationKeyframe(coords3);
                rot1.setUseQuaternion(true);
                rot2.setUseQuaternion(true);
                rot3.setUseQuaternion(true);
                VectorKeyframe orig1 = new VectorKeyframe(coords1.getOrigin());
                VectorKeyframe orig2 = new VectorKeyframe(coords2.getOrigin());
                VectorKeyframe orig3 = new VectorKeyframe(coords3.getOrigin());
                CoordinateSystem c = new CoordinateSystem((Vec3)((Object)orig1.blend(orig2, orig3, weight1, weight2, weight3)), Vec3.vz(), Vec3.vy());
                ((RotationKeyframe)rot1.blend(rot2, rot3, weight1, weight2, weight3)).applyToCoordinates(c, 1.0, null, null, false, true, true, true);
                newCoords.add(c);
                newKey.add(this.key.get(i).blend(k2.key.get(i), k3.key.get(i), weight1, weight2, weight3));
            }
            return new CompoundImplicitKeyframe(newKey, newCoords);
        }

        @Override
        public Keyframe blend(Keyframe o2, Keyframe o3, Keyframe o4, double weight1, double weight2, double weight3, double weight4) {
            CompoundImplicitKeyframe k2 = (CompoundImplicitKeyframe)o2;
            CompoundImplicitKeyframe k3 = (CompoundImplicitKeyframe)o3;
            CompoundImplicitKeyframe k4 = (CompoundImplicitKeyframe)o4;
            ArrayList<Keyframe> newKey = new ArrayList<Keyframe>();
            ArrayList<CoordinateSystem> newCoords = new ArrayList<CoordinateSystem>();
            for (int i = 0; i < this.key.size(); ++i) {
                CoordinateSystem coords1 = this.coords.get(i);
                CoordinateSystem coords2 = k2.coords.get(i);
                CoordinateSystem coords3 = k3.coords.get(i);
                CoordinateSystem coords4 = k4.coords.get(i);
                RotationKeyframe rot1 = new RotationKeyframe(coords1);
                RotationKeyframe rot2 = new RotationKeyframe(coords2);
                RotationKeyframe rot3 = new RotationKeyframe(coords3);
                RotationKeyframe rot4 = new RotationKeyframe(coords4);
                rot1.setUseQuaternion(true);
                rot2.setUseQuaternion(true);
                rot3.setUseQuaternion(true);
                rot4.setUseQuaternion(true);
                VectorKeyframe orig1 = new VectorKeyframe(coords1.getOrigin());
                VectorKeyframe orig2 = new VectorKeyframe(coords2.getOrigin());
                VectorKeyframe orig3 = new VectorKeyframe(coords3.getOrigin());
                VectorKeyframe orig4 = new VectorKeyframe(coords4.getOrigin());
                CoordinateSystem c = new CoordinateSystem((Vec3)((Object)orig1.blend(orig2, orig3, orig4, weight1, weight2, weight3, weight4)), Vec3.vz(), Vec3.vy());
                ((RotationKeyframe)rot1.blend(rot2, rot3, rot4, weight1, weight2, weight3, weight4)).applyToCoordinates(c, 1.0, null, null, false, true, true, true);
                newCoords.add(c);
                newKey.add(this.key.get(i).blend(k2.key.get(i), k3.key.get(i), k4.key.get(i), weight1, weight2, weight3, weight4));
            }
            return new CompoundImplicitKeyframe(newKey, newCoords);
        }

        @Override
        public boolean equals(Keyframe k) {
            if (!(k instanceof CompoundImplicitKeyframe)) {
                return false;
            }
            CompoundImplicitKeyframe other = (CompoundImplicitKeyframe)k;
            for (int i = 0; i < this.key.size(); ++i) {
                Keyframe key2;
                Keyframe key1 = this.key.get(i);
                if (!(key1 == (key2 = other.key.get(i)) || key1 != null && key2 != null && key1.equals(key2))) {
                    return false;
                }
                CoordinateSystem coords1 = this.coords.get(i);
                CoordinateSystem coords2 = other.coords.get(i);
                if (!coords1.getOrigin().equals(coords2.getOrigin())) {
                    return false;
                }
                if (!coords1.getZDirection().equals(coords2.getZDirection())) {
                    return false;
                }
                if (coords1.getUpDirection().equals(coords2.getUpDirection())) continue;
                return false;
            }
            return true;
        }

        @Override
        public void writeToStream(DataOutputStream out) throws IOException {
            out.writeShort(0);
            out.writeInt(this.key.size());
            for (int i = 0; i < this.key.size(); ++i) {
                out.writeUTF(this.key.get(i).getClass().getName());
                this.key.get(i).writeToStream(out);
                this.coords.get(i).writeToFile(out);
            }
        }

        public CompoundImplicitKeyframe(DataInputStream in, Object parent) throws IOException {
            short version = in.readShort();
            if (version != 0) {
                throw new InvalidObjectException("");
            }
            CompoundImplicitObject obj = (CompoundImplicitObject)((ObjectInfo)parent).object;
            if (in.readInt() != obj.getNumObjects()) {
                throw new InvalidObjectException("Keyframe contains the wrong number of component objects");
            }
            this.key = new ArrayList();
            this.coords = new ArrayList();
            try {
                for (int i = 0; i < obj.getNumObjects(); ++i) {
                    Class cl = ArtOfIllusion.getClass(in.readUTF());
                    Constructor con = cl.getConstructor(DataInputStream.class, Object.class);
                    this.key.add((Keyframe)con.newInstance(in, obj.getObject(i)));
                    this.coords.add(new CoordinateSystem(in));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new InvalidObjectException(ex.getMessage());
            }
        }
    }
}

