/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.Property;
import artofillusion.RenderingMesh;
import artofillusion.Scene;
import artofillusion.WireframeMesh;
import artofillusion.animation.Keyframe;
import artofillusion.animation.PoseTrack;
import artofillusion.material.Material;
import artofillusion.material.MaterialMapping;
import artofillusion.math.BoundingBox;
import artofillusion.math.Vec3;
import artofillusion.object.ImplicitObject;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.Sphere;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import buoy.widget.Widget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class ImplicitSphere
extends ImplicitObject {
    private double radius;
    private double influenceRadius;
    private double scale;
    private BoundingBox bounds;
    private RenderingMesh cachedMesh;
    private WireframeMesh cachedWire;
    private static final Property[] PROPERTIES = new Property[]{new Property(Translate.text("radius"), 0.0, Double.MAX_VALUE, 1.0), new Property(Translate.text("influenceRadius"), 0.0, Double.MAX_VALUE, 1.0)};

    public ImplicitSphere(double radius, double influenceRadius) {
        this.radius = radius;
        this.influenceRadius = influenceRadius;
        this.sizeChanged();
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
        this.sizeChanged();
    }

    public double getInfluenceRadius() {
        return this.influenceRadius;
    }

    public void setInfluenceRadius(double influenceRadius) {
        this.influenceRadius = influenceRadius;
        this.sizeChanged();
    }

    private void sizeChanged() {
        double f = this.influenceRadius / this.radius - 1.0;
        this.scale = 1.0 / (f * f);
        this.bounds = new BoundingBox(-this.influenceRadius, this.influenceRadius, -this.influenceRadius, this.influenceRadius, -this.influenceRadius, this.influenceRadius);
        this.cachedWire = null;
        this.cachedMesh = null;
    }

    @Override
    public double getCutoff() {
        return 1.0;
    }

    @Override
    public boolean getPreferDirectRendering() {
        return true;
    }

    @Override
    public double getFieldValue(double x, double y, double z, double size, double time) {
        double r = Math.sqrt(x * x + y * y + z * z);
        if (r >= this.influenceRadius) {
            return 0.0;
        }
        double f = this.influenceRadius / r - 1.0;
        return this.scale * f * f;
    }

    @Override
    public void getFieldGradient(double x, double y, double z, double size, double time, Vec3 grad) {
        double r = Math.sqrt(x * x + y * y + z * z);
        if (r >= this.influenceRadius) {
            grad.set(0.0, 0.0, 0.0);
        } else {
            double f = this.influenceRadius / r - 1.0;
            double c = -this.scale * 2.0 * f * this.influenceRadius / (r * r * r);
            grad.set(c * x, c * y, c * z);
        }
    }

    @Override
    public void applyPoseKeyframe(Keyframe k) {
        ImplicitSphereKeyframe key = (ImplicitSphereKeyframe)k;
        this.radius = key.radius;
        this.influenceRadius = key.influenceRadius;
        this.sizeChanged();
    }

    @Override
    public void configurePoseTrack(PoseTrack track) {
        track.setGraphableValues(new String[]{Translate.text("radius"), Translate.text("influenceRadius")}, new double[]{this.radius, this.influenceRadius}, new double[][]{{0.0, Double.MAX_VALUE}, {0.0, Double.MAX_VALUE}});
    }

    public String[] getPoseValueNames() {
        return new String[]{Translate.text("radius"), Translate.text("influenceRadius")};
    }

    public double[] getDefaultPoseValues() {
        return new double[]{this.radius, this.influenceRadius};
    }

    @Override
    public Object3D duplicate() {
        return new ImplicitSphere(this.radius, this.influenceRadius);
    }

    @Override
    public void copyObject(Object3D obj) {
        ImplicitSphere sphere = (ImplicitSphere)obj;
        this.radius = sphere.getRadius();
        this.influenceRadius = sphere.getInfluenceRadius();
        this.sizeChanged();
    }

    @Override
    public BoundingBox getBounds() {
        return this.bounds;
    }

    @Override
    public void setSize(double xsize, double ysize, double zsize) {
    }

    @Override
    public WireframeMesh getWireframeMesh() {
        if (this.cachedWire == null) {
            this.cachedWire = new Sphere(this.radius, this.radius, this.radius).getWireframeMesh();
        }
        return this.cachedWire;
    }

    @Override
    public RenderingMesh getRenderingMesh(double tol, boolean interactive, ObjectInfo info) {
        if (this.cachedMesh == null) {
            Sphere sphere = new Sphere(this.radius, this.radius, this.radius);
            sphere.setTexture(this.getTexture(), this.getTextureMapping());
            this.cachedMesh = sphere.getRenderingMesh(tol, interactive, info);
        }
        return this.cachedMesh;
    }

    @Override
    public Keyframe getPoseKeyframe() {
        return new ImplicitSphereKeyframe(this.radius, this.influenceRadius);
    }

    @Override
    public Property[] getProperties() {
        return (Property[])PROPERTIES.clone();
    }

    @Override
    public Object getPropertyValue(int index) {
        switch (index) {
            case 0: {
                return this.radius;
            }
            case 1: {
                return this.influenceRadius;
            }
        }
        return null;
    }

    @Override
    public void setPropertyValue(int index, Object value) {
        double val = (Double)value;
        if (index == 0) {
            this.setRadius(val);
        } else if (index == 1) {
            this.setInfluenceRadius(val);
        }
    }

    @Override
    public void setTexture(Texture tex, TextureMapping mapping) {
        super.setTexture(tex, mapping);
        this.cachedMesh = null;
    }

    @Override
    public void setMaterial(Material mat, MaterialMapping map) {
        super.setMaterial(mat, map);
        this.cachedMesh = null;
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public void edit(EditingWindow parent, ObjectInfo info, Runnable cb) {
        ValueField radiusField = new ValueField(this.radius, 3, 5);
        ValueField influenceField = new ValueField(this.influenceRadius, 3, 5);
        ComponentsDialog dlg = new ComponentsDialog(parent.getFrame(), Translate.text("editImplicitSphereTitle"), new Widget[]{radiusField, influenceField}, new String[]{Translate.text("radius"), Translate.text("influenceRadius")});
        if (!dlg.clickedOk()) {
            return;
        }
        this.radius = radiusField.getValue();
        this.influenceRadius = influenceField.getValue();
        this.sizeChanged();
        cb.run();
    }

    public ImplicitSphere(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        super(in, theScene);
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.radius = in.readDouble();
        this.influenceRadius = in.readDouble();
        this.sizeChanged();
    }

    @Override
    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        super.writeToFile(out, theScene);
        out.writeShort(0);
        out.writeDouble(this.radius);
        out.writeDouble(this.influenceRadius);
    }

    @Override
    public void editKeyframe(EditingWindow parent, Keyframe k, ObjectInfo info) {
        ImplicitSphereKeyframe key = (ImplicitSphereKeyframe)k;
        ValueField radiusField = new ValueField(key.radius, 3, 5);
        ValueField influenceField = new ValueField(key.influenceRadius, 3, 5);
        ComponentsDialog dlg = new ComponentsDialog(parent.getFrame(), Translate.text("editImplicitSphereTitle"), new Widget[]{radiusField, influenceField}, new String[]{Translate.text("radius"), Translate.text("influenceRadius")});
        if (!dlg.clickedOk()) {
            return;
        }
        key.radius = radiusField.getValue();
        key.influenceRadius = influenceField.getValue();
    }

    public static class ImplicitSphereKeyframe
    implements Keyframe {
        public double radius;
        public double influenceRadius;

        public ImplicitSphereKeyframe(double radius, double influenceRadius) {
            this.radius = radius;
            this.influenceRadius = influenceRadius;
        }

        @Override
        public Keyframe duplicate() {
            return new ImplicitSphereKeyframe(this.radius, this.influenceRadius);
        }

        @Override
        public Keyframe duplicate(Object owner) {
            return new ImplicitSphereKeyframe(this.radius, this.influenceRadius);
        }

        @Override
        public double[] getGraphValues() {
            return new double[]{this.radius, this.influenceRadius};
        }

        @Override
        public void setGraphValues(double[] values) {
            this.radius = values[0];
            this.influenceRadius = values[1];
        }

        @Override
        public Keyframe blend(Keyframe o2, double weight1, double weight2) {
            ImplicitSphereKeyframe k2 = (ImplicitSphereKeyframe)o2;
            return new ImplicitSphereKeyframe(weight1 * this.radius + weight2 * k2.radius, weight1 * this.influenceRadius + weight2 * k2.influenceRadius);
        }

        @Override
        public Keyframe blend(Keyframe o2, Keyframe o3, double weight1, double weight2, double weight3) {
            ImplicitSphereKeyframe k2 = (ImplicitSphereKeyframe)o2;
            ImplicitSphereKeyframe k3 = (ImplicitSphereKeyframe)o3;
            return new ImplicitSphereKeyframe(weight1 * this.radius + weight2 * k2.radius + weight3 * k3.radius, weight1 * this.influenceRadius + weight2 * k2.influenceRadius + weight3 * k3.influenceRadius);
        }

        @Override
        public Keyframe blend(Keyframe o2, Keyframe o3, Keyframe o4, double weight1, double weight2, double weight3, double weight4) {
            ImplicitSphereKeyframe k2 = (ImplicitSphereKeyframe)o2;
            ImplicitSphereKeyframe k3 = (ImplicitSphereKeyframe)o3;
            ImplicitSphereKeyframe k4 = (ImplicitSphereKeyframe)o4;
            return new ImplicitSphereKeyframe(weight1 * this.radius + weight2 * k2.radius + weight3 * k3.radius + weight4 * k4.radius, weight1 * this.influenceRadius + weight2 * k2.influenceRadius + weight3 * k3.influenceRadius + weight4 * k4.influenceRadius);
        }

        @Override
        public boolean equals(Keyframe k) {
            if (!(k instanceof ImplicitSphereKeyframe)) {
                return false;
            }
            ImplicitSphereKeyframe key = (ImplicitSphereKeyframe)k;
            return key.radius == this.radius && key.influenceRadius == this.influenceRadius;
        }

        @Override
        public void writeToStream(DataOutputStream out) throws IOException {
            out.writeDouble(this.radius);
            out.writeDouble(this.influenceRadius);
        }

        public ImplicitSphereKeyframe(DataInputStream in, Object parent) throws IOException {
            this(in.readDouble(), in.readDouble());
        }
    }
}

