/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.math.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.PointInfo;
import artofillusion.procedural.ProceduralModule;
import artofillusion.ui.Translate;
import java.awt.Point;

public class BlurModule
extends ProceduralModule {
    boolean valueOk;
    double extraBlur;
    double lastBlur;

    public BlurModule(Point position) {
        super(Translate.text("menu.blurModule"), new IOPort[]{new IOPort(0, 0, 1, new String[]{"Blur", "(0.05)"}), new IOPort(0, 0, 2, new String[]{"Input", "(0)"})}, new IOPort[]{new IOPort(0, 1, 3, new String[]{"Output"})}, position);
    }

    @Override
    public void init(PointInfo p) {
        this.valueOk = false;
    }

    @Override
    public double getAverageValue(int which, double blur) {
        if (this.linkFrom[1] == null) {
            return 0.0;
        }
        if (!this.valueOk || blur != this.lastBlur) {
            this.extraBlur = this.linkFrom[0] == null ? 0.05 : this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
        }
        this.valueOk = true;
        this.lastBlur = blur;
        return this.linkFrom[1].getAverageValue(this.linkFromIndex[1], blur + this.extraBlur);
    }

    @Override
    public double getValueError(int which, double blur) {
        if (this.linkFrom[1] == null) {
            return 0.0;
        }
        if (!this.valueOk || blur != this.lastBlur) {
            this.extraBlur = this.linkFrom[0] == null ? 0.05 : this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
        }
        this.valueOk = true;
        this.lastBlur = blur;
        return this.linkFrom[1].getValueError(this.linkFromIndex[1], blur + this.extraBlur);
    }

    @Override
    public void getValueGradient(int which, Vec3 grad, double blur) {
        if (this.linkFrom[1] == null) {
            grad.set(0.0, 0.0, 0.0);
            return;
        }
        if (!this.valueOk || blur != this.lastBlur) {
            this.extraBlur = this.linkFrom[0] == null ? 0.05 : this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
        }
        this.valueOk = true;
        this.lastBlur = blur;
        this.linkFrom[1].getValueGradient(this.linkFromIndex[1], grad, blur + this.extraBlur);
    }
}

