/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.math.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.PointInfo;
import artofillusion.procedural.ProceduralModule;
import artofillusion.ui.Translate;
import java.awt.Point;

public class CheckerModule
extends ProceduralModule {
    boolean valueOk;
    boolean gradOk;
    double value;
    double error;
    double lastBlur;
    PointInfo point;
    Vec3 gradient = new Vec3();

    public CheckerModule(Point position) {
        super(Translate.text("menu.checkerModule"), new IOPort[]{new IOPort(0, 0, 2, new String[]{"X", "(X)"}), new IOPort(0, 0, 2, new String[]{"Y", "(Y)"}), new IOPort(0, 0, 2, new String[]{"Z", "(Z)"})}, new IOPort[]{new IOPort(0, 1, 3, new String[]{"Value"})}, position);
    }

    @Override
    public void init(PointInfo p) {
        this.point = p;
        this.gradOk = false;
        this.valueOk = false;
    }

    @Override
    public double getAverageValue(int which, double blur) {
        double zsize;
        if (this.valueOk && blur == this.lastBlur) {
            return this.value;
        }
        this.valueOk = true;
        this.lastBlur = blur;
        double xsize = this.linkFrom[0] == null ? 0.5 * this.point.xsize + blur : this.linkFrom[0].getValueError(this.linkFromIndex[0], blur);
        double ysize = this.linkFrom[1] == null ? 0.5 * this.point.ysize + blur : this.linkFrom[1].getValueError(this.linkFromIndex[1], blur);
        double d = zsize = this.linkFrom[2] == null ? 0.5 * this.point.zsize + blur : this.linkFrom[2].getValueError(this.linkFromIndex[2], blur);
        if (xsize >= 0.5 || ysize >= 0.5 || zsize >= 0.5) {
            this.error = 0.5;
            this.value = 0.5;
            this.gradient.set(0.0, 0.0, 0.0);
            this.gradOk = true;
            return 0.5;
        }
        double x = this.linkFrom[0] == null ? this.point.x : this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
        double y = this.linkFrom[1] == null ? this.point.y : this.linkFrom[1].getAverageValue(this.linkFromIndex[1], blur);
        double z = this.linkFrom[2] == null ? this.point.z : this.linkFrom[2].getAverageValue(this.linkFromIndex[2], blur);
        double xi = Math.rint(x);
        double yi = Math.rint(y);
        double zi = Math.rint(z);
        double xf = 0.5 - Math.abs(x - xi);
        double yf = 0.5 - Math.abs(y - yi);
        double zf = 0.5 - Math.abs(z - zi);
        int i = (int)xi;
        int j = (int)yi;
        int k = (int)zi;
        double d2 = this.value = (i + j + k & 1) == 0 ? 1.0 : 0.0;
        if (xf > xsize && yf > ysize && zf > zsize) {
            this.error = 0.0;
            this.gradient.set(0.0, 0.0, 0.0);
            this.gradOk = true;
            return this.value;
        }
        double e1 = xf / xsize;
        double e2 = yf / ysize;
        double e3 = zf / zsize;
        if (e1 < e2 && e1 < e3) {
            this.error = 0.5 - 0.5 * e1;
            this.gradient.set((x > xi ? 1.0 - 2.0 * this.value : 2.0 * this.value - 1.0) / xsize, 0.0, 0.0);
        } else if (e2 < e1 && e2 < e3) {
            this.error = 0.5 - 0.5 * e2;
            this.gradient.set(0.0, (y > yi ? 1.0 - 2.0 * this.value : 2.0 * this.value - 1.0) / ysize, 0.0);
        } else {
            this.error = 0.5 - 0.5 * e3;
            this.gradient.set(0.0, 0.0, (z > zi ? 1.0 - 2.0 * this.value : 2.0 * this.value - 1.0) / zsize);
        }
        this.value = this.error * (1.0 - this.value) + (1.0 - this.error) * this.value;
        return this.value;
    }

    @Override
    public double getValueError(int which, double blur) {
        if (!this.valueOk || blur != this.lastBlur) {
            this.getAverageValue(which, blur);
        }
        return this.error;
    }

    @Override
    public void getValueGradient(int which, Vec3 grad, double blur) {
        if (!this.valueOk || blur != this.lastBlur) {
            this.getAverageValue(which, blur);
        }
        if (this.gradOk) {
            grad.set(this.gradient);
            return;
        }
        double dx = this.gradient.x;
        double dy = this.gradient.y;
        double dz = this.gradient.z;
        if (dx != 0.0) {
            if (this.linkFrom[0] == null) {
                this.gradient.set(dx, 0.0, 0.0);
            } else {
                this.linkFrom[0].getValueGradient(this.linkFromIndex[0], grad, blur);
                this.gradient.x = dx * grad.x;
                this.gradient.y = dx * grad.y;
                this.gradient.z = dx * grad.z;
            }
        } else {
            this.gradient.set(0.0, 0.0, 0.0);
        }
        if (dy != 0.0) {
            if (this.linkFrom[1] == null) {
                this.gradient.y += dy;
            } else {
                this.linkFrom[1].getValueGradient(this.linkFromIndex[1], grad, blur);
                this.gradient.x += dy * grad.x;
                this.gradient.y += dy * grad.y;
                this.gradient.z += dy * grad.z;
            }
        }
        if (dz != 0.0) {
            if (this.linkFrom[2] == null) {
                this.gradient.z += dz;
            } else {
                this.linkFrom[2].getValueGradient(this.linkFromIndex[2], grad, blur);
                this.gradient.x += dz * grad.x;
                this.gradient.y += dz * grad.y;
                this.gradient.z += dz * grad.z;
            }
        }
        this.gradOk = true;
        grad.set(this.gradient);
    }
}

