/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.PluginRegistry;
import artofillusion.procedural.AbsModule;
import artofillusion.procedural.BiasModule;
import artofillusion.procedural.BlendModule;
import artofillusion.procedural.BlurModule;
import artofillusion.procedural.BrickModule;
import artofillusion.procedural.CellsModule;
import artofillusion.procedural.CheckerModule;
import artofillusion.procedural.ClipModule;
import artofillusion.procedural.ColorDarkenModule;
import artofillusion.procedural.ColorDifferenceModule;
import artofillusion.procedural.ColorLightenModule;
import artofillusion.procedural.ColorModule;
import artofillusion.procedural.ColorProductModule;
import artofillusion.procedural.ColorScaleModule;
import artofillusion.procedural.ColorSumModule;
import artofillusion.procedural.CommentModule;
import artofillusion.procedural.CompareModule;
import artofillusion.procedural.CoordinateModule;
import artofillusion.procedural.CosineModule;
import artofillusion.procedural.DifferenceModule;
import artofillusion.procedural.ExpModule;
import artofillusion.procedural.ExprModule;
import artofillusion.procedural.FunctionModule;
import artofillusion.procedural.GainModule;
import artofillusion.procedural.GridModule;
import artofillusion.procedural.HLSModule;
import artofillusion.procedural.HSVModule;
import artofillusion.procedural.ImageModule;
import artofillusion.procedural.InterpModule;
import artofillusion.procedural.JitterModule;
import artofillusion.procedural.LogModule;
import artofillusion.procedural.MarbleModule;
import artofillusion.procedural.MaxModule;
import artofillusion.procedural.MinModule;
import artofillusion.procedural.ModModule;
import artofillusion.procedural.Module;
import artofillusion.procedural.NoiseModule;
import artofillusion.procedural.NumberModule;
import artofillusion.procedural.ParameterModule;
import artofillusion.procedural.PolarModule;
import artofillusion.procedural.PowerModule;
import artofillusion.procedural.ProcedureEditor;
import artofillusion.procedural.ProductModule;
import artofillusion.procedural.RGBModule;
import artofillusion.procedural.RandomModule;
import artofillusion.procedural.RatioModule;
import artofillusion.procedural.ScaleShiftModule;
import artofillusion.procedural.SineModule;
import artofillusion.procedural.SpectrumModule;
import artofillusion.procedural.SphericalModule;
import artofillusion.procedural.SqrtModule;
import artofillusion.procedural.SumModule;
import artofillusion.procedural.TransformModule;
import artofillusion.procedural.TurbulenceModule;
import artofillusion.procedural.ViewAngleModule;
import artofillusion.procedural.WoodModule;
import artofillusion.ui.Translate;
import buoy.event.MouseDraggedEvent;
import buoy.event.MousePressedEvent;
import buoy.event.MouseReleasedEvent;
import buoy.event.RepaintEvent;
import buoy.widget.CustomWidget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ModuleMenu
extends CustomWidget {
    private final ProcedureEditor editor;
    private final ArrayList<Category> categories;
    private final double[] expandedFraction;
    private int expandedCategory;
    private Module newModule;
    private boolean isDraggingModule;

    public ModuleMenu(ProcedureEditor editor) {
        this.editor = editor;
        this.addEventLink(RepaintEvent.class, (Object)this, "paint");
        this.addEventLink(MousePressedEvent.class, (Object)this, "mousePressed");
        this.addEventLink(MouseDraggedEvent.class, (Object)this, "mouseDragged");
        this.addEventLink(MouseReleasedEvent.class, (Object)this, "mouseReleased");
        this.categories = new ArrayList();
        Category category = new Category(Translate.text("menu.values"));
        this.categories.add(category);
        category.add(new Entry(Translate.text("menu.numberModule"), NumberModule.class));
        category.add(new Entry(Translate.text("menu.colorModule"), ColorModule.class));
        category.add(new Entry(Translate.text("menu.xModule"), CoordinateModule.class, null, 0));
        category.add(new Entry(Translate.text("menu.yModule"), CoordinateModule.class, null, 1));
        category.add(new Entry(Translate.text("menu.zModule"), CoordinateModule.class, null, 2));
        category.add(new Entry(Translate.text("menu.timeModule"), CoordinateModule.class, null, 3));
        if (editor.getOwner().allowViewAngle()) {
            category.add(new Entry(Translate.text("menu.viewAngleModule"), ViewAngleModule.class));
        }
        if (editor.getOwner().allowParameters()) {
            category.add(new Entry(Translate.text("menu.parameterModule"), ParameterModule.class));
        }
        category.add(new Entry(Translate.text("menu.commentModule"), CommentModule.class));
        category = new Category(Translate.text("menu.operators"));
        this.categories.add(category);
        category.add(new Entry(Translate.text("menu.addModule"), SumModule.class));
        category.add(new Entry(Translate.text("menu.subtractModule"), DifferenceModule.class));
        category.add(new Entry(Translate.text("menu.multiplyModule"), ProductModule.class));
        category.add(new Entry(Translate.text("menu.divideModule"), RatioModule.class));
        category.add(new Entry(Translate.text("menu.powModule"), PowerModule.class));
        category.add(new Entry(Translate.text("menu.modModule"), ModModule.class));
        category.add(new Entry(Translate.text("menu.greaterThanModule"), CompareModule.class));
        category.add(new Entry(Translate.text("menu.minModule"), MinModule.class));
        category.add(new Entry(Translate.text("menu.maxModule"), MaxModule.class));
        category = new Category(Translate.text("menu.functions"));
        this.categories.add(category);
        category.add(new Entry(Translate.text("menu.expressionModule"), ExprModule.class));
        category.add(new Entry(Translate.text("menu.customFunctionModule"), FunctionModule.class));
        category.add(new Entry(Translate.text("menu.scaleShiftModule"), ScaleShiftModule.class));
        category.add(new Entry(Translate.text("menu.absModule"), AbsModule.class));
        category.add(new Entry(Translate.text("menu.blurModule"), BlurModule.class));
        category.add(new Entry(Translate.text("menu.clipModule"), ClipModule.class));
        category.add(new Entry(Translate.text("menu.interpolateModule"), InterpModule.class));
        category.add(new Entry(Translate.text("menu.sineModule"), SineModule.class));
        category.add(new Entry(Translate.text("menu.cosineModule"), CosineModule.class));
        category.add(new Entry(Translate.text("menu.sqrtModule"), SqrtModule.class));
        category.add(new Entry(Translate.text("menu.expModule"), ExpModule.class));
        category.add(new Entry(Translate.text("menu.logModule"), LogModule.class));
        category.add(new Entry(Translate.text("menu.biasModule"), BiasModule.class));
        category.add(new Entry(Translate.text("menu.gainModule"), GainModule.class));
        category.add(new Entry(Translate.text("menu.randomModule"), RandomModule.class));
        category = new Category(Translate.text("menu.colorFunctions"));
        this.categories.add(category);
        category.add(new Entry(Translate.text("menu.customColorFunctionModule"), SpectrumModule.class));
        category.add(new Entry(Translate.text("menu.blendModule"), BlendModule.class));
        category.add(new Entry(Translate.text("menu.addColorModule"), ColorSumModule.class));
        category.add(new Entry(Translate.text("menu.subtractColorModule"), ColorDifferenceModule.class));
        category.add(new Entry(Translate.text("menu.multiplyColorModule"), ColorProductModule.class));
        category.add(new Entry(Translate.text("menu.lighterModule"), ColorLightenModule.class));
        category.add(new Entry(Translate.text("menu.darkerModule"), ColorDarkenModule.class));
        category.add(new Entry(Translate.text("menu.scaleColorModule"), ColorScaleModule.class));
        category.add(new Entry(Translate.text("menu.RGBModule"), RGBModule.class));
        category.add(new Entry(Translate.text("menu.HSVModule"), HSVModule.class));
        category.add(new Entry(Translate.text("menu.HLSModule"), HLSModule.class));
        category = new Category(Translate.text("menu.transforms"));
        this.categories.add(category);
        category.add(new Entry(Translate.text("menu.linearModule"), TransformModule.class));
        category.add(new Entry(Translate.text("menu.polarModule"), PolarModule.class));
        category.add(new Entry(Translate.text("menu.sphericalModule"), SphericalModule.class));
        category.add(new Entry(Translate.text("menu.jitterModule"), JitterModule.class));
        category = new Category(Translate.text("menu.patterns"));
        this.categories.add(category);
        category.add(new Entry(Translate.text("menu.noiseModule"), NoiseModule.class));
        category.add(new Entry(Translate.text("menu.turbulenceModule"), TurbulenceModule.class));
        category.add(new Entry(Translate.text("menu.gridModule"), GridModule.class));
        category.add(new Entry(Translate.text("menu.cellsModule"), CellsModule.class));
        category.add(new Entry(Translate.text("menu.marbleModule"), MarbleModule.class));
        category.add(new Entry(Translate.text("menu.woodModule"), WoodModule.class));
        category.add(new Entry(Translate.text("menu.checkerModule"), CheckerModule.class));
        category.add(new Entry(Translate.text("menu.bricksModule"), BrickModule.class));
        category.add(new Entry(Translate.text("menu.imageModule"), ImageModule.class));
        List<Module> plugins = PluginRegistry.getPlugins(Module.class);
        if (plugins.size() > 0) {
            category = new Category(Translate.text("menu.plugins"));
            this.categories.add(category);
            for (int i = 0; i < plugins.size(); ++i) {
                try {
                    Class<?> moduleClass = plugins.get(i).getClass();
                    category.add(new Entry(((Module)moduleClass.newInstance()).getName(), moduleClass, new Object[0]));
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        this.expandedFraction = new double[this.categories.size()];
        this.expandedFraction[this.expandedCategory] = 1.0;
        FontMetrics metrics = Toolkit.getDefaultToolkit().getFontMetrics(editor.getFont());
        int width = 0;
        for (Category cat : this.categories) {
            width = Math.max(width, metrics.stringWidth(cat.name));
            for (Entry entry : cat.entries) {
                width = Math.max(width, metrics.stringWidth(entry.name));
            }
        }
        this.setPreferredSize(new Dimension(width + 20, 50));
    }

    private void paint(RepaintEvent ev) {
        Graphics2D g = ev.getGraphics();
        FontMetrics metrics = Toolkit.getDefaultToolkit().getFontMetrics(this.editor.getFont());
        int y = 0;
        int categoryHeight = metrics.getAscent() + metrics.getDescent() + 10;
        int entryHeight = metrics.getAscent() + metrics.getDescent() + 5;
        int width = this.getBounds().width;
        Color categoryColor = new Color(0.9f, 0.9f, 0.9f);
        Color selectedCategoryColor = new Color(0.7f, 0.7f, 1.0f);
        for (int i = 0; i < this.categories.size(); ++i) {
            Category cat = this.categories.get(i);
            g.setColor(i == this.expandedCategory ? selectedCategoryColor : categoryColor);
            cat.bounds = new Rectangle(1, y, width, categoryHeight - 2);
            g.fill3DRect(cat.bounds.x, cat.bounds.y, cat.bounds.width, cat.bounds.height, true);
            g.setColor(Color.BLACK);
            g.drawString(cat.name, (width - metrics.stringWidth(cat.name)) / 2, y + categoryHeight / 2 + metrics.getAscent() / 2);
            y += categoryHeight;
            if (this.expandedFraction[i] > 0.0) {
                int endy = y + (int)(this.expandedFraction[i] * (double)entryHeight * (double)cat.entries.size());
                g.setClip(0, 0, width, endy);
                for (Entry entry : cat.entries) {
                    g.setColor(Color.WHITE);
                    Rectangle bounds = new Rectangle(0, y, width, entryHeight);
                    g.fill3DRect(bounds.x, bounds.y, bounds.width, bounds.height, true);
                    g.setColor(Color.BLACK);
                    g.drawString(entry.name, (width - metrics.stringWidth(entry.name)) / 2, y + entryHeight / 2 + metrics.getAscent() / 2);
                    y += entryHeight;
                    if (i != this.expandedCategory) continue;
                    entry.bounds = bounds;
                }
                y = endy;
                g.setClip(null);
                continue;
            }
            for (Entry entry : cat.entries) {
                entry.bounds = null;
            }
        }
    }

    private void mousePressed(MousePressedEvent ev) {
        this.newModule = null;
        this.isDraggingModule = false;
        for (int i = 0; i < this.categories.size(); ++i) {
            Category cat = this.categories.get(i);
            if (this.expandedCategory != i && cat.bounds.contains(ev.getPoint())) {
                this.expandedCategory = i;
                new Timer(10, new ExpandAnimator()).start();
                return;
            }
            for (Entry entry : cat.entries) {
                if (entry.bounds == null || !entry.bounds.contains(ev.getPoint())) continue;
                Object[] args = new Object[entry.args.length];
                Class[] argTypes = new Class[entry.args.length];
                for (int j = 0; j < args.length; ++j) {
                    args[j] = entry.args[j] == null ? new Point() : entry.args[j];
                    argTypes[j] = args[j].getClass();
                    if (argTypes[j] != Integer.class) continue;
                    argTypes[j] = Integer.TYPE;
                }
                try {
                    this.newModule = entry.moduleClass.getDeclaredConstructor(argTypes).newInstance(args);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return;
            }
        }
    }

    private void mouseDragged(MouseDraggedEvent ev) {
        if (this.newModule == null) {
            return;
        }
        Point screenPoint = ev.getPoint();
        SwingUtilities.convertPointToScreen(screenPoint, this.getComponent());
        if (!this.isDraggingModule) {
            Point viewPoint = new Point(screenPoint);
            SwingUtilities.convertPointFromScreen(viewPoint, this.editor.getParent().getComponent());
            if (viewPoint.x >= 0 && viewPoint.y >= 0 && viewPoint.x < this.editor.getParent().getBounds().width && viewPoint.y < this.editor.getParent().getBounds().height) {
                this.isDraggingModule = true;
                this.editor.saveState(false);
                Point editorPoint = new Point(screenPoint);
                SwingUtilities.convertPointFromScreen(editorPoint, this.editor.getComponent());
                Point modulePosition = new Point(editorPoint);
                modulePosition.x -= this.newModule.getBounds().width / 2;
                modulePosition.y -= this.newModule.getBounds().height / 2;
                this.newModule.setPosition(modulePosition.x, modulePosition.y);
                this.editor.addModule(this.newModule);
                this.editor.mousePressed(new MousePressedEvent(this, ev.getWhen(), ev.getModifiers(), editorPoint.x, editorPoint.y, ev.getClickCount(), ev.isPopupTrigger(), ev.getButton()));
            }
        } else {
            Point editorPoint = new Point(screenPoint);
            SwingUtilities.convertPointFromScreen(editorPoint, this.editor.getComponent());
            this.editor.mouseDragged(new MouseDraggedEvent(this.editor, ev.getWhen(), ev.getModifiers(), editorPoint.x, editorPoint.y));
        }
    }

    private void mouseReleased(MouseReleasedEvent ev) {
        if (this.newModule == null) {
            return;
        }
        if (!this.isDraggingModule) {
            Rectangle bounds = this.editor.getParent().getBounds();
            Point p = new Point((int)(0.5 * (double)bounds.width * Math.random()), (int)(0.5 * (double)bounds.height * Math.random()));
            p = SwingUtilities.convertPoint(this.editor.getParent().getComponent(), p, this.editor.getComponent());
            this.newModule.setPosition(p.x, p.y);
            this.editor.saveState(false);
            this.editor.addModule(this.newModule);
            this.editor.repaint();
        } else {
            Point screenPoint = ev.getPoint();
            SwingUtilities.convertPointToScreen(screenPoint, this.getComponent());
            Point editorPoint = new Point(screenPoint);
            SwingUtilities.convertPointFromScreen(editorPoint, this.editor.getComponent());
            this.editor.mouseReleased();
        }
    }

    private class ExpandAnimator
    implements ActionListener {
        private double fraction = 0.0;
        private double[] initialFraction;
        private double[] finalFraction;

        public ExpandAnimator() {
            this.initialFraction = (double[])ModuleMenu.this.expandedFraction.clone();
            this.finalFraction = new double[this.initialFraction.length];
            this.finalFraction[((ModuleMenu)ModuleMenu.this).expandedCategory] = 1.0;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            this.fraction = Math.min(this.fraction + 0.05, 1.0);
            for (int i = 0; i < ModuleMenu.this.expandedFraction.length; ++i) {
                ((ModuleMenu)ModuleMenu.this).expandedFraction[i] = this.fraction * this.finalFraction[i] + (1.0 - this.fraction) * this.initialFraction[i];
            }
            ModuleMenu.this.repaint();
            if (this.fraction == 1.0) {
                ((Timer)ev.getSource()).stop();
            }
        }
    }

    private static class Entry {
        public String name;
        public Class<? extends Module> moduleClass;
        public Object[] args;
        public Rectangle bounds;

        public Entry(String name, Class moduleClass) {
            this.name = name;
            this.moduleClass = moduleClass;
            this.args = new Object[]{null};
        }

        public Entry(String name, Class<? extends Module> moduleClass, Object ... args) {
            this.name = name;
            this.moduleClass = moduleClass;
            this.args = args;
        }
    }

    private static class Category {
        public String name;
        public ArrayList<Entry> entries;
        public Rectangle bounds;

        public Category(String name) {
            this.name = name;
            this.entries = new ArrayList();
        }

        public void add(Entry entry) {
            this.entries.add(entry);
        }
    }
}

