/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.TextureParameter;
import artofillusion.object.FacetedMesh;
import artofillusion.object.MeshVertex;
import artofillusion.texture.ParameterValue;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class FaceVertexParameterValue
implements ParameterValue {
    private double[] values;
    private int[] faceStartIndex;

    private FaceVertexParameterValue() {
    }

    public FaceVertexParameterValue(double[][] val) {
        this.setValue(val);
    }

    public FaceVertexParameterValue(FacetedMesh mesh, TextureParameter param) {
        int vert;
        int face;
        this.faceStartIndex = new int[mesh.getFaceCount() + 1];
        int totalValues = 0;
        for (int i = 0; i < mesh.getFaceCount(); ++i) {
            this.faceStartIndex[i + 1] = totalValues += mesh.getFaceVertexCount(i);
        }
        MeshVertex[] vertex = mesh.getVertices();
        this.values = new double[totalValues];
        int index = 0;
        if (param.type == 0) {
            for (face = 0; face < mesh.getFaceCount(); ++face) {
                for (vert = 0; vert < mesh.getFaceVertexCount(face); ++vert) {
                    this.values[index++] = param.defaultVal;
                }
            }
        }
        if (param.type == 1) {
            for (face = 0; face < mesh.getFaceCount(); ++face) {
                for (vert = 0; vert < mesh.getFaceVertexCount(face); ++vert) {
                    this.values[index++] = vertex[mesh.getFaceVertexIndex((int)face, (int)vert)].r.x;
                }
            }
        }
        if (param.type == 2) {
            for (face = 0; face < mesh.getFaceCount(); ++face) {
                for (vert = 0; vert < mesh.getFaceVertexCount(face); ++vert) {
                    this.values[index++] = vertex[mesh.getFaceVertexIndex((int)face, (int)vert)].r.y;
                }
            }
        }
        if (param.type == 3) {
            for (face = 0; face < mesh.getFaceCount(); ++face) {
                for (vert = 0; vert < mesh.getFaceVertexCount(face); ++vert) {
                    this.values[index++] = vertex[mesh.getFaceVertexIndex((int)face, (int)vert)].r.z;
                }
            }
        }
    }

    public void setValue(double[][] val) {
        this.faceStartIndex = new int[val.length + 1];
        int totalValues = 0;
        for (int i = 0; i < val.length; ++i) {
            this.faceStartIndex[i + 1] = totalValues += val[i].length;
        }
        this.values = new double[totalValues];
        int index = 0;
        for (int i = 0; i < val.length; ++i) {
            for (int j = 0; j < val[i].length; ++j) {
                this.values[index++] = val[i][j];
            }
        }
    }

    public double getValue(int faceIndex, int vertIndex) {
        return this.values[this.faceStartIndex[faceIndex] + vertIndex];
    }

    public void setValue(int faceIndex, int vertIndex, double newValue) {
        this.values[this.faceStartIndex[faceIndex] + vertIndex] = newValue;
    }

    @Override
    public double getValue(int faceIndex, int v1, int v2, int v3, double u, double v, double w) {
        return u * this.getValue(faceIndex, 0) + v * this.getValue(faceIndex, 1) + w * this.getValue(faceIndex, 2);
    }

    public int getFaceCount() {
        return this.faceStartIndex.length - 1;
    }

    public int getFaceVertexCount(int faceIndex) {
        return this.faceStartIndex[faceIndex + 1] - this.faceStartIndex[faceIndex];
    }

    @Override
    public double getAverageValue() {
        double avg = 0.0;
        for (int i = 0; i < this.values.length; ++i) {
            avg += this.values[i];
        }
        return avg / (double)this.values.length;
    }

    @Override
    public ParameterValue duplicate() {
        FaceVertexParameterValue copy = new FaceVertexParameterValue();
        copy.values = (double[])this.values.clone();
        copy.faceStartIndex = (int[])this.faceStartIndex.clone();
        return copy;
    }

    public boolean equals(Object o) {
        int i;
        if (!(o instanceof FaceVertexParameterValue)) {
            return false;
        }
        FaceVertexParameterValue v = (FaceVertexParameterValue)o;
        if (v.values.length != this.values.length || v.faceStartIndex.length != this.faceStartIndex.length) {
            return false;
        }
        for (i = 0; i < this.values.length; ++i) {
            if (v.values[i] == this.values[i]) continue;
            return false;
        }
        for (i = 0; i < this.faceStartIndex.length; ++i) {
            if (v.faceStartIndex[i] == this.faceStartIndex[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void writeToStream(DataOutputStream out) throws IOException {
        int i;
        out.writeInt(-1);
        out.writeInt(this.values.length);
        for (i = 0; i < this.values.length; ++i) {
            out.writeDouble(this.values[i]);
        }
        out.writeInt(this.faceStartIndex.length);
        for (i = 1; i < this.faceStartIndex.length; ++i) {
            out.writeInt(this.faceStartIndex[i]);
        }
    }

    public FaceVertexParameterValue(DataInputStream in) throws IOException {
        int version = in.readInt();
        if (version >= 0) {
            int i;
            int faces = version;
            this.values = new double[faces * 3];
            this.faceStartIndex = new int[this.values.length + 1];
            for (i = 0; i < 3; ++i) {
                for (int j = 0; j < faces; ++j) {
                    this.values[j * 3 + i] = in.readDouble();
                }
            }
            for (i = 1; i <= faces; ++i) {
                this.faceStartIndex[i] = i * 3;
            }
        } else {
            int i;
            if (version != -1) {
                throw new InvalidObjectException("");
            }
            this.values = new double[in.readInt()];
            for (i = 0; i < this.values.length; ++i) {
                this.values[i] = in.readDouble();
            }
            this.faceStartIndex = new int[in.readInt()];
            for (i = 1; i < this.faceStartIndex.length; ++i) {
                this.faceStartIndex[i] = in.readInt();
            }
        }
    }
}

