/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.Scene;
import artofillusion.image.ImageMap;
import artofillusion.object.Object3D;
import artofillusion.texture.LayeredMapping;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;
import buoy.widget.WindowWidget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class LayeredTexture
extends Texture {
    LayeredMapping mapping;

    public LayeredTexture(Object3D obj) {
        this.mapping = new LayeredMapping(obj, this);
        this.name = "";
    }

    public LayeredTexture(LayeredMapping map) {
        this.mapping = map;
        this.mapping.theTexture = this;
        this.name = "";
    }

    @Override
    public boolean usesImage(ImageMap image) {
        Texture[] tex = this.mapping.getLayers();
        for (int i = 0; i < tex.length; ++i) {
            if (!tex[i].usesImage(image)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void getAverageSpec(TextureSpec spec, double time, double[] param) {
        this.mapping.getAverageSpec(spec, time, param);
    }

    @Override
    public TextureMapping getDefaultMapping(Object3D object) {
        return this.mapping;
    }

    public void setMapping(LayeredMapping map) {
        this.mapping = map;
    }

    @Override
    public Texture duplicate() {
        return null;
    }

    @Override
    public boolean hasComponent(int component) {
        Texture[] tex = this.mapping.getLayers();
        if (component == 2) {
            if (tex.length == 0) {
                return true;
            }
            for (int i = 0; i < tex.length; ++i) {
                if (!tex[i].hasComponent(component)) continue;
                int mode = this.mapping.getLayerMode(i);
                if (i != tex.length - 1 && (mode == 2 || mode == 1)) continue;
                return true;
            }
            return false;
        }
        if (tex.length == 0) {
            return false;
        }
        for (int i = 0; i < tex.length; ++i) {
            if (!tex[i].hasComponent(component)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void edit(WindowWidget fr, Scene sc) {
    }

    public LayeredTexture(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.name = in.readUTF();
    }

    @Override
    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        out.writeShort(0);
        out.writeUTF(this.name);
    }
}

