/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import artofillusion.Camera;
import artofillusion.math.BoundingBox;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.MeshEditController;

public abstract class MeshEditingTool
extends EditingTool {
    protected MeshEditController controller;

    public MeshEditingTool(EditingWindow fr, MeshEditController controller) {
        super(fr);
        this.controller = controller;
    }

    protected BoundingBox findSelectionBounds(Camera cam) {
        Mesh mesh = (Mesh)((Object)this.controller.getObject().getObject());
        MeshVertex[] vert = mesh.getVertices();
        int[] selected = this.controller.getSelectionDistance();
        boolean anything = false;
        double minz = Double.MAX_VALUE;
        double miny = Double.MAX_VALUE;
        double minx = Double.MAX_VALUE;
        double maxz = -1.7976931348623157E308;
        double maxy = -1.7976931348623157E308;
        double maxx = -1.7976931348623157E308;
        for (int i = 0; i < vert.length; ++i) {
            if (selected[i] != 0) continue;
            anything = true;
            Vec3 v = cam.getObjectToView().times(vert[i].r);
            if (v.x < minx) {
                minx = v.x;
            }
            if (v.x > maxx) {
                maxx = v.x;
            }
            if (v.y < miny) {
                miny = v.y;
            }
            if (v.y > maxy) {
                maxy = v.y;
            }
            if (v.z < minz) {
                minz = v.z;
            }
            if (!(v.z > maxz)) continue;
            maxz = v.z;
        }
        if (anything) {
            return new BoundingBox(minx, maxx, miny, maxy, minz, maxz);
        }
        return null;
    }
}

