/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.view;

import artofillusion.Camera;
import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.ViewerCanvas;
import artofillusion.WireframeMesh;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.texture.TextureSpec;
import artofillusion.texture.UniformTriangle;
import artofillusion.view.CanvasDrawer;
import artofillusion.view.VertexShader;
import buoy.event.RepaintEvent;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.PixelGrabber;
import java.lang.ref.SoftReference;
import java.util.List;
import java.util.WeakHashMap;

public class SoftwareCanvasDrawer
implements CanvasDrawer {
    protected ViewerCanvas view;
    protected BufferedImage theImage;
    protected Graphics2D imageGraphics;
    protected int[] pixel;
    protected int[] zbuffer;
    protected boolean hideBackfaces;
    protected int[] templatePixel;
    protected Rectangle bounds;
    private static Vec2[] reuseVec2;
    private static WeakHashMap<Image, SoftReference<ImageRecord>> imageMap;
    private static WeakHashMap<Image, SoftReference<RenderingMesh>> imageMeshMap;
    private static final int MODE_COPY = 0;
    private static final int MODE_ADD = 1;
    private static final int MODE_SUBTRACT = 2;

    public SoftwareCanvasDrawer(ViewerCanvas view) {
        this.view = view;
        this.hideBackfaces = true;
        view.addEventLink(RepaintEvent.class, (Object)this, "paint");
        if (reuseVec2 == null) {
            reuseVec2 = new Vec2[10000];
            for (int i = 0; i < reuseVec2.length; ++i) {
                SoftwareCanvasDrawer.reuseVec2[i] = new Vec2();
            }
        }
    }

    @Override
    public void setTemplateImage(Image im) {
        try {
            PixelGrabber pg = new PixelGrabber(im, 0, 0, -1, -1, true);
            pg.grabPixels();
            this.templatePixel = (int[])pg.getPixels();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void drawDraggedShape(Shape shape) {
        Graphics2D g = (Graphics2D)this.view.getComponent().getGraphics();
        g.drawImage((Image)this.theImage, 0, 0, null);
        g.setColor(ViewerCanvas.lineColor);
        g.draw(shape);
        g.dispose();
    }

    public BufferedImage getImage() {
        return this.theImage;
    }

    public void paint(RepaintEvent ev) {
        this.bounds = this.view.getBounds();
        this.prepareToRender();
        this.view.updateImage();
        this.view.getCurrentTool().drawOverlay(this.view);
        ev.getGraphics().drawImage((Image)this.theImage, 0, 0, null);
    }

    private void prepareToRender() {
        if (this.bounds.height <= 0) {
            return;
        }
        this.view.prepareCameraForRendering();
        if (this.theImage == null || this.theImage.getWidth(null) != this.bounds.width || this.theImage.getHeight(null) != this.bounds.height) {
            if (this.bounds.width < 0 || this.bounds.height < 0) {
                this.bounds.height = 0;
                this.bounds.width = 0;
            }
            this.theImage = new BufferedImage(this.bounds.width, this.bounds.height, 3);
            this.pixel = ((DataBufferInt)this.theImage.getRaster().getDataBuffer()).getData();
            this.zbuffer = new int[this.bounds.width * this.bounds.height];
            if (this.imageGraphics != null) {
                this.imageGraphics.dispose();
            }
            this.imageGraphics = this.theImage.createGraphics();
            this.imageGraphics.setFont(this.view.getComponent().getFont());
        }
        int rgb = ViewerCanvas.backgroundColor.getRGB();
        for (int i = 0; i < this.pixel.length; ++i) {
            this.pixel[i] = rgb;
            this.zbuffer[i] = Integer.MAX_VALUE;
        }
        if (this.view.getTemplateShown()) {
            int width = this.view.getTemplateImage().getWidth(null);
            int height = this.view.getTemplateImage().getHeight(null);
            int maxi = height < this.bounds.height ? height : this.bounds.height;
            int maxj = width < this.bounds.width ? width : this.bounds.width;
            for (int i = 0; i < maxi; ++i) {
                System.arraycopy(this.templatePixel, width * i, this.pixel, this.bounds.width * i, maxj);
            }
        }
    }

    @Override
    public void drawBorder() {
        boolean drawFocus = this.view.getDrawFocus();
        int index1 = 0;
        int index2 = this.bounds.width - 1;
        int black = -16777216;
        int line = ViewerCanvas.lineColor.getRGB();
        int i = 0;
        while (i < this.bounds.height) {
            this.pixel[index1] = this.pixel[index2] = black;
            if (drawFocus) {
                int n = Color.GRAY.getRGB();
                this.pixel[index2 - 1] = n;
                this.pixel[index1 + 1] = n;
            }
            ++i;
            index1 += this.bounds.width;
            index2 += this.bounds.width;
        }
        index1 = this.bounds.width * (this.bounds.height - 1);
        for (i = 1; i < this.bounds.width - 1; ++i) {
            int n = black;
            this.pixel[index1 + i] = n;
            this.pixel[i] = n;
            if (!drawFocus) continue;
            int n2 = Color.GRAY.getRGB();
            this.pixel[index1 + i - this.bounds.width] = n2;
            this.pixel[i + this.bounds.width] = n2;
        }
    }

    @Override
    public void drawHRule(int y, Color color) {
        int index = y * this.bounds.width;
        int col = color.getRGB();
        int i = 0;
        while (i < this.bounds.width) {
            this.pixel[index] = col;
            ++i;
            ++index;
        }
    }

    @Override
    public void drawVRule(int x, Color color) {
        int index = x;
        int col = color.getRGB();
        int i = 0;
        while (i < this.bounds.height) {
            this.pixel[index] = col;
            ++i;
            index += this.bounds.width;
        }
    }

    @Override
    public void drawBox(int x, int y, int width, int height, Color color) {
        int col = color.getRGB();
        int maxx = x + width;
        int maxy = y + height;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (maxx > this.bounds.width) {
            maxx = this.bounds.width;
        }
        if (maxy > this.bounds.height) {
            maxy = this.bounds.height;
        }
        width = maxx - x;
        int i = y;
        int index = y * this.bounds.width + x;
        while (i < maxy) {
            for (int j = 0; j < width; ++j) {
                this.pixel[index + j] = col;
            }
            ++i;
            index += this.bounds.width;
        }
    }

    @Override
    public void drawBoxes(List<Rectangle> box, Color color) {
        for (int i = 0; i < box.size(); ++i) {
            Rectangle r = box.get(i);
            this.drawBox(r.x, r.y, r.width, r.height, color);
        }
    }

    @Override
    public void renderBox(int x, int y, int width, int height, double depth, Color color) {
        int col = color.getRGB();
        int z = (int)(depth * 65535.0);
        int maxx = x + width;
        int maxy = y + height;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (maxx > this.bounds.width) {
            maxx = this.bounds.width;
        }
        if (maxy > this.bounds.height) {
            maxy = this.bounds.height;
        }
        width = maxx - x;
        int i = y;
        int index = y * this.bounds.width + x;
        while (i < maxy) {
            for (int j = 0; j < width; ++j) {
                if (z > this.zbuffer[index + j]) continue;
                this.pixel[index + j] = col;
                this.zbuffer[index + j] = z;
            }
            ++i;
            index += this.bounds.width;
        }
    }

    @Override
    public void renderBoxes(List<Rectangle> box, List<Double> depth, Color color) {
        for (int i = 0; i < box.size(); ++i) {
            Rectangle r = box.get(i);
            this.renderBox(r.x, r.y, r.width, r.height, depth.get(i), color);
        }
    }

    @Override
    public void drawLine(Point p1, Point p2, Color color) {
        int col = color.getRGB();
        int x1 = p1.x;
        int y1 = p1.y;
        int x2 = p2.x;
        int y2 = p2.y;
        if (x1 < 0 && x2 < 0) {
            return;
        }
        if (y1 < 0 && y2 < 0) {
            return;
        }
        if (x1 >= this.bounds.width && x2 >= this.bounds.width) {
            return;
        }
        if (y1 >= this.bounds.height && y2 >= this.bounds.height) {
            return;
        }
        int dx = x2 - x1;
        int dy = y2 - y1;
        if (dx == 0 && dy == 0) {
            return;
        }
        dx = Math.max(dx, -2147483647);
        dy = Math.max(dy, -2147483647);
        if (Math.abs(dx) > Math.abs(dy)) {
            int end;
            int y;
            int x;
            if (dx > 0) {
                x = x1;
                y = y1 << 32784;
                dy = (dy << 16) / dx;
                end = x2 < this.bounds.width ? x2 : this.bounds.width;
            } else {
                x = x2;
                y = y2 << 32784;
                dy = (dy << 16) / dx;
                int n = end = x1 < this.bounds.width ? x1 : this.bounds.width;
            }
            if (x < 0) {
                y -= dy * x;
                x = 0;
            }
            int edge = this.bounds.height << 16;
            while (x < end) {
                if (y >= 0 && y < edge) {
                    int index = this.bounds.width * (y >> 16) + x;
                    this.pixel[index] = col;
                }
                ++x;
                y += dy;
            }
        } else {
            int end;
            int y;
            int x;
            if (dy > 0) {
                x = x1 << 32784;
                y = y1;
                dx = (dx << 16) / dy;
                end = y2 < this.bounds.height ? y2 : this.bounds.height;
            } else {
                x = x2 << 32784;
                y = y2;
                dx = (dx << 16) / dy;
                int n = end = y1 < this.bounds.height ? y1 : this.bounds.height;
            }
            if (y < 0) {
                x -= dx * y;
                y = 0;
            }
            int edge = this.bounds.width << 16;
            while (y < end) {
                if (x >= 0 && x < edge) {
                    int index = y * this.bounds.width + (x >> 16);
                    this.pixel[index] = col;
                }
                x += dx;
                ++y;
            }
        }
    }

    @Override
    public void renderLine(Vec3 p1, Vec3 p2, Camera cam, Color color) {
        if (cam.isPerspective()) {
            double z1 = cam.getObjectToView().timesZ(p1);
            double z2 = cam.getObjectToView().timesZ(p2);
            double clip = cam.getClipDistance();
            if (z1 < clip) {
                if (z2 < clip) {
                    return;
                }
                double f = (clip - z1) / (z2 - z1);
                p1 = new Vec3(p1.x + f * (p2.x - p1.x), p1.y + f * (p2.y - p1.y), p1.z + f * (p2.z - p1.z));
            } else if (z2 < clip) {
                double f = (clip - z2) / (z1 - z2);
                p2 = new Vec3(p2.x + f * (p1.x - p2.x), p2.y + f * (p1.y - p2.y), p2.z + f * (p1.z - p2.z));
            }
        }
        this.renderLine(cam.getObjectToScreen().timesXY(p1), cam.getObjectToView().timesZ(p1), cam.getObjectToScreen().timesXY(p2), cam.getObjectToView().timesZ(p2), cam, color);
    }

    @Override
    public void renderLine(Vec2 p1, double zf1, Vec2 p2, double zf2, Camera cam, Color color) {
        int clip = (int)(cam.isPerspective() ? cam.getClipDistance() * 65535.0 : -2.147483648E9);
        int rgb = color.getRGB();
        int x1 = (int)p1.x;
        int y1 = (int)p1.y;
        int z1 = (int)(zf1 * 65535.0);
        int x2 = (int)p2.x;
        int y2 = (int)p2.y;
        int z2 = (int)(zf2 * 65535.0);
        if (x1 < 0 && x2 < 0) {
            return;
        }
        if (y1 < 0 && y2 < 0) {
            return;
        }
        if (x1 >= this.bounds.width && x2 >= this.bounds.width) {
            return;
        }
        if (y1 >= this.bounds.height && y2 >= this.bounds.height) {
            return;
        }
        if (z1 < clip && z2 < clip) {
            return;
        }
        if (this.view.getRenderMode() == 0) {
            this.drawLine(new Point(x1, y1), new Point(x2, y2), color);
            return;
        }
        int dx = x2 - x1;
        int dy = y2 - y1;
        int dz = z2 - z1;
        if (dx == 0 && dy == 0) {
            return;
        }
        dx = Math.max(dx, -2147483647);
        dy = Math.max(dy, -2147483647);
        if (Math.abs(dx) > Math.abs(dy)) {
            int end;
            int z;
            int y;
            int x;
            if (dx > 0) {
                x = x1;
                y = y1 << 32784;
                z = z1;
                dy = (dy << 16) / dx;
                dz /= dx;
                end = x2 < this.bounds.width ? x2 : this.bounds.width;
            } else {
                x = x2;
                y = y2 << 32784;
                z = z2;
                dy = (dy << 16) / dx;
                dz /= dx;
                int n = end = x1 < this.bounds.width ? x1 : this.bounds.width;
            }
            if (x < 0) {
                y -= dy * x;
                z -= dz * x;
                x = 0;
            }
            int edge = this.bounds.height << 16;
            while (x < end) {
                int index;
                if (y >= 0 && y < edge && z > clip && z <= this.zbuffer[index = this.bounds.width * (y >> 16) + x]) {
                    this.pixel[index] = rgb;
                    this.zbuffer[index] = z;
                }
                ++x;
                y += dy;
                z += dz;
            }
        } else {
            int end;
            int z;
            int y;
            int x;
            if (dy > 0) {
                x = x1 << 32784;
                y = y1;
                z = z1;
                dx = (dx << 16) / dy;
                dz /= dy;
                end = y2 < this.bounds.height ? y2 : this.bounds.height;
            } else {
                x = x2 << 32784;
                y = y2;
                z = z2;
                dx = (dx << 16) / dy;
                dz /= dy;
                int n = end = y1 < this.bounds.height ? y1 : this.bounds.height;
            }
            if (y < 0) {
                x -= dx * y;
                z -= dz * y;
                y = 0;
            }
            int edge = this.bounds.width << 16;
            while (y < end) {
                int index;
                if (x >= 0 && x < edge && z > clip && z <= this.zbuffer[index = y * this.bounds.width + (x >> 16)]) {
                    this.pixel[index] = rgb;
                    this.zbuffer[index] = z;
                }
                x += dx;
                ++y;
                z += dz;
            }
        }
    }

    private Vec2[] clipTriangle(Vec3 v1, Vec3 v2, Vec3 v3, double z1, double z2, double z3, Camera cam, double[] newz) {
        Vec3 u4;
        Vec3 u3;
        Vec3 u2;
        Vec3 u1;
        double clip = cam.getClipDistance();
        Mat4 toScreen = cam.getObjectToScreen();
        boolean c1 = z1 < clip;
        boolean c2 = z2 < clip;
        boolean c3 = z3 < clip;
        int clipCount = 0;
        if (c1) {
            ++clipCount;
        }
        if (c2) {
            ++clipCount;
        }
        if (c3) {
            ++clipCount;
        }
        if (clipCount == 2) {
            Vec3 u32;
            Vec3 u22;
            Vec3 u12;
            if (!c1) {
                u12 = v1;
                newz[0] = z1;
                double f2 = (z1 - clip) / (z1 - z2);
                double f1 = 1.0 - f2;
                u22 = new Vec3(f1 * v1.x + f2 * v2.x, f1 * v1.y + f2 * v2.y, f1 * v1.z + f2 * v2.z);
                newz[1] = f1 * z1 + f2 * z2;
                f2 = (z1 - clip) / (z1 - z3);
                f1 = 1.0 - f2;
                u32 = new Vec3(f1 * v1.x + f2 * v3.x, f1 * v1.y + f2 * v3.y, f1 * v1.z + f2 * v3.z);
                newz[2] = f1 * z1 + f2 * z3;
            } else if (!c2) {
                u22 = v2;
                newz[1] = z2;
                double f2 = (z2 - clip) / (z2 - z3);
                double f1 = 1.0 - f2;
                u32 = new Vec3(f1 * v2.x + f2 * v3.x, f1 * v2.y + f2 * v3.y, f1 * v2.z + f2 * v3.z);
                newz[2] = f1 * z2 + f2 * z3;
                f2 = (z2 - clip) / (z2 - z1);
                f1 = 1.0 - f2;
                u12 = new Vec3(f1 * v2.x + f2 * v1.x, f1 * v2.y + f2 * v1.y, f1 * v2.z + f2 * v1.z);
                newz[0] = f1 * z2 + f2 * z1;
            } else {
                u32 = v3;
                newz[2] = z3;
                double f2 = (z3 - clip) / (z3 - z1);
                double f1 = 1.0 - f2;
                u12 = new Vec3(f1 * v3.x + f2 * v1.x, f1 * v3.y + f2 * v1.y, f1 * v3.z + f2 * v1.z);
                newz[0] = f1 * z3 + f2 * z1;
                f2 = (z3 - clip) / (z3 - z2);
                f1 = 1.0 - f2;
                u22 = new Vec3(f1 * v3.x + f2 * v2.x, f1 * v3.y + f2 * v2.y, f1 * v3.z + f2 * v2.z);
                newz[1] = f1 * z3 + f2 * z2;
            }
            return new Vec2[]{toScreen.timesXY(u12), toScreen.timesXY(u22), toScreen.timesXY(u32)};
        }
        if (c1) {
            u1 = v2;
            newz[0] = z2;
            u2 = v3;
            newz[1] = z3;
            double f1 = (z2 - clip) / (z2 - z1);
            double f2 = 1.0 - f1;
            u3 = new Vec3(f1 * v1.x + f2 * v2.x, f1 * v1.y + f2 * v2.y, f1 * v1.z + f2 * v2.z);
            newz[2] = f1 * z1 + f2 * z2;
            f1 = (z3 - clip) / (z3 - z1);
            f2 = 1.0 - f1;
            u4 = new Vec3(f1 * v1.x + f2 * v3.x, f1 * v1.y + f2 * v3.y, f1 * v1.z + f2 * v3.z);
            newz[3] = f1 * z1 + f2 * z3;
        } else if (c2) {
            u1 = v3;
            newz[0] = z3;
            u2 = v1;
            newz[1] = z1;
            double f1 = (z3 - clip) / (z3 - z2);
            double f2 = 1.0 - f1;
            u3 = new Vec3(f1 * v2.x + f2 * v3.x, f1 * v2.y + f2 * v3.y, f1 * v2.z + f2 * v3.z);
            newz[2] = f1 * z2 + f2 * z3;
            f1 = (z1 - clip) / (z1 - z2);
            f2 = 1.0 - f1;
            u4 = new Vec3(f1 * v2.x + f2 * v1.x, f1 * v2.y + f2 * v1.y, f1 * v2.z + f2 * v1.z);
            newz[3] = f1 * z2 + f2 * z1;
        } else {
            u1 = v1;
            newz[0] = z1;
            u2 = v2;
            newz[1] = z2;
            double f1 = (z1 - clip) / (z1 - z3);
            double f2 = 1.0 - f1;
            u3 = new Vec3(f1 * v3.x + f2 * v1.x, f1 * v3.y + f2 * v1.y, f1 * v3.z + f2 * v1.z);
            newz[2] = f1 * z3 + f2 * z1;
            f1 = (z2 - clip) / (z2 - z3);
            f2 = 1.0 - f1;
            u4 = new Vec3(f1 * v3.x + f2 * v2.x, f1 * v3.y + f2 * v2.y, f1 * v3.z + f2 * v2.z);
            newz[3] = f1 * z3 + f2 * z2;
        }
        return new Vec2[]{toScreen.timesXY(u1), toScreen.timesXY(u2), toScreen.timesXY(u3), toScreen.timesXY(u4)};
    }

    @Override
    public void renderWireframe(WireframeMesh mesh, Camera cam, Color color) {
        Vec3[] vert = mesh.vert;
        int[] from = mesh.from;
        int[] to = mesh.to;
        for (int i = 0; i < from.length; ++i) {
            this.renderLine(vert[from[i]], vert[to[i]], cam, color);
        }
    }

    @Override
    public void renderMeshTransparent(RenderingMesh mesh, VertexShader shader, Camera cam, Vec3 viewDir, boolean[] hideFace) {
        int i;
        Vec3[] vert = mesh.vert;
        Vec2[] pos = new Vec2[vert.length];
        double[] z = new double[vert.length];
        double clip = cam.getClipDistance();
        double[] clipz = new double[4];
        Mat4 toView = cam.getObjectToView();
        Mat4 toScreen = cam.getObjectToScreen();
        RGBColor faceColor = new RGBColor(0.0f, 0.0f, 0.0f);
        int mode = ViewerCanvas.backgroundColor.getGreen() > 127 ? 2 : 1;
        int numToReuse = Math.min(vert.length, reuseVec2.length);
        for (i = 0; i < numToReuse; ++i) {
            pos[i] = toScreen.timesXY(vert[i], reuseVec2[i]);
            z[i] = toView.timesZ(vert[i]);
        }
        for (i = numToReuse; i < vert.length; ++i) {
            pos[i] = toScreen.timesXY(vert[i]);
            z[i] = toView.timesZ(vert[i]);
        }
        for (i = 0; i < mesh.triangle.length; ++i) {
            if (hideFace != null && hideFace[i]) continue;
            RenderingTriangle tri = mesh.triangle[i];
            int v1 = tri.v1;
            int v2 = tri.v2;
            int v3 = tri.v3;
            if (z[v1] < clip && z[v2] < clip && z[v3] < clip) continue;
            float dot = (float)viewDir.dot(mesh.faceNorm[i]);
            shader.getColor(i, 0, faceColor);
            if (mode == 2) {
                faceColor.setRGB(1.0f - faceColor.getRed(), 1.0f - faceColor.getGreen(), 1.0f - faceColor.getBlue());
            } else {
                faceColor.setRGB(faceColor.getRed(), faceColor.getGreen(), faceColor.getBlue());
            }
            faceColor.scale(1.0f - 0.8f * Math.abs(dot));
            if (z[v1] < clip || z[v2] < clip || z[v3] < clip) {
                int j;
                Vec2[] clipPos = this.clipTriangle(vert[v1], vert[v2], vert[v3], z[v1], z[v2], z[v3], cam, clipz);
                boolean inside = true;
                for (j = 0; j < clipPos.length; ++j) {
                    if (!(clipPos[j].x < -32767.0 || clipPos[j].x > 32767.0 || clipPos[j].y < -32767.0) && !(clipPos[j].y > 32767.0)) continue;
                    inside = false;
                }
                if (!inside) continue;
                for (j = 0; j < clipPos.length - 2; ++j) {
                    this.renderFlatTriangle(clipPos[j], clipz[j], clipPos[j + 1], clipz[j + 1], clipPos[j + 2], clipz[j + 2], this.bounds.width, this.bounds.height, clip, mode, faceColor);
                }
                continue;
            }
            this.renderFlatTriangle(pos[v1], z[v1], pos[v2], z[v2], pos[v3], z[v3], this.bounds.width, this.bounds.height, clip, mode, faceColor);
        }
    }

    @Override
    public void renderMesh(RenderingMesh mesh, VertexShader shader, Camera cam, boolean closed, boolean[] hideFace) {
        int i;
        Vec3[] vert = mesh.vert;
        Vec2[] pos = new Vec2[vert.length];
        double[] z = new double[vert.length];
        double clip = cam.getClipDistance();
        double[] clipz = new double[4];
        Mat4 toView = cam.getObjectToView();
        Mat4 toScreen = cam.getObjectToScreen();
        RGBColor color1 = new RGBColor();
        RGBColor color2 = new RGBColor();
        RGBColor color3 = new RGBColor();
        RGBColor color4 = new RGBColor();
        RGBColor color5 = new RGBColor();
        RGBColor color6 = new RGBColor();
        RGBColor color7 = new RGBColor();
        if (hideFace != null) {
            closed = false;
        }
        int numToReuse = Math.min(vert.length, reuseVec2.length);
        for (i = 0; i < numToReuse; ++i) {
            pos[i] = toScreen.timesXY(vert[i], reuseVec2[i]);
            z[i] = toView.timesZ(vert[i]);
        }
        for (i = numToReuse; i < vert.length; ++i) {
            pos[i] = toScreen.timesXY(vert[i]);
            z[i] = toView.timesZ(vert[i]);
        }
        for (i = 0; i < mesh.triangle.length; ++i) {
            int j;
            boolean inside;
            Vec2[] clipPos;
            boolean needClipping;
            if (hideFace != null && hideFace[i]) continue;
            RenderingTriangle tri = mesh.triangle[i];
            int v1 = tri.v1;
            int v2 = tri.v2;
            int v3 = tri.v3;
            if (z[v1] < clip && z[v2] < clip && z[v3] < clip) continue;
            boolean backface = closed && this.hideBackfaces && (pos[v2].x - pos[v1].x) * (pos[v3].y - pos[v1].y) - (pos[v2].y - pos[v1].y) * (pos[v3].x - pos[v1].x) > 0.0;
            boolean bl = needClipping = z[v1] < clip || z[v2] < clip || z[v3] < clip;
            if (backface && !needClipping) continue;
            shader.getColor(i, 0, color1);
            if (shader.isUniformFace(i)) {
                if (needClipping) {
                    clipPos = this.clipTriangle(vert[v1], vert[v2], vert[v3], z[v1], z[v2], z[v3], cam, clipz);
                    inside = true;
                    for (j = 0; j < clipPos.length; ++j) {
                        if (!(clipPos[j].x < -32767.0 || clipPos[j].x > 32767.0 || clipPos[j].y < -32767.0) && !(clipPos[j].y > 32767.0)) continue;
                        inside = false;
                    }
                    if (!inside) continue;
                    for (j = 0; j < clipPos.length - 2; ++j) {
                        this.renderFlatTriangle(clipPos[j], clipz[j], clipPos[j + 1], clipz[j + 1], clipPos[j + 2], clipz[j + 2], this.bounds.width, this.bounds.height, clip, 0, color1);
                    }
                    continue;
                }
                this.renderFlatTriangle(pos[v1], z[v1], pos[v2], z[v2], pos[v3], z[v3], this.bounds.width, this.bounds.height, clip, 0, color1);
                continue;
            }
            shader.getColor(i, 1, color2);
            shader.getColor(i, 2, color3);
            if (needClipping) {
                clipPos = this.clipSmoothTriangle(vert[v1], vert[v2], vert[v3], z[v1], z[v2], z[v3], cam, color1, color2, color3, color4, color5, color6, color7, clipz);
                inside = true;
                for (j = 0; j < clipPos.length; ++j) {
                    if (!(clipPos[j].x < -32767.0 || clipPos[j].x > 32767.0 || clipPos[j].y < -32767.0) && !(clipPos[j].y > 32767.0)) continue;
                    inside = false;
                }
                if (!inside) continue;
                this.renderSmoothTriangle(clipPos[0], clipz[0], clipPos[1], clipz[1], clipPos[2], clipz[2], this.bounds.width, this.bounds.height, clip, color4, color5, color6);
                if (clipPos.length != 4) continue;
                this.renderSmoothTriangle(clipPos[1], clipz[1], clipPos[2], clipz[2], clipPos[3], clipz[3], this.bounds.width, this.bounds.height, clip, color5, color6, color7);
                continue;
            }
            this.renderSmoothTriangle(pos[v1], z[v1], pos[v2], z[v2], pos[v3], z[v3], this.bounds.width, this.bounds.height, clip, color1, color2, color3);
        }
    }

    private Vec2[] clipSmoothTriangle(Vec3 v1, Vec3 v2, Vec3 v3, double z1, double z2, double z3, Camera cam, RGBColor col1, RGBColor col2, RGBColor col3, RGBColor newc1, RGBColor newc2, RGBColor newc3, RGBColor newc4, double[] newz) {
        Vec3 u4;
        Vec3 u3;
        Vec3 u2;
        Vec3 u1;
        double clip = cam.getClipDistance();
        Mat4 toScreen = cam.getObjectToScreen();
        boolean c1 = z1 < clip;
        boolean c2 = z2 < clip;
        boolean c3 = z3 < clip;
        int clipCount = 0;
        if (c1) {
            ++clipCount;
        }
        if (c2) {
            ++clipCount;
        }
        if (c3) {
            ++clipCount;
        }
        if (clipCount == 2) {
            Vec3 u32;
            Vec3 u22;
            Vec3 u12;
            if (!c1) {
                u12 = v1;
                newz[0] = z1;
                newc1.copy(col1);
                double f2 = (z1 - clip) / (z1 - z2);
                double f1 = 1.0 - f2;
                u22 = new Vec3(f1 * v1.x + f2 * v2.x, f1 * v1.y + f2 * v2.y, f1 * v1.z + f2 * v2.z);
                newc2.setRGB(f1 * (double)col1.getRed() + f2 * (double)col2.getRed(), f1 * (double)col1.getGreen() + f2 * (double)col2.getGreen(), f1 * (double)col1.getBlue() + f2 * (double)col2.getBlue());
                newz[1] = f1 * z1 + f2 * z2;
                f2 = (z1 - clip) / (z1 - z3);
                f1 = 1.0 - f2;
                u32 = new Vec3(f1 * v1.x + f2 * v3.x, f1 * v1.y + f2 * v3.y, f1 * v1.z + f2 * v3.z);
                newc3.setRGB(f1 * (double)col1.getRed() + f2 * (double)col3.getRed(), f1 * (double)col1.getGreen() + f2 * (double)col3.getGreen(), f1 * (double)col1.getBlue() + f2 * (double)col3.getBlue());
                newz[2] = f1 * z1 + f2 * z3;
            } else if (!c2) {
                u22 = v2;
                newz[1] = z2;
                newc2.copy(col2);
                double f2 = (z2 - clip) / (z2 - z3);
                double f1 = 1.0 - f2;
                u32 = new Vec3(f1 * v2.x + f2 * v3.x, f1 * v2.y + f2 * v3.y, f1 * v2.z + f2 * v3.z);
                newc3.setRGB(f1 * (double)col2.getRed() + f2 * (double)col3.getRed(), f1 * (double)col2.getGreen() + f2 * (double)col3.getGreen(), f1 * (double)col2.getBlue() + f2 * (double)col3.getBlue());
                newz[2] = f1 * z2 + f2 * z3;
                f2 = (z2 - clip) / (z2 - z1);
                f1 = 1.0 - f2;
                u12 = new Vec3(f1 * v2.x + f2 * v1.x, f1 * v2.y + f2 * v1.y, f1 * v2.z + f2 * v1.z);
                newc1.setRGB(f1 * (double)col2.getRed() + f2 * (double)col3.getRed(), f1 * (double)col2.getGreen() + f2 * (double)col3.getGreen(), f1 * (double)col2.getBlue() + f2 * (double)col3.getBlue());
                newz[0] = f1 * z2 + f2 * z1;
            } else {
                u32 = v3;
                newz[2] = z3;
                newc3.copy(col3);
                double f2 = (z3 - clip) / (z3 - z1);
                double f1 = 1.0 - f2;
                u12 = new Vec3(f1 * v3.x + f2 * v1.x, f1 * v3.y + f2 * v1.y, f1 * v3.z + f2 * v1.z);
                newc1.setRGB(f1 * (double)col3.getRed() + f2 * (double)col1.getRed(), f1 * (double)col3.getGreen() + f2 * (double)col1.getGreen(), f1 * (double)col3.getBlue() + f2 * (double)col1.getBlue());
                newz[0] = f1 * z3 + f2 * z1;
                f2 = (z3 - clip) / (z3 - z2);
                f1 = 1.0 - f2;
                u22 = new Vec3(f1 * v3.x + f2 * v2.x, f1 * v3.y + f2 * v2.y, f1 * v3.z + f2 * v2.z);
                newc2.setRGB(f1 * (double)col3.getRed() + f2 * (double)col2.getRed(), f1 * (double)col3.getGreen() + f2 * (double)col2.getGreen(), f1 * (double)col3.getBlue() + f2 * (double)col2.getBlue());
                newz[1] = f1 * z3 + f2 * z2;
            }
            return new Vec2[]{toScreen.timesXY(u12), toScreen.timesXY(u22), toScreen.timesXY(u32)};
        }
        if (c1) {
            u1 = v2;
            newz[0] = z2;
            newc1.copy(col2);
            u2 = v3;
            newz[1] = z3;
            newc2.copy(col3);
            double f1 = (z2 - clip) / (z2 - z1);
            double f2 = 1.0 - f1;
            u3 = new Vec3(f1 * v1.x + f2 * v2.x, f1 * v1.y + f2 * v2.y, f1 * v1.z + f2 * v2.z);
            newc3.setRGB(f1 * (double)col1.getRed() + f2 * (double)col2.getRed(), f1 * (double)col1.getGreen() + f2 * (double)col2.getGreen(), f1 * (double)col1.getBlue() + f2 * (double)col2.getBlue());
            newz[2] = f1 * z1 + f2 * z2;
            f1 = (z3 - clip) / (z3 - z1);
            f2 = 1.0 - f1;
            u4 = new Vec3(f1 * v1.x + f2 * v3.x, f1 * v1.y + f2 * v3.y, f1 * v1.z + f2 * v3.z);
            newc4.setRGB(f1 * (double)col1.getRed() + f2 * (double)col3.getRed(), f1 * (double)col1.getGreen() + f2 * (double)col3.getGreen(), f1 * (double)col1.getBlue() + f2 * (double)col3.getBlue());
            newz[3] = f1 * z1 + f2 * z3;
        } else if (c2) {
            u1 = v3;
            newz[0] = z3;
            newc1.copy(col3);
            u2 = v1;
            newz[1] = z1;
            newc2.copy(col1);
            double f1 = (z3 - clip) / (z3 - z2);
            double f2 = 1.0 - f1;
            u3 = new Vec3(f1 * v2.x + f2 * v3.x, f1 * v2.y + f2 * v3.y, f1 * v2.z + f2 * v3.z);
            newc3.setRGB(f1 * (double)col2.getRed() + f2 * (double)col3.getRed(), f1 * (double)col2.getGreen() + f2 * (double)col3.getGreen(), f1 * (double)col2.getBlue() + f2 * (double)col3.getBlue());
            newz[2] = f1 * z2 + f2 * z3;
            f1 = (z1 - clip) / (z1 - z2);
            f2 = 1.0 - f1;
            u4 = new Vec3(f1 * v2.x + f2 * v1.x, f1 * v2.y + f2 * v1.y, f1 * v2.z + f2 * v1.z);
            newc4.setRGB(f1 * (double)col2.getRed() + f2 * (double)col1.getRed(), f1 * (double)col2.getGreen() + f2 * (double)col1.getGreen(), f1 * (double)col2.getBlue() + f2 * (double)col1.getBlue());
            newz[3] = f1 * z2 + f2 * z1;
        } else {
            u1 = v1;
            newz[0] = z1;
            newc1.copy(col1);
            u2 = v2;
            newz[1] = z2;
            newc2.copy(col2);
            double f1 = (z1 - clip) / (z1 - z3);
            double f2 = 1.0 - f1;
            u3 = new Vec3(f1 * v3.x + f2 * v1.x, f1 * v3.y + f2 * v1.y, f1 * v3.z + f2 * v1.z);
            newc3.setRGB(f1 * (double)col3.getRed() + f2 * (double)col1.getRed(), f1 * (double)col3.getGreen() + f2 * (double)col1.getGreen(), f1 * (double)col3.getBlue() + f2 * (double)col1.getBlue());
            newz[2] = f1 * z3 + f2 * z1;
            f1 = (z2 - clip) / (z2 - z3);
            f2 = 1.0 - f1;
            u4 = new Vec3(f1 * v3.x + f2 * v2.x, f1 * v3.y + f2 * v2.y, f1 * v3.z + f2 * v2.z);
            newc4.setRGB(f1 * (double)col3.getRed() + f2 * (double)col2.getRed(), f1 * (double)col3.getGreen() + f2 * (double)col2.getGreen(), f1 * (double)col3.getBlue() + f2 * (double)col2.getBlue());
            newz[3] = f1 * z3 + f2 * z2;
        }
        return new Vec2[]{toScreen.timesXY(u1), toScreen.timesXY(u2), toScreen.timesXY(u3), toScreen.timesXY(u4)};
    }

    private void renderFlatTriangle(Vec2 pos1, double zf1, Vec2 pos2, double zf2, Vec2 pos3, double zf3, int width, int height, double clip, int mode, RGBColor color) {
        int b;
        int g;
        int r;
        int i;
        int dz;
        int z;
        int right;
        int left;
        int index;
        int yend;
        int mz2;
        int mx2;
        int zend;
        int xend;
        int z3;
        int y3;
        int x3;
        int z2;
        int y2;
        int x2;
        int z1;
        int y1;
        int x1;
        int red;
        int green;
        int blue;
        int col;
        int clipDist = (int)(clip * 65535.0);
        if (mode == 0) {
            col = color.getARGB();
            blue = 0;
            green = 0;
            red = 0;
        } else {
            col = 0;
            red = (int)(color.getRed() * 255.0f);
            green = (int)(color.getGreen() * 255.0f);
            blue = (int)(color.getBlue() * 255.0f);
        }
        if (pos1.y <= pos2.y && pos1.y <= pos3.y) {
            x1 = (int)pos1.x << 16;
            y1 = (int)pos1.y;
            z1 = (int)(zf1 * 65535.0);
            if (pos2.y < pos3.y) {
                x2 = (int)pos2.x << 16;
                y2 = (int)pos2.y;
                z2 = (int)(zf2 * 65535.0);
                x3 = (int)pos3.x << 16;
                y3 = (int)pos3.y;
                z3 = (int)(zf3 * 65535.0);
            } else {
                x2 = (int)pos3.x << 16;
                y2 = (int)pos3.y;
                z2 = (int)(zf3 * 65535.0);
                x3 = (int)pos2.x << 16;
                y3 = (int)pos2.y;
                z3 = (int)(zf2 * 65535.0);
            }
        } else if (pos2.y <= pos1.y && pos2.y <= pos3.y) {
            x1 = (int)pos2.x << 16;
            y1 = (int)pos2.y;
            z1 = (int)(zf2 * 65535.0);
            if (pos1.y < pos3.y) {
                x2 = (int)pos1.x << 16;
                y2 = (int)pos1.y;
                z2 = (int)(zf1 * 65535.0);
                x3 = (int)pos3.x << 16;
                y3 = (int)pos3.y;
                z3 = (int)(zf3 * 65535.0);
            } else {
                x2 = (int)pos3.x << 16;
                y2 = (int)pos3.y;
                z2 = (int)(zf3 * 65535.0);
                x3 = (int)pos1.x << 16;
                y3 = (int)pos1.y;
                z3 = (int)(zf1 * 65535.0);
            }
        } else {
            x1 = (int)pos3.x << 16;
            y1 = (int)pos3.y;
            z1 = (int)(zf3 * 65535.0);
            if (pos1.y < pos2.y) {
                x2 = (int)pos1.x << 16;
                y2 = (int)pos1.y;
                z2 = (int)(zf1 * 65535.0);
                x3 = (int)pos2.x << 16;
                y3 = (int)pos2.y;
                z3 = (int)(zf2 * 65535.0);
            } else {
                x2 = (int)pos2.x << 16;
                y2 = (int)pos2.y;
                z2 = (int)(zf2 * 65535.0);
                x3 = (int)pos1.x << 16;
                y3 = (int)pos1.y;
                z3 = (int)(zf1 * 65535.0);
            }
        }
        int dx1 = x3 - x1;
        int dy1 = y3 - y1;
        int dz1 = z3 - z1;
        if (dy1 == 0) {
            return;
        }
        int dx2 = x2 - x1;
        int dy2 = y2 - y1;
        int dz2 = z2 - z1;
        int mx1 = dx1 / dy1;
        int mz1 = dz1 / dy1;
        int xstart = xend = x1;
        int zstart = zend = z1;
        int y = y1;
        if (dy2 != 0) {
            mx2 = dx2 / dy2;
            mz2 = dz2 / dy2;
            if (y2 < 0) {
                xstart += mx1 * dy2;
                xend += mx2 * dy2;
                zstart += mz1 * dy2;
                zend += mz2 * dy2;
                y = y2;
            } else if (y < 0) {
                xstart -= mx1 * y;
                xend -= mx2 * y;
                zstart -= mz1 * y;
                zend -= mz2 * y;
                y = 0;
            }
            yend = y2 < height ? y2 : height;
            index = y * width;
            while (y < yend) {
                if (xstart < xend) {
                    left = xstart >> 16;
                    right = xend >> 16;
                    z = zstart;
                    dz = zend - zstart;
                } else {
                    left = xend >> 16;
                    right = xstart >> 16;
                    z = zend;
                    dz = zstart - zend;
                }
                if (left != right) {
                    dz /= right - left;
                    if (left < 0) {
                        z -= left * dz;
                        left = 0;
                    }
                    if (right > width) {
                        right = width;
                    }
                    if (mode == 0) {
                        for (i = left; i < right; ++i) {
                            if (z < this.zbuffer[index + i] && z > clipDist) {
                                this.pixel[index + i] = col;
                                this.zbuffer[index + i] = z;
                            }
                            z += dz;
                        }
                    } else if (mode == 1) {
                        for (i = left; i < right; ++i) {
                            if (z > clipDist) {
                                r = ((this.pixel[index + i] & 0xFF0000) >> 16) + red;
                                g = ((this.pixel[index + i] & 0xFF00) >> 8) + green;
                                b = (this.pixel[index + i] & 0xFF) + blue;
                                if (r > 255) {
                                    r = 255;
                                }
                                if (g > 255) {
                                    g = 255;
                                }
                                if (b > 255) {
                                    b = 255;
                                }
                                this.pixel[index + i] = -16777216 + (r << 16) + (g << 8) + b;
                            }
                            z += dz;
                        }
                    } else {
                        for (i = left; i < right; ++i) {
                            if (z > clipDist) {
                                r = ((this.pixel[index + i] & 0xFF0000) >> 16) - red;
                                g = ((this.pixel[index + i] & 0xFF00) >> 8) - green;
                                b = (this.pixel[index + i] & 0xFF) - blue;
                                if (r < 0) {
                                    r = 0;
                                }
                                if (g < 0) {
                                    g = 0;
                                }
                                if (b < 0) {
                                    b = 0;
                                }
                                this.pixel[index + i] = -16777216 + (r << 16) + (g << 8) + b;
                            }
                            z += dz;
                        }
                    }
                }
                xstart += mx1;
                zstart += mz1;
                xend += mx2;
                zend += mz2;
                index += width;
                ++y;
            }
        }
        dx2 = x3 - x2;
        dy2 = y3 - y2;
        dz2 = z3 - z2;
        if (dy2 != 0) {
            mx2 = dx2 / dy2;
            mz2 = dz2 / dy2;
            xend = x2;
            zend = z2;
            if (y < 0) {
                xstart -= mx1 * y;
                xend -= mx2 * y;
                zstart -= mz1 * y;
                zend -= mz2 * y;
                y = 0;
            }
            yend = y3 < height ? y3 : height;
            index = y * width;
            while (y < yend) {
                if (xstart < xend) {
                    left = xstart >> 16;
                    right = xend >> 16;
                    z = zstart;
                    dz = zend - zstart;
                } else {
                    left = xend >> 16;
                    right = xstart >> 16;
                    z = zend;
                    dz = zstart - zend;
                }
                if (left != right) {
                    dz /= right - left;
                    if (left < 0) {
                        z -= left * dz;
                        left = 0;
                    }
                    if (right > width) {
                        right = width;
                    }
                    if (mode == 0) {
                        for (i = left; i < right; ++i) {
                            if (z < this.zbuffer[index + i] && z > clipDist) {
                                this.pixel[index + i] = col;
                                this.zbuffer[index + i] = z;
                            }
                            z += dz;
                        }
                    } else if (mode == 1) {
                        for (i = left; i < right; ++i) {
                            if (z > clipDist) {
                                r = ((this.pixel[index + i] & 0xFF0000) >> 16) + red;
                                g = ((this.pixel[index + i] & 0xFF00) >> 8) + green;
                                b = (this.pixel[index + i] & 0xFF) + blue;
                                if (r > 255) {
                                    r = 255;
                                }
                                if (g > 255) {
                                    g = 255;
                                }
                                if (b > 255) {
                                    b = 255;
                                }
                                this.pixel[index + i] = -16777216 + (r << 16) + (g << 8) + b;
                            }
                            z += dz;
                        }
                    } else {
                        for (i = left; i < right; ++i) {
                            if (z > clipDist) {
                                r = ((this.pixel[index + i] & 0xFF0000) >> 16) - red;
                                g = ((this.pixel[index + i] & 0xFF00) >> 8) - green;
                                b = (this.pixel[index + i] & 0xFF) - blue;
                                if (r < 0) {
                                    r = 0;
                                }
                                if (g < 0) {
                                    g = 0;
                                }
                                if (b < 0) {
                                    b = 0;
                                }
                                this.pixel[index + i] = -16777216 + (r << 16) + (g << 8) + b;
                            }
                            z += dz;
                        }
                    }
                }
                xstart += mx1;
                zstart += mz1;
                xend += mx2;
                zend += mz2;
                index += width;
                ++y;
            }
        }
    }

    private void renderSmoothTriangle(Vec2 pos1, double zf1, Vec2 pos2, double zf2, Vec2 pos3, double zf3, int width, int height, double clip, RGBColor color1, RGBColor color2, RGBColor color3) {
        int i;
        int dblue;
        int blue;
        int dgreen;
        int green;
        int dred;
        int red;
        int dz;
        int z;
        int right;
        int left;
        int index;
        int yend;
        int mblue2;
        int mgreen2;
        int mred2;
        int mz2;
        int mx2;
        int blueend;
        int greenend;
        int redend;
        int zend;
        int xend;
        int blue3;
        int green3;
        int red3;
        int z3;
        int y3;
        int x3;
        int blue2;
        int green2;
        int red2;
        int z2;
        int y2;
        int x2;
        int blue1;
        int green1;
        int red1;
        int z1;
        int y1;
        int x1;
        int clipDist = (int)(clip * 65535.0);
        if (pos1.y <= pos2.y && pos1.y <= pos3.y) {
            x1 = (int)pos1.x << 16;
            y1 = (int)pos1.y;
            z1 = (int)(zf1 * 65535.0);
            red1 = (int)(color1.getRed() * 65535.0f);
            green1 = (int)(color1.getGreen() * 65535.0f);
            blue1 = (int)(color1.getBlue() * 65535.0f);
            if (pos2.y < pos3.y) {
                x2 = (int)pos2.x << 16;
                y2 = (int)pos2.y;
                z2 = (int)(zf2 * 65535.0);
                red2 = (int)(color2.getRed() * 65535.0f);
                green2 = (int)(color2.getGreen() * 65535.0f);
                blue2 = (int)(color2.getBlue() * 65535.0f);
                x3 = (int)pos3.x << 16;
                y3 = (int)pos3.y;
                z3 = (int)(zf3 * 65535.0);
                red3 = (int)(color3.getRed() * 65535.0f);
                green3 = (int)(color3.getGreen() * 65535.0f);
                blue3 = (int)(color3.getBlue() * 65535.0f);
            } else {
                x2 = (int)pos3.x << 16;
                y2 = (int)pos3.y;
                z2 = (int)(zf3 * 65535.0);
                red2 = (int)(color3.getRed() * 65535.0f);
                green2 = (int)(color3.getGreen() * 65535.0f);
                blue2 = (int)(color3.getBlue() * 65535.0f);
                x3 = (int)pos2.x << 16;
                y3 = (int)pos2.y;
                z3 = (int)(zf2 * 65535.0);
                red3 = (int)(color2.getRed() * 65535.0f);
                green3 = (int)(color2.getGreen() * 65535.0f);
                blue3 = (int)(color2.getBlue() * 65535.0f);
            }
        } else if (pos2.y <= pos1.y && pos2.y <= pos3.y) {
            x1 = (int)pos2.x << 16;
            y1 = (int)pos2.y;
            z1 = (int)(zf2 * 65535.0);
            red1 = (int)(color2.getRed() * 65535.0f);
            green1 = (int)(color2.getGreen() * 65535.0f);
            blue1 = (int)(color2.getBlue() * 65535.0f);
            if (pos1.y < pos3.y) {
                x2 = (int)pos1.x << 16;
                y2 = (int)pos1.y;
                z2 = (int)(zf1 * 65535.0);
                red2 = (int)(color1.getRed() * 65535.0f);
                green2 = (int)(color1.getGreen() * 65535.0f);
                blue2 = (int)(color1.getBlue() * 65535.0f);
                x3 = (int)pos3.x << 16;
                y3 = (int)pos3.y;
                z3 = (int)(zf3 * 65535.0);
                red3 = (int)(color3.getRed() * 65535.0f);
                green3 = (int)(color3.getGreen() * 65535.0f);
                blue3 = (int)(color3.getBlue() * 65535.0f);
            } else {
                x2 = (int)pos3.x << 16;
                y2 = (int)pos3.y;
                z2 = (int)(zf3 * 65535.0);
                red2 = (int)(color3.getRed() * 65535.0f);
                green2 = (int)(color3.getGreen() * 65535.0f);
                blue2 = (int)(color3.getBlue() * 65535.0f);
                x3 = (int)pos1.x << 16;
                y3 = (int)pos1.y;
                z3 = (int)(zf1 * 65535.0);
                red3 = (int)(color1.getRed() * 65535.0f);
                green3 = (int)(color1.getGreen() * 65535.0f);
                blue3 = (int)(color1.getBlue() * 65535.0f);
            }
        } else {
            x1 = (int)pos3.x << 16;
            y1 = (int)pos3.y;
            z1 = (int)(zf3 * 65535.0);
            red1 = (int)(color3.getRed() * 65535.0f);
            green1 = (int)(color3.getGreen() * 65535.0f);
            blue1 = (int)(color3.getBlue() * 65535.0f);
            if (pos1.y < pos2.y) {
                x2 = (int)pos1.x << 16;
                y2 = (int)pos1.y;
                z2 = (int)(zf1 * 65535.0);
                red2 = (int)(color1.getRed() * 65535.0f);
                green2 = (int)(color1.getGreen() * 65535.0f);
                blue2 = (int)(color1.getBlue() * 65535.0f);
                x3 = (int)pos2.x << 16;
                y3 = (int)pos2.y;
                z3 = (int)(zf2 * 65535.0);
                red3 = (int)(color2.getRed() * 65535.0f);
                green3 = (int)(color2.getGreen() * 65535.0f);
                blue3 = (int)(color2.getBlue() * 65535.0f);
            } else {
                x2 = (int)pos2.x << 16;
                y2 = (int)pos2.y;
                z2 = (int)(zf2 * 65535.0);
                red2 = (int)(color2.getRed() * 65535.0f);
                green2 = (int)(color2.getGreen() * 65535.0f);
                blue2 = (int)(color2.getBlue() * 65535.0f);
                x3 = (int)pos1.x << 16;
                y3 = (int)pos1.y;
                z3 = (int)(zf1 * 65535.0);
                red3 = (int)(color1.getRed() * 65535.0f);
                green3 = (int)(color1.getGreen() * 65535.0f);
                blue3 = (int)(color1.getBlue() * 65535.0f);
            }
        }
        int dx1 = x3 - x1;
        int dy1 = y3 - y1;
        int dz1 = z3 - z1;
        if (dy1 == 0) {
            return;
        }
        int dred1 = red3 - red1;
        int dgreen1 = green3 - green1;
        int dblue1 = blue3 - blue1;
        int dx2 = x2 - x1;
        int dy2 = y2 - y1;
        int dz2 = z2 - z1;
        int dred2 = red2 - red1;
        int dgreen2 = green2 - green1;
        int dblue2 = blue2 - blue1;
        int mx1 = dx1 / dy1;
        int mz1 = dz1 / dy1;
        int mred1 = dred1 / dy1;
        int mgreen1 = dgreen1 / dy1;
        int mblue1 = dblue1 / dy1;
        int xstart = xend = x1;
        int zstart = zend = z1;
        int redstart = redend = red1;
        int greenstart = greenend = green1;
        int bluestart = blueend = blue1;
        int y = y1;
        if (dy2 != 0) {
            mx2 = dx2 / dy2;
            mz2 = dz2 / dy2;
            mred2 = dred2 / dy2;
            mgreen2 = dgreen2 / dy2;
            mblue2 = dblue2 / dy2;
            if (y2 < 0) {
                xstart += mx1 * dy2;
                xend += mx2 * dy2;
                zstart += mz1 * dy2;
                zend += mz2 * dy2;
                redstart += mred1 * dy2;
                redend += mred2 * dy2;
                greenstart += mgreen1 * dy2;
                greenend += mgreen2 * dy2;
                bluestart += mblue1 * dy2;
                blueend += mblue2 * dy2;
                y = y2;
            } else if (y < 0) {
                xstart -= mx1 * y;
                xend -= mx2 * y;
                zstart -= mz1 * y;
                zend -= mz2 * y;
                redstart -= mred1 * y;
                redend -= mred2 * y;
                greenstart -= mgreen1 * y;
                greenend -= mgreen2 * y;
                bluestart -= mblue1 * y;
                blueend -= mblue2 * y;
                y = 0;
            }
            yend = y2 < height ? y2 : height;
            index = y * width;
            while (y < yend) {
                if (xstart < xend) {
                    left = xstart >> 16;
                    right = xend >> 16;
                    z = zstart;
                    dz = zend - zstart;
                    red = redstart;
                    dred = redend - redstart;
                    green = greenstart;
                    dgreen = greenend - greenstart;
                    blue = bluestart;
                    dblue = blueend - bluestart;
                } else {
                    left = xend >> 16;
                    right = xstart >> 16;
                    z = zend;
                    dz = zstart - zend;
                    red = redend;
                    dred = redstart - redend;
                    green = greenend;
                    dgreen = greenstart - greenend;
                    blue = blueend;
                    dblue = bluestart - blueend;
                }
                if (left != right) {
                    dz /= right - left;
                    dred /= right - left;
                    dgreen /= right - left;
                    dblue /= right - left;
                    if (left < 0) {
                        z -= left * dz;
                        red -= left * dred;
                        green -= left * dgreen;
                        blue -= left * dblue;
                        left = 0;
                    }
                    if (right > width) {
                        right = width;
                    }
                    for (i = left; i < right; ++i) {
                        if (z < this.zbuffer[index + i] && z > clipDist) {
                            this.pixel[index + i] = -16777216 + ((red & 0xFF00) << 8) + (green & 0xFF00) + (blue >> 8);
                            this.zbuffer[index + i] = z;
                        }
                        z += dz;
                        red += dred;
                        green += dgreen;
                        blue += dblue;
                    }
                }
                xstart += mx1;
                zstart += mz1;
                redstart += mred1;
                greenstart += mgreen1;
                bluestart += mblue1;
                xend += mx2;
                zend += mz2;
                redend += mred2;
                greenend += mgreen2;
                blueend += mblue2;
                index += width;
                ++y;
            }
        }
        dx2 = x3 - x2;
        dy2 = y3 - y2;
        dz2 = z3 - z2;
        dred2 = red3 - red2;
        dgreen2 = green3 - green2;
        dblue2 = blue3 - blue2;
        if (dy2 != 0) {
            mx2 = dx2 / dy2;
            mz2 = dz2 / dy2;
            mred2 = dred2 / dy2;
            mgreen2 = dgreen2 / dy2;
            mblue2 = dblue2 / dy2;
            xend = x2;
            zend = z2;
            redend = red2;
            greenend = green2;
            blueend = blue2;
            if (y < 0) {
                xstart -= mx1 * y;
                xend -= mx2 * y;
                zstart -= mz1 * y;
                zend -= mz2 * y;
                redstart -= mred1 * y;
                redend -= mred2 * y;
                greenstart -= mgreen1 * y;
                greenend -= mgreen2 * y;
                bluestart -= mblue1 * y;
                blueend -= mblue2 * y;
                y = 0;
            }
            yend = y3 < height ? y3 : height;
            index = y * width;
            while (y < yend) {
                if (xstart < xend) {
                    left = xstart >> 16;
                    right = xend >> 16;
                    z = zstart;
                    dz = zend - zstart;
                    red = redstart;
                    dred = redend - redstart;
                    green = greenstart;
                    dgreen = greenend - greenstart;
                    blue = bluestart;
                    dblue = blueend - bluestart;
                } else {
                    left = xend >> 16;
                    right = xstart >> 16;
                    z = zend;
                    dz = zstart - zend;
                    red = redend;
                    dred = redstart - redend;
                    green = greenend;
                    dgreen = greenstart - greenend;
                    blue = blueend;
                    dblue = bluestart - blueend;
                }
                if (left != right) {
                    dz /= right - left;
                    dred /= right - left;
                    dgreen /= right - left;
                    dblue /= right - left;
                    if (left < 0) {
                        z -= left * dz;
                        red -= left * dred;
                        green -= left * dgreen;
                        blue -= left * dblue;
                        left = 0;
                    }
                    if (right > width) {
                        right = width;
                    }
                    for (i = left; i < right; ++i) {
                        if (z < this.zbuffer[index + i] && z > clipDist) {
                            this.pixel[index + i] = -16777216 + ((red & 0xFF00) << 8) + (green & 0xFF00) + (blue >> 8);
                            this.zbuffer[index + i] = z;
                        }
                        z += dz;
                        red += dred;
                        green += dgreen;
                        blue += dblue;
                    }
                }
                xstart += mx1;
                zstart += mz1;
                redstart += mred1;
                greenstart += mgreen1;
                bluestart += mblue1;
                xend += mx2;
                zend += mz2;
                redend += mred2;
                greenend += mgreen2;
                blueend += mblue2;
                index += width;
                ++y;
            }
        }
    }

    @Override
    public void drawString(String text, int x, int y, Color color) {
        this.imageGraphics.setColor(color);
        this.imageGraphics.drawString(text, x, y);
    }

    @Override
    public void drawShape(Shape shape, Color color) {
        this.imageGraphics.setColor(color);
        this.imageGraphics.draw(shape);
    }

    @Override
    public void fillShape(Shape shape, Color color) {
        this.imageGraphics.setColor(color);
        this.imageGraphics.fill(shape);
    }

    @Override
    public void drawImage(Image image, int x, int y) {
        ImageRecord record = this.getCachedImage(image);
        if (record == null) {
            return;
        }
        int[] imagePixel = record.pixel;
        int width = record.width;
        int height = record.height;
        int starti = Math.max(0, -x);
        int startj = Math.max(0, -y);
        int endi = Math.min(width, this.bounds.width - x);
        int endj = Math.min(height, this.bounds.height - y);
        for (int j = startj; j < endj; ++j) {
            int srcOffset = j * width;
            int dstOffset = (j + y) * this.bounds.width + x;
            for (int i = starti; i < endi; ++i) {
                int pix = imagePixel[srcOffset + i];
                if ((pix & 0xFF000000) == 0) continue;
                this.pixel[dstOffset + i] = pix;
            }
        }
    }

    @Override
    public void renderImage(Image image, Vec3 p1, Vec3 p2, Vec3 p3, Vec3 p4, Camera camera) {
        final ImageRecord record = this.getCachedImage(image);
        if (record == null) {
            return;
        }
        RenderingMesh mesh = null;
        SoftReference<RenderingMesh> ref = imageMeshMap.get(image);
        if (ref != null) {
            mesh = ref.get();
        }
        int width = record.width + 1;
        int height = record.height + 1;
        Vec3 dx = p2.minus(p1).times(1.0 / (double)record.width);
        Vec3 dy = p4.minus(p1).times(1.0 / (double)record.height);
        if (mesh == null) {
            int j;
            int i;
            Vec3[] vert = new Vec3[width * height];
            Vec3[] norm = new Vec3[]{new Vec3()};
            RenderingTriangle[] tri = new RenderingTriangle[2 * record.width * record.height];
            for (i = 0; i < width; ++i) {
                for (j = 0; j < height; ++j) {
                    vert[i + j * width] = p1.plus(dx.times(i)).plus(dy.times(j));
                }
            }
            for (i = 0; i < record.width; ++i) {
                for (j = 0; j < record.height; ++j) {
                    int index = 2 * (i + (record.height - j - 1) * record.width);
                    tri[index] = new UniformTriangle(i + j * width, i + 1 + j * width, i + 1 + (j + 1) * width, 0, 0, 0);
                    tri[index + 1] = new UniformTriangle(i + j * width, i + 1 + (j + 1) * width, i + (j + 1) * width, 0, 0, 0);
                }
            }
            mesh = new RenderingMesh(vert, norm, tri, null, null);
            imageMeshMap.put(image, new SoftReference<RenderingMesh>(mesh));
        } else {
            for (int i = 0; i < width; ++i) {
                for (int j = 0; j < height; ++j) {
                    mesh.vert[i + j * width] = p1.plus(dx.times(i)).plus(dy.times(j));
                }
            }
        }
        this.renderMesh(mesh, new VertexShader(){

            @Override
            public void getColor(int face, int vertex, RGBColor color) {
                color.setARGB(record.pixel[face / 2]);
            }

            @Override
            public boolean isUniformFace(int face) {
                return true;
            }

            @Override
            public boolean isUniformTexture() {
                return false;
            }

            @Override
            public void getTextureSpec(TextureSpec spec) {
            }
        }, camera, false, null);
    }

    @Override
    public void imageChanged(Image image) {
        imageMap.remove(image);
    }

    private ImageRecord getCachedImage(Image image) {
        ImageRecord record = null;
        SoftReference<ImageRecord> ref = imageMap.get(image);
        if (ref != null) {
            record = ref.get();
        }
        if (record == null) {
            try {
                record = new ImageRecord(image);
                imageMap.put(image, new SoftReference<ImageRecord>(record));
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return record;
    }

    static {
        imageMap = new WeakHashMap();
        imageMeshMap = new WeakHashMap();
    }

    private static class ImageRecord {
        int[] pixel;
        int width;
        int height;

        ImageRecord(Image image) throws InterruptedException {
            try {
                PixelGrabber pg = new PixelGrabber(image, 0, 0, -1, -1, true);
                pg.grabPixels();
                this.pixel = (int[])pg.getPixels();
                this.width = image.getWidth(null);
                this.height = image.getHeight(null);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }
}

