/*
 * Decompiled with CFR 0.152.
 */
package de.onyxbits.giftedmotion;

import de.onyxbits.giftedmotion.ColorIcon;
import de.onyxbits.giftedmotion.Dict;
import de.onyxbits.giftedmotion.Settings;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SettingsEditor
extends JInternalFrame
implements ChangeListener,
ActionListener {
    private JSpinner repeat = new JSpinner(new SpinnerNumberModel(0, -1, 10000, 1));
    private JSpinner quality = new JSpinner(new SpinnerNumberModel(1, 1, 256, 1));
    private JButton trans = new JButton(new ColorIcon(Color.MAGENTA, 16, 16));
    private JColorChooser chooser = new JColorChooser(Color.MAGENTA);

    public SettingsEditor() {
        super(Dict.get("settingseditor.settingseditor.title"), false, true, false, false);
        this.setContentPane(this.getContent());
        this.chooser.setPreviewPanel(new JPanel());
        this.chooser.getSelectionModel().addChangeListener(this);
        this.trans.addActionListener(this);
        this.setDefaultCloseOperation(1);
        this.trans.setToolTipText(Dict.get("settingseditor.settingseditor.trans"));
        this.repeat.setToolTipText(Dict.get("settingseditor.settingseditor.repeat"));
        this.quality.setToolTipText(Dict.get("settingseditor.settingseditor.quality"));
        this.pack();
    }

    private JPanel getContent() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.chooser);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(3, 2));
        jPanel2.add(new JLabel(Dict.get("settingseditor.getcontent.trans")));
        jPanel2.add(this.trans);
        jPanel2.add(new JLabel(Dict.get("settingseditor.getcontent.dither")));
        jPanel2.add(this.quality);
        jPanel2.add(new JLabel(Dict.get("settingseditor.getcontent.repeat")));
        jPanel2.add(this.repeat);
        jPanel.add(jPanel2);
        return jPanel;
    }

    public Settings getSettings() {
        Settings settings = new Settings();
        settings.transparent = ((ColorIcon)this.trans.getIcon()).getColor();
        settings.quality = (Integer)this.quality.getValue();
        settings.repeat = (Integer)this.repeat.getValue();
        return settings;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.trans.setIcon(new ColorIcon(this.chooser.getColor(), 16, 16));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.trans.setIcon(new ColorIcon(null, 16, 16));
        this.chooser.setColor(null);
    }
}

