/*
 * Decompiled with CFR 0.152.
 */
package de.jave.formula.algorithm;

import de.jave.formula.algorithm.FormulaCharField;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class Formula2Symbols {
    private Map symbolMap = new LinkedHashMap();
    private static Formula2Symbols instance = new Formula2Symbols();

    public static Formula2Symbols getInstance() {
        return instance;
    }

    private Formula2Symbols() {
        this.symbolMap.put("alpha", Formula2Symbols.createSymbolCharField(0, new String[]{" _ _", "(_/_"}));
        this.symbolMap.put("beta", Formula2Symbols.createSymbolCharField(1, new String[]{" _", "|_)", "|_)", "|"}));
        this.symbolMap.put("gamma", Formula2Symbols.createSymbolCharField(0, new String[]{"\\/", "()"}));
        this.symbolMap.put("delta", Formula2Symbols.createSymbolCharField(0, new String[]{" (", "(_)"}));
        this.symbolMap.put("epsilon", Formula2Symbols.createSymbolCharField(0, new String[]{" _", "(_", "(_"}));
        this.symbolMap.put("zeta", Formula2Symbols.createSymbolCharField(1, new String[]{"._", "/-'", "\\_", " -'"}));
        this.symbolMap.put("eta", Formula2Symbols.createSymbolCharField(1, new String[]{" ._", " | |", "   |"}));
        this.symbolMap.put("theta", Formula2Symbols.createSymbolCharField(0, new String[]{" _", "/_\\", "\\_/"}));
        this.symbolMap.put("vartheta", Formula2Symbols.createSymbolCharField(1, new String[]{"  ,.", "  `+.", "') |", " `-'"}));
        this.symbolMap.put("iota", Formula2Symbols.createSymbolCharField(0, new String[]{"|", "|,"}));
        this.symbolMap.put("kappa", Formula2Symbols.createSymbolCharField(0, new String[]{"|/", "|\\"}));
        this.symbolMap.put("lambda", Formula2Symbols.createSymbolCharField(0, new String[]{"\\", "/\\"}));
        this.symbolMap.put("mu", Formula2Symbols.createSymbolCharField(1, new String[]{"|_|", "|"}));
        this.symbolMap.put("nu", Formula2Symbols.createSymbolCharField(0, new String[]{"| )", "|/"}));
        this.symbolMap.put("xi", Formula2Symbols.createSymbolCharField(1, new String[]{"._", "(.", "(_", " -'"}));
        this.symbolMap.put("omicron", Formula2Symbols.createSymbolCharField(0, new String[]{" _", "(_)"}));
        this.symbolMap.put("omikron", Formula2Symbols.createSymbolCharField(0, new String[]{" _", "(_)"}));
        this.symbolMap.put("pi", Formula2Symbols.createSymbolCharField(0, new String[]{"__", "||"}));
        this.symbolMap.put("rho", Formula2Symbols.createSymbolCharField(1, new String[]{" _", "|_)", "|"}));
        this.symbolMap.put("varrho", Formula2Symbols.createSymbolCharField(1, new String[]{" _", "(_)", " `-"}));
        this.symbolMap.put("sigma", Formula2Symbols.createSymbolCharField(0, new String[]{" __,", "(_)"}));
        this.symbolMap.put("varsigma", Formula2Symbols.createSymbolCharField(1, new String[]{" _,", "(_", "--'"}));
        this.symbolMap.put("tau", Formula2Symbols.createSymbolCharField(0, new String[]{" _,", "'|"}));
        this.symbolMap.put("upsilon", Formula2Symbols.createSymbolCharField(0, new String[]{") )", "`-'"}));
        this.symbolMap.put("phi", Formula2Symbols.createSymbolCharField(1, new String[]{" |", "(|)", " |"}));
        this.symbolMap.put("varphi", Formula2Symbols.createSymbolCharField(1, new String[]{"   _", "(_|_)", "  |"}));
        this.symbolMap.put("chi", Formula2Symbols.createSymbolCharField(0, new String[]{"'\\/", " /\\,"}));
        this.symbolMap.put("psi", Formula2Symbols.createSymbolCharField(1, new String[]{"(_|_)", "  |"}));
        this.symbolMap.put("omega", Formula2Symbols.createSymbolCharField(0, new String[]{"(_|_)"}));
        this.symbolMap.put("Alpha", Formula2Symbols.createSymbolCharField(0, new String[]{"  /\\", " /--\\", "/    \\"}));
        this.symbolMap.put("Beta", Formula2Symbols.createSymbolCharField(0, new String[]{" __", "|  )", "|--", "|__)"}));
        this.symbolMap.put("Gamma", Formula2Symbols.createSymbolCharField(0, new String[]{" __", "|  '", "|", "|"}));
        this.symbolMap.put("Delta", Formula2Symbols.createSymbolCharField(0, new String[]{"  /\\", " /  \\", "/____\\"}));
        this.symbolMap.put("Epsilon", Formula2Symbols.createSymbolCharField(0, new String[]{" __", "|", "|--", "|__"}));
        this.symbolMap.put("Zeta", Formula2Symbols.createSymbolCharField(0, new String[]{"___", "  /", " /", "/__"}));
        this.symbolMap.put("Eta", Formula2Symbols.createSymbolCharField(0, new String[]{"|  |", "|--|", "|  |"}));
        this.symbolMap.put("Theta", Formula2Symbols.createSymbolCharField(0, new String[]{"  _", " / \\", "| - |", " \\_/"}));
        this.symbolMap.put("Iota", Formula2Symbols.createSymbolCharField(0, new String[]{"`|'", " |", ".|,"}));
        this.symbolMap.put("Kappa", Formula2Symbols.createSymbolCharField(0, new String[]{"| /", "|/", "|\\", "| \\"}));
        this.symbolMap.put("Lambda", Formula2Symbols.createSymbolCharField(0, new String[]{"  /\\", " /  \\", "/    \\"}));
        this.symbolMap.put("Mu", Formula2Symbols.createSymbolCharField(0, new String[]{"|\\ /|", "| V |", "|   |"}));
        this.symbolMap.put("Nu", Formula2Symbols.createSymbolCharField(0, new String[]{"|\\  |", "| \\ |", "|  \\|"}));
        this.symbolMap.put("Xi", Formula2Symbols.createSymbolCharField(0, new String[]{" __", "'  `", " --", ".__,"}));
        this.symbolMap.put("Omicron", Formula2Symbols.createSymbolCharField(0, new String[]{"  __", " /  \\", "(    )", " \\__/"}));
        this.symbolMap.put("Omikron", Formula2Symbols.createSymbolCharField(0, new String[]{"  __", " /  \\", "(    )", " \\__/"}));
        this.symbolMap.put("Pi", Formula2Symbols.createSymbolCharField(0, new String[]{"-----", " | |", " | |"}));
        this.symbolMap.put("PI", Formula2Symbols.createSymbolCharField(0, new String[]{"-----", " | |", " | |"}));
        this.symbolMap.put("Rho", Formula2Symbols.createSymbolCharField(0, new String[]{" __", "|  |", "|--'", "|"}));
        this.symbolMap.put("Sigma", Formula2Symbols.createSymbolCharField(0, new String[]{"___", "\\", " >", "/__"}));
        this.symbolMap.put("Tau", Formula2Symbols.createSymbolCharField(0, new String[]{"_____", "  |", "  |", "  |"}));
        this.symbolMap.put("Upsilon", Formula2Symbols.createSymbolCharField(0, new String[]{"\\   /", " \\ /", "  |", "  |"}));
        this.symbolMap.put("Phi", Formula2Symbols.createSymbolCharField(0, new String[]{" _T_", "/ | \\", "\\_|_/", " .i."}));
        this.symbolMap.put("Chi", Formula2Symbols.createSymbolCharField(0, new String[]{"\\  /", " \\/", " /\\", "/  \\"}));
        this.symbolMap.put("Psi", Formula2Symbols.createSymbolCharField(0, new String[]{"   _", "|  |  |", " \\_|_/", "  .i."}));
        this.symbolMap.put("Omega", Formula2Symbols.createSymbolCharField(0, new String[]{"  __", " /  \\", "(    )", "_\\  /_"}));
        this.symbolMap.put("INFINITY", Formula2Symbols.createSymbolCharField(0, new String[]{"oo"}));
    }

    public FormulaCharField getSymbol(String name) {
        return (FormulaCharField)this.symbolMap.get(name);
    }

    private static FormulaCharField createSymbolCharField(int descent, String[] lines) {
        int height = lines.length;
        int ascent = height - descent - 1;
        return new FormulaCharField(lines, ascent);
    }

    public String[] getNames() {
        Set set = this.symbolMap.keySet();
        return set.toArray(new String[set.size()]);
    }
}

