/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii;

import de.jave.image.GImage;
import de.jave.image.Rotation;
import de.jave.image.greyscale.GGreyscaleImage;
import de.jave.image.greyscale.algorithm.dithering.IGreyscaleDithering;
import de.jave.image2ascii.IImage2AsciiAlgorithm;
import de.jave.lib.CharacterPlate;
import net.disy.commons.core.progress.ICancelable;
import net.disy.commons.core.progress.IProgressMonitor;
import net.disy.commons.core.progress.ProgressUtilities;
import net.disy.commons.core.util.Ensure;

public class ConversionJob {
    private final GGreyscaleImage originalImage;
    private final IImage2AsciiAlgorithm algorithm;
    private final int resultWidth;
    private final double shapeFactor;
    private final boolean normalize;
    private final boolean invert;
    private final int highlight;
    private final int shadow;
    private final double gamma;
    private final double sharpen;
    private final Rotation rotate;
    private final IProgressMonitor progressMonitor;
    private final IGreyscaleDithering dithering;

    public ConversionJob(IProgressMonitor progressMonitor, GGreyscaleImage image, int resultWidth, double shapeFactor, boolean normalize, boolean invert, int highlight, int shadow, double gamma, double sharpen, IGreyscaleDithering dithering, Rotation rotate, IImage2AsciiAlgorithm algorithm) {
        Ensure.ensureArgumentNotNull(progressMonitor);
        this.progressMonitor = progressMonitor;
        this.originalImage = image;
        this.resultWidth = resultWidth;
        this.shapeFactor = shapeFactor;
        this.normalize = normalize;
        this.invert = invert;
        this.shadow = shadow;
        this.highlight = highlight;
        this.gamma = gamma;
        this.sharpen = sharpen;
        this.dithering = dithering;
        this.algorithm = algorithm;
        this.rotate = rotate;
    }

    public CharacterPlate run(ICancelable cancelable) throws InterruptedException {
        this.progressMonitor.beginTask("Preparing image...", 5);
        Thread.yield();
        ProgressUtilities.checkInterrupted(cancelable);
        if (this.originalImage == null || this.resultWidth == 0) {
            return new CharacterPlate(0, 0);
        }
        int oldWidth = this.originalImage.getWidth();
        int oldHeight = this.originalImage.getHeight();
        Thread.yield();
        ProgressUtilities.checkInterrupted(cancelable);
        int newHeight = 0;
        int newWidth = 0;
        double dimFactor = this.shapeFactor * 0.52;
        if (this.rotate == Rotation.RIGHT || this.rotate == Rotation.LEFT) {
            newHeight = this.resultWidth;
            newWidth = (int)((double)newHeight / (double)oldHeight * (double)oldWidth * dimFactor);
            if (newHeight < 1) {
                newHeight = 1;
            }
            if (newWidth < 1) {
                newWidth = 1;
            }
            newHeight *= this.algorithm.getHorizontalPixelsPerChar();
            newWidth *= this.algorithm.getVerticalPixelsPerChar();
        } else {
            newWidth = this.resultWidth;
            newHeight = (int)((double)this.resultWidth / (double)oldWidth * (double)oldHeight * dimFactor);
            if (newHeight < 1) {
                newHeight = 1;
            }
            if (newWidth < 1) {
                newWidth = 1;
            }
            newHeight *= this.algorithm.getVerticalPixelsPerChar();
            newWidth *= this.algorithm.getHorizontalPixelsPerChar();
        }
        Thread.yield();
        ProgressUtilities.checkInterrupted(cancelable);
        GGreyscaleImage image = this.originalImage.getScaledInstance(newWidth, newHeight);
        Thread.yield();
        ProgressUtilities.checkInterrupted(cancelable);
        this.progressMonitor.worked(1);
        image = (GGreyscaleImage)image.rotate(this.rotate);
        Thread.yield();
        ProgressUtilities.checkInterrupted(cancelable);
        this.progressMonitor.worked(1);
        image = image.convert(this.normalize, this.invert, this.gamma, this.highlight, this.shadow);
        Thread.yield();
        ProgressUtilities.checkInterrupted(cancelable);
        this.progressMonitor.worked(1);
        if (this.sharpen > 0.0) {
            image = image.sharpen(this.sharpen);
        }
        Thread.yield();
        ProgressUtilities.checkInterrupted(cancelable);
        this.progressMonitor.worked(1);
        GImage gi = image;
        if (this.algorithm.isMonochromeImageRequired() && this.dithering != null) {
            gi = this.dithering.dither(image);
        }
        Thread.yield();
        ProgressUtilities.checkInterrupted(cancelable);
        this.progressMonitor.worked(1);
        CharacterPlate cp = this.algorithm.convert(gi, this.progressMonitor, cancelable);
        this.progressMonitor.done();
        return cp;
    }
}

