/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii;

import de.jave.image.GImage;
import de.jave.image.ImageLoader;
import de.jave.image.Rotation;
import de.jave.image.greyscale.GGreyscaleImage;
import de.jave.image.greyscale.GreyscaleImageFactory;
import de.jave.image.greyscale.algorithm.dithering.IGreyscaleDithering;
import de.jave.image2ascii.ConversionException;
import de.jave.image2ascii.Image2AsciiAlgorithm;
import de.jave.lib.CharacterPlate;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.IOException;
import net.disy.commons.core.exception.UnreachableCodeReachedException;
import net.disy.commons.core.progress.NonCancelable;
import net.disy.commons.core.progress.NullProgressMonitor;

public class Converter {
    public static CharacterPlate convert(File imageFile, Rotation rotate, double shapeFactor, int resultWidth, Image2AsciiAlgorithm algorithm, boolean normalize, boolean invert, double gamma, double highlight, double shadow, double sharpen, IGreyscaleDithering dithering) throws ConversionException {
        BufferedImage image = Converter.loadBufferedImage(imageFile);
        Dimension originalSize = new Dimension(image.getWidth(), image.getHeight());
        originalSize = Converter.adjustToRotation(rotate, originalSize);
        Dimension scaledSize = Converter.getRequiredScaledImageSize(shapeFactor, resultWidth, algorithm, originalSize);
        scaledSize = Converter.adjustToRotation(rotate, scaledSize);
        Image scaledImage = image.getScaledInstance(scaledSize.width, scaledSize.height, 4);
        GGreyscaleImage image2 = Converter.convertToGreyScaleImage(scaledImage, scaledSize);
        if (rotate != Rotation.NONE) {
            image2 = (GGreyscaleImage)image2.rotate(rotate);
        }
        image2 = image2.convert(normalize, invert, gamma, highlight, shadow);
        if (sharpen > 0.0) {
            image2 = image2.sharpen(sharpen);
        }
        GImage gi = image2;
        if (algorithm.isMonochromeImageRequired() && dithering != null) {
            gi = dithering.dither(image2);
        }
        try {
            return algorithm.convert(gi, new NullProgressMonitor(), NonCancelable.getInstance());
        }
        catch (InterruptedException e) {
            throw new UnreachableCodeReachedException(e);
        }
    }

    private static Dimension adjustToRotation(Rotation rotate, Dimension size) {
        if (rotate == Rotation.LEFT || rotate == Rotation.RIGHT) {
            return Converter.getSwapped(size);
        }
        return size;
    }

    private static Dimension getRequiredScaledImageSize(double shapeFactor, int resultWidth, Image2AsciiAlgorithm algorithm, Dimension originalSize) {
        int newWidth = resultWidth;
        double dimFactor = 0.52 * shapeFactor;
        int newHeight = (int)((double)newWidth / (double)originalSize.width * (double)originalSize.height * dimFactor);
        if (newHeight < 1) {
            newHeight = 1;
        }
        if (newWidth < 1) {
            newWidth = 1;
        }
        Dimension scaledSize = new Dimension(newWidth *= algorithm.getHorizontalPixelsPerChar(), newHeight *= algorithm.getVerticalPixelsPerChar());
        return scaledSize;
    }

    private static Dimension getSwapped(Dimension originalSize) {
        return new Dimension(originalSize.width, originalSize.height);
    }

    private static BufferedImage loadBufferedImage(File imageFile) throws ConversionException {
        BufferedImage image;
        try {
            image = ImageLoader.loadImage(imageFile);
        }
        catch (IOException e) {
            throw new ConversionException("Error loading image '" + imageFile.getAbsolutePath() + "'.", e);
        }
        return image;
    }

    private static GGreyscaleImage convertToGreyScaleImage(Image scaledImage, Dimension imageSize) throws ConversionException {
        int width = imageSize.width;
        int height = imageSize.height;
        int[] pixels = new int[width * height];
        PixelGrabber grabber = new PixelGrabber(scaledImage, 0, 0, width, height, pixels, 0, width);
        try {
            grabber.grabPixels();
        }
        catch (InterruptedException e) {
            throw new ConversionException("Internal Error", e);
        }
        if ((grabber.getStatus() & 0x80) != 0) {
            throw new ConversionException("Internal Error: image fetch aborted or errored");
        }
        return new GreyscaleImageFactory().createGreyscaleImage(pixels, width, height);
    }
}

