/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii.algorithm.dialog.banned;

import java.util.Arrays;
import java.util.HashSet;
import net.disy.commons.core.model.AbstractChangeableModel;

public class AsciiCharacterSetModel
extends AbstractChangeableModel {
    private String selectedCharacters = "";

    public AsciiCharacterSetModel() {
    }

    public AsciiCharacterSetModel(String characters) {
        this.setSelectedCharacters(characters);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AsciiCharacterSetModel)) {
            return false;
        }
        AsciiCharacterSetModel other = (AsciiCharacterSetModel)obj;
        return this.selectedCharacters.equals(other.selectedCharacters);
    }

    public void setSelectedCharacters(String selectedCharacters) {
        if (AsciiCharacterSetModel.isEquivalent(this.selectedCharacters, selectedCharacters)) {
            return;
        }
        this.selectedCharacters = selectedCharacters;
        this.fireChangeEvent();
    }

    public static boolean isEquivalent(String characters1, String characters2) {
        HashSet<Character> set1 = new HashSet<Character>();
        for (int i = 0; i < characters1.length(); ++i) {
            set1.add(new Character(characters1.charAt(i)));
        }
        HashSet<Character> set2 = new HashSet<Character>();
        for (int i = 0; i < characters2.length(); ++i) {
            set2.add(new Character(characters2.charAt(i)));
        }
        return ((Object)set1).equals(set2);
    }

    public String getSelectedCharacters() {
        return this.selectedCharacters;
    }

    public boolean isSelected(char character) {
        for (int i = 0; i < this.selectedCharacters.length(); ++i) {
            if (character != this.selectedCharacters.charAt(i)) continue;
            return true;
        }
        return false;
    }

    public String getNotSelectedCharacters() {
        StringBuffer sb = new StringBuffer();
        for (char character = ' '; character < '\u007f'; character = (char)(character + '\u0001')) {
            if (this.isSelected(character)) continue;
            sb.append(character);
        }
        return sb.toString();
    }

    public void setSelected(char character, boolean selected) {
        if (selected == this.isSelected(character)) {
            return;
        }
        if (selected) {
            this.setSelectedCharacters(AsciiCharacterSetModel.getSorted(this.selectedCharacters + character));
        } else {
            int index = this.selectedCharacters.indexOf(character);
            this.setSelectedCharacters(AsciiCharacterSetModel.getSorted(this.selectedCharacters.substring(0, index) + this.selectedCharacters.substring(index + 1)));
        }
    }

    private static String getSorted(String string) {
        char[] chars = string.toCharArray();
        Arrays.sort(chars);
        return new String(chars);
    }

    public void clear() {
        this.setSelectedCharacters("");
    }

    public void selectAll() {
        this.setUnselectedCharacters("");
    }

    public void setUnselectedCharacters(String unselected) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 95; ++i) {
            char character = (char)(i + 32);
            if (unselected.indexOf(character) != -1) continue;
            sb.append(character);
        }
        this.setSelectedCharacters(sb.toString());
    }
}

