/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii.tablecreation;

import de.jave.image.greyscale.GGreyscaleImage;
import de.jave.image2ascii.AsciiGreyscaleTable;
import de.jave.image2ascii.DynamicalGreyScaleTableCreator;
import de.jave.image2ascii.tablecreation.FieldBounds;
import java.awt.geom.Rectangle2D;

public class GreyScaleTableFromImageExtractor {
    public AsciiGreyscaleTable computeTables(GGreyscaleImage image, FieldBounds fieldBounds) {
        double[] table = new double[96];
        double[] tableNW = new double[96];
        double[] tableNE = new double[96];
        double[] tableSW = new double[96];
        double[] tableSE = new double[96];
        for (int i = 32; i < 127; ++i) {
            Rectangle2D rectangle2D = fieldBounds.getInnerFieldRectangle(i);
            double x0 = rectangle2D.getX();
            double x1 = rectangle2D.getX() + rectangle2D.getWidth();
            double y0 = rectangle2D.getY();
            double y1 = rectangle2D.getY() + rectangle2D.getHeight();
            double charWidth = rectangle2D.getWidth() / 2.0;
            double charHeight = rectangle2D.getHeight() / 2.0;
            double value = GreyScaleTableFromImageExtractor.sumUp(image, x0, x1, y0, y1);
            double cw2 = charWidth / 2.0;
            double ch2 = charHeight / 2.0;
            double cw = charWidth;
            double ch = charHeight;
            double valueNW = GreyScaleTableFromImageExtractor.sumUp(image, x0, x0 + cw2, y0, y0 + ch2) + GreyScaleTableFromImageExtractor.sumUp(image, x0 + cw, x0 + cw + cw2, y0, y0 + ch2) + GreyScaleTableFromImageExtractor.sumUp(image, x0 + cw, x0 + cw + cw2, y0 + ch, y0 + ch2 + ch) + GreyScaleTableFromImageExtractor.sumUp(image, x0, x0 + cw2, y0 + ch, y0 + ch2 + ch);
            double valueNE = GreyScaleTableFromImageExtractor.sumUp(image, x0 + cw2, x0 + cw, y0, y0 + ch2) + GreyScaleTableFromImageExtractor.sumUp(image, x0 + cw + cw2, x0 + cw + cw, y0, y0 + ch2) + GreyScaleTableFromImageExtractor.sumUp(image, x0 + cw + cw2, x0 + cw + cw, y0 + ch, y0 + ch + ch2) + GreyScaleTableFromImageExtractor.sumUp(image, x0 + cw2, x0 + cw, y0 + ch, y0 + ch + ch2);
            double valueSW = GreyScaleTableFromImageExtractor.sumUp(image, x0, x0 + cw2, y0 + ch2, y0 + ch) + GreyScaleTableFromImageExtractor.sumUp(image, x0 + cw, x0 + cw + cw2, y0 + ch2, y0 + ch) + GreyScaleTableFromImageExtractor.sumUp(image, x0 + cw, x0 + cw + cw2, y0 + ch2 + ch, y0 + ch + ch) + GreyScaleTableFromImageExtractor.sumUp(image, x0, x0 + cw2, y0 + ch2 + ch, y0 + ch + ch);
            double valueSE = GreyScaleTableFromImageExtractor.sumUp(image, x0 + cw2, x0 + cw, y0 + ch2, y0 + ch) + GreyScaleTableFromImageExtractor.sumUp(image, x0 + cw2 + cw, x0 + cw + cw, y0 + ch2, y0 + ch) + GreyScaleTableFromImageExtractor.sumUp(image, x0 + cw2 + cw, x0 + cw + cw, y0 + ch2 + ch, y0 + ch + ch) + GreyScaleTableFromImageExtractor.sumUp(image, x0 + cw2, x0 + cw, y0 + ch2 + ch, y0 + ch + ch);
            table[i - 32] = value;
            tableNW[i - 32] = valueNW;
            tableNE[i - 32] = valueNE;
            tableSW[i - 32] = valueSW;
            tableSE[i - 32] = valueSE;
        }
        return DynamicalGreyScaleTableCreator.createNormalizedGreyscaleTable(table, tableNW, tableNE, tableSW, tableSE);
    }

    private static final double sumUp(GGreyscaleImage image, double x0, double x1, double y0, double y1) {
        double sum = 0.0;
        int counter = 0;
        for (double xx = x0; xx < x1; xx += 0.25) {
            for (double yy = y0; yy < y1; yy += 0.25) {
                sum += (double)image.getValueAt(xx, yy);
                ++counter;
            }
        }
        return sum /= (double)counter;
    }
}

