/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.dialog.JDialogFactory;
import de.jave.image2ascii.BatchConversionAction;
import de.jave.image2ascii.DefaultSettingsAction;
import de.jave.image2ascii.IImage2AsciiResultTaker;
import de.jave.image2ascii.Image2Texter;
import de.jave.image2ascii.dialog.Image2AsciiSourceFilePanel;
import de.jave.image2ascii.dialog.ImageOpenPerformer;
import de.jave.image2ascii.model.Image2AsciiOptionsModel;
import de.jave.image2ascii.model.Image2AsciiSourceImageModel;
import de.jave.jave.preferences.AnimationExportPreferences;
import de.jave.jave.preferences.ColorScheme;
import de.jave.jave.watermark.WatermarkImageFile;
import de.jave.lib.CharacterPlate;
import de.jave.lib.gui.GuiUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import net.disy.commons.core.io.FileModel;
import net.disy.commons.core.message.Message;
import net.disy.commons.core.message.MessageType;
import net.disy.commons.core.model.ObjectModel;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.dialog.BasicDialogResources;
import net.disy.commons.swing.dialog.message.MessageDialogUtilities;
import net.disy.commons.swing.dialog.message.YesNoCancel;
import net.disy.commons.swing.fontchooser.model.FontModel;
import net.disy.commons.swing.layout.util.ButtonPanelBuilder;

public class Image2AsciiDialog {
    private final IImage2AsciiResultTaker resultTaker;
    private final Image2Texter editor;
    private final JDialog dialog;
    private final Image2AsciiSourceImageModel sourceImageModel;

    public Image2AsciiDialog(Component parentComponent, IImage2AsciiResultTaker resultTaker, FileModel currentDirectoryModel, FontModel displayFontModel, AnimationExportPreferences animationExportPreferences, ObjectModel<ColorScheme> colorSchemeModel) {
        Ensure.ensureArgumentNotNull(resultTaker);
        Ensure.ensureArgumentNotNull(colorSchemeModel);
        this.dialog = JDialogFactory.createJDialog(parentComponent, "Image2Ascii", true);
        this.dialog.setModal(true);
        this.resultTaker = resultTaker;
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Image2AsciiDialog.this.performCancel();
            }
        });
        this.sourceImageModel = new Image2AsciiSourceImageModel(currentDirectoryModel);
        Image2AsciiOptionsModel optionsModel = new Image2AsciiOptionsModel();
        this.editor = new Image2Texter(this.sourceImageModel, optionsModel, displayFontModel, colorSchemeModel);
        SmartAction insertAction = new SmartAction(BasicDialogResources.OK_TEXT_SMART){

            @Override
            protected void execute(Component parent) {
                Image2AsciiDialog.this.performOk(parent);
            }
        };
        SmartAction closeAction = new SmartAction(BasicDialogResources.CANCEL_TEXT_SMART){

            @Override
            protected void execute(Component parent) {
                Image2AsciiDialog.this.performCancel();
            }
        };
        JButton insertButton = new JButton(insertAction);
        ButtonPanelBuilder buttonPanelBuilder = new ButtonPanelBuilder();
        buttonPanelBuilder.add(new DefaultSettingsAction(optionsModel, this.sourceImageModel));
        buttonPanelBuilder.add(new BatchConversionAction(animationExportPreferences, optionsModel, displayFontModel, this.sourceImageModel));
        buttonPanelBuilder.add(insertButton);
        buttonPanelBuilder.add(closeAction);
        this.dialog.getRootPane().setDefaultButton(insertButton);
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.dialog.getContentPane().add(this.editor.getContent(), "Center");
        this.dialog.getContentPane().add((Component)buttonPanelBuilder.createPanel(), "South");
        this.dialog.pack();
        GuiUtilities.centerOnScreen(this.dialog);
    }

    private void performOk(Component parentComponent) {
        CharacterPlate cp = this.editor.getResult();
        if (cp != null) {
            YesNoCancel answer = MessageDialogUtilities.showYesNoCancelDialog(parentComponent, new Message("Image2Ascii", "Do you want to set the original image as watermark?", MessageType.QUESTION));
            if (answer == YesNoCancel.CANCEL) {
                return;
            }
            WatermarkImageFile watermarkImageFile = answer == YesNoCancel.YES ? new WatermarkImageFile(this.sourceImageModel.getSourceImage().getOriginalImage(), (File)this.sourceImageModel.getFileModel().getValue()) : null;
            this.resultTaker.takeImage2AsciiResult(cp, watermarkImageFile);
        }
        this.dialog.setVisible(false);
    }

    public boolean open(File file) {
        return new ImageOpenPerformer(this.sourceImageModel).performOpen(this.dialog, file);
    }

    private void performCancel() {
        this.dialog.setVisible(false);
    }

    public void show() {
        if (this.sourceImageModel.getSourceImage() == null) {
            WindowAdapter loadImageOnFirstShowDialogListener = new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    Image2AsciiDialog.this.dialog.removeWindowListener(this);
                    Image2AsciiSourceFilePanel sourceFilePanel = new Image2AsciiSourceFilePanel(Image2AsciiDialog.this.sourceImageModel);
                    sourceFilePanel.performOpenImage(Image2AsciiDialog.this.dialog);
                }
            };
            this.dialog.addWindowListener(loadImageOnFirstShowDialogListener);
        }
        this.dialog.setVisible(true);
    }
}

