/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.DocumentManager;
import de.jave.jave.JaveGlobalRessources;
import de.jave.lib.Toolbox;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import net.disy.commons.core.io.IOUtilities;

public class JaveStatusFile {
    private static final File FILE = new File(JaveGlobalRessources.TMP_FOLDER, "status.log");
    public static final File logDir = JaveGlobalRessources.TMP_FOLDER;

    public static synchronized boolean exists() {
        return FILE.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized String[] load() {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(FILE));
            String date = reader.readLine();
            int count = Integer.parseInt(reader.readLine());
            String[] statusData = new String[count * 2 + 2];
            statusData[0] = date;
            statusData[1] = String.valueOf(count);
            for (int i = 0; i < count * 2; ++i) {
                statusData[i + 2] = reader.readLine();
            }
            String[] stringArray = statusData;
            IOUtilities.close(reader);
            return stringArray;
        }
        catch (Exception e) {
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            IOUtilities.close(reader);
        }
    }

    public static void deleteAllLogFiles() {
        if (!(logDir.exists() && logDir.canRead() && logDir.isDirectory())) {
            return;
        }
        File[] list = logDir.listFiles();
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].getName().endsWith(".jlog")) continue;
            list[i].delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void saveLog(DocumentManager documentManager) {
        String[] s = documentManager.getDocumentStatusList();
        File newFile = new File(FILE.getAbsolutePath() + "1");
        BufferedWriter writer = null;
        try {
            if (!logDir.exists()) {
                logDir.mkdirs();
            }
            writer = new BufferedWriter(new FileWriter(newFile));
            writer.write(Toolbox.getDateString());
            writer.newLine();
            writer.write(String.valueOf(s.length / 2));
            writer.newLine();
            for (int i = 0; i < s.length; ++i) {
                writer.write(s[i]);
                writer.newLine();
            }
        }
        catch (IOException e) {
            System.err.println(e);
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                    if (FILE.exists()) {
                        FILE.delete();
                    }
                    newFile.renameTo(FILE);
                }
                catch (IOException e) {}
            }
        }
    }

    public static synchronized boolean delete() {
        if (FILE.exists()) {
            return FILE.delete();
        }
        return false;
    }
}

