/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.actions;

import de.jave.ascii.font.ChooseDisplayFontAction;
import de.jave.ascii.plate.textareabased.AsciiTextArea;
import de.jave.ascii.plate.textareabased.AsciiTextAreaProperties;
import de.jave.asciimation.action.AddNewFrameAction;
import de.jave.asciimation.action.AnimationEditorPropertiesAction;
import de.jave.asciimation.action.DeleteFrameAction;
import de.jave.asciimation.action.DuplicateFrameAction;
import de.jave.asciimation.action.ExportAnimationEditorAction;
import de.jave.asciimation.action.OpenAnimationAction;
import de.jave.gui.splash.StartupException;
import de.jave.jave.CharSetsConfiguration;
import de.jave.jave.CharacterSets;
import de.jave.jave.ColorScreenSaver;
import de.jave.jave.JavEApplication;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.actions.AsctrisAction;
import de.jave.jave.actions.ConvertMakingOfToAnimationAction;
import de.jave.jave.actions.CropAction;
import de.jave.jave.actions.CurrentColorSchemeModel;
import de.jave.jave.actions.DecodeSteganogramAction;
import de.jave.jave.actions.FigletExportWizardAction;
import de.jave.jave.actions.JaveActions;
import de.jave.jave.actions.LabyrinthAction;
import de.jave.jave.actions.OpenOnlineLocationAction;
import de.jave.jave.actions.RepairShakedLinesAction;
import de.jave.jave.actions.SelectionToClipartAction;
import de.jave.jave.actions.ShowVtViewerAction;
import de.jave.jave.actions.SmartMenu;
import de.jave.jave.actions.VersionCheckAction;
import de.jave.jave.actions.fileimport.JaveImportAction;
import de.jave.jave.actions.preferences.JavePreferencesAction;
import de.jave.jave.algorithm.AlignLeft;
import de.jave.jave.algorithm.AlignRight;
import de.jave.jave.algorithm.AsciiAntialiasing;
import de.jave.jave.algorithm.Asciify;
import de.jave.jave.algorithm.Brightness;
import de.jave.jave.algorithm.Center;
import de.jave.jave.algorithm.CenterByTheLine;
import de.jave.jave.algorithm.Clear;
import de.jave.jave.algorithm.CompressExpand;
import de.jave.jave.algorithm.FlipDynamicAction;
import de.jave.jave.algorithm.FlipStatic;
import de.jave.jave.algorithm.Invert;
import de.jave.jave.algorithm.JaveAlgorithm;
import de.jave.jave.algorithm.JaveAlgorithmAction;
import de.jave.jave.algorithm.LowerCase;
import de.jave.jave.algorithm.MirrorDynamicAction;
import de.jave.jave.algorithm.MirrorStatic;
import de.jave.jave.algorithm.RepairWrapped;
import de.jave.jave.algorithm.Rot13;
import de.jave.jave.algorithm.Rotate180Action;
import de.jave.jave.algorithm.Rotate180StaticAction;
import de.jave.jave.algorithm.Rotate90LeftAction;
import de.jave.jave.algorithm.Rotate90LeftStaticAction;
import de.jave.jave.algorithm.Rotate90RightAction;
import de.jave.jave.algorithm.Rotate90RightStaticAction;
import de.jave.jave.algorithm.ShakeLines;
import de.jave.jave.algorithm.Unasciify;
import de.jave.jave.algorithm.UpperCase;
import de.jave.jave.application.startup.JaveStartupRunnable;
import de.jave.jave.browser.JaveDocumentType;
import de.jave.jave.icon.JaveIcons;
import de.jave.jave.plate.DocumentEditorTitleFactory;
import de.jave.jave.plate.IDocumentEditor;
import de.jave.jave.plate.JaveMainPanel;
import de.jave.jave.preferences.AnimationExportPreferences;
import de.jave.jave.preferences.ColorScheme;
import de.jave.jave.preferences.JaveApplicationPreferences;
import de.jave.jave.preferences.PlatePreferences;
import de.jave.lib.gui.GuiUtilities;
import de.jave.preferences.JavePreferences;
import de.jave.util.RecentFileList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import net.disy.commons.core.message.IBasicMessage;
import net.disy.commons.core.message.Message;
import net.disy.commons.core.model.listener.IChangeListener;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.action.ActionWidgetFactory;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.dialog.message.MessageDialogFactory;
import net.disy.commons.swing.dialog.userdialog.DefaultDialogConfiguration;
import net.disy.commons.swing.dialog.userdialog.UserDialog;
import net.disy.commons.swing.dialog.userdialog.buttons.DialogButtonConfigurationFactory;
import net.disy.commons.swing.dialog.userdialog.page.AbstractDialogPage;
import net.disy.commons.swing.dialog.userdialog.page.IDialogPage;
import net.disy.commons.swing.fontchooser.model.FontModel;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.menu.HelpImplementedMenuBar;

public class JaveMenuBar
extends HelpImplementedMenuBar
implements ActionListener {
    private final JavEApplication jave;
    private final JMenu menuWindows;
    private final JMenu menuColor;
    private final JMenu menuView;
    private final JMenu menuModify;
    private final JMenu menuSelection;
    private JMenu menuCharacterSets;
    private final JMenuItem miRevert;
    private final JMenuItem miClose;
    private final JMenuItem miCloseAll;
    private final JMenuItem miUndo;
    private final JMenuItem miRedo;
    private final JMenuItem miSelectAll;
    private final JMenuItem miClear;
    private final JMenuItem miReplace;
    private final JMenuItem miCrash;
    private final JMenuItem miRender3D;
    private final JMenuItem miFunctionPlotter;
    private final JMenuItem miLife;
    private final JMenuItem miDoc2Watermark;
    private final JMenuItem miRepairIllegalReplace;
    private final JMenuItem miRepairIllegalRemove;
    private final JMenuItem miZoomPlus;
    private final JMenuItem miZoomMinus;
    private JMenuItem miNextWindow;
    private JMenuItem miPreviousWindow;
    private final JCheckBoxMenuItem[] miColorSchemes;
    private JCheckBoxMenuItem[] miCharacters;
    private JCheckBoxMenuItem[] windowMenuItems;
    private final JMenuItem miSelectionToBrush;
    private final JMenuItem miSelectionShrink;
    private final JMenuItem miSelectionExpand;
    private final JMenuItem miSelectionBrace;
    private final JMenuItem miSelectionDelete;
    private final List<JMenuItem> docOpenEnabledMenuItems = new ArrayList<JMenuItem>();
    private static final int[] windowShortcuts = new int[]{49, 50, 51, 52, 53, 54, 55, 56, 57, 48};

    public JaveMenuBar(final JavEApplication jave, JavePreferences javePreferences, final JaveMainPanel mainPanel, JaveActions actions, RecentFileList recentFileList, JaveApplicationPreferences preferences, PlatePreferences platePreferences) {
        int i;
        ButtonGroup bg;
        Ensure.ensureArgumentNotNull(platePreferences);
        Ensure.ensureArgumentNotNull(preferences);
        final CurrentColorSchemeModel currentColorSchemeModel = new CurrentColorSchemeModel(mainPanel.getActiveEditorModel());
        currentColorSchemeModel.addChangeListener(new IChangeListener(){

            @Override
            public void stateChanged() {
                JaveMenuBar.this.updateColorMenu(currentColorSchemeModel.getColorScheme(), mainPanel.getActiveEditorModel().getActiveEditor());
            }
        });
        this.jave = jave;
        this.miRevert = this.createMenuItem("Revert");
        this.miClose = this.createMenuItem("Close");
        this.miClose.setAccelerator(KeyStroke.getKeyStroke(87, 128));
        this.miCloseAll = this.createMenuItem("Close All");
        SmartAction exitAction = new SmartAction("Exit"){

            @Override
            protected void execute(Component parentComponent) {
                jave.performExit(parentComponent);
            }
        };
        JMenu menuRecent = new JMenu("Recent Files");
        menuRecent.setIcon(JaveIcons.OPEN_RECENT_ICON);
        recentFileList.setMenu(menuRecent);
        SmartMenu fileMenu = new SmartMenu("&File");
        fileMenu.add(actions.getNewDocumentAction());
        fileMenu.addSeparator();
        fileMenu.add(actions.getOpenAction());
        fileMenu.add(this.miRevert);
        fileMenu.add(menuRecent);
        fileMenu.add(actions.getBrowseAction());
        fileMenu.addSeparator();
        fileMenu.add(this.miClose);
        fileMenu.add(this.miCloseAll);
        fileMenu.addSeparator();
        fileMenu.add(actions.getSaveAction());
        fileMenu.add(actions.getSaveAsAction());
        fileMenu.add(actions.getSaveAllAction());
        fileMenu.addSeparator();
        fileMenu.add(new ConvertMakingOfToAnimationAction(preferences, jave, mainPanel));
        fileMenu.add(actions.getExportAction());
        fileMenu.addSeparator();
        fileMenu.add(actions.getQuickStartAction());
        fileMenu.addSeparator();
        fileMenu.add(exitAction);
        SmartMenu animationMenu = new SmartMenu("&Animation");
        animationMenu.add(actions.getNewAnimationAction());
        animationMenu.addSeparator();
        animationMenu.add(new OpenAnimationAction(mainPanel, jave, jave.getDocumentManager().getCurrentDirectoryModel()));
        animationMenu.add(new ShowVtViewerAction(jave.getDocumentManager().getCurrentDirectoryModel()));
        animationMenu.addSeparator();
        animationMenu.add(new JaveImportAction(jave, jave.getDocumentManager().getCurrentDirectoryModel()));
        animationMenu.add(new ExportAnimationEditorAction(mainPanel, jave.getDocumentManager().getCurrentDirectoryModel(), preferences.getDisplayFontModel(), new AnimationExportPreferences(javePreferences)));
        animationMenu.addSeparator();
        animationMenu.add(new AddNewFrameAction(mainPanel));
        animationMenu.add(new DuplicateFrameAction(mainPanel));
        animationMenu.add(new DeleteFrameAction(mainPanel));
        animationMenu.addSeparator();
        animationMenu.add(new AnimationEditorPropertiesAction(mainPanel));
        this.miUndo = this.createMenuItem("Undo");
        this.miUndo.setAccelerator(KeyStroke.getKeyStroke(90, 128));
        this.miRedo = this.createMenuItem("Redo");
        this.miRedo.setAccelerator(KeyStroke.getKeyStroke(89, 128));
        this.miSelectAll = this.createMenuItem("Select All");
        this.miSelectAll.setAccelerator(KeyStroke.getKeyStroke(65, 128));
        FontModel displayFontModel = preferences.getDisplayFontModel();
        this.miClear = this.createMenuItem(mainPanel, new Clear(), displayFontModel);
        this.miReplace = this.createMenuItem("Replace...");
        this.miReplace.setAccelerator(KeyStroke.getKeyStroke(72, 128));
        SmartMenu menuEdit = new SmartMenu("&Edit");
        menuEdit.add(this.miUndo);
        menuEdit.add(this.miRedo);
        menuEdit.addSeparator();
        menuEdit.add(actions.getCutAction());
        menuEdit.add(actions.getCopyAction());
        menuEdit.add(actions.getPasteAsNewSelectionAction());
        menuEdit.add(actions.getPasteAsNewDocumentAction());
        menuEdit.addSeparator();
        menuEdit.add(this.miSelectAll);
        menuEdit.addSeparator();
        menuEdit.add(this.miClear);
        menuEdit.add(new CropAction(jave, mainPanel));
        menuEdit.add(actions.getResizeAction());
        menuEdit.addSeparator();
        menuEdit.add(this.miReplace);
        JMenuItem miAntiAlias = this.createMenuItem(mainPanel, new AsciiAntialiasing(), displayFontModel);
        JMenuItem miRot13 = this.createMenuItem(mainPanel, new Rot13(), displayFontModel);
        JMenuItem miToUpperCase = this.createMenuItem(mainPanel, new UpperCase(), displayFontModel);
        JMenuItem miToLowerCase = this.createMenuItem(mainPanel, new LowerCase(), displayFontModel);
        JMenuItem miAsciify = this.createMenuItem(mainPanel, new Asciify(), displayFontModel);
        JMenuItem miUnasciify = this.createMenuItem(mainPanel, new Unasciify(), displayFontModel);
        JMenuItem miCenter = this.createMenuItem(mainPanel, new Center(), displayFontModel);
        JMenuItem miCenterByTheLine = this.createMenuItem(mainPanel, CenterByTheLine.getInstance(), displayFontModel);
        JMenuItem miAlignRight = this.createMenuItem(mainPanel, AlignRight.getInstance(), displayFontModel);
        JMenuItem miAlignLeft = this.createMenuItem(mainPanel, AlignLeft.getInstance(), displayFontModel);
        JMenuItem miFlip = this.createMenuItem(mainPanel, FlipDynamicAction.getInstance(), displayFontModel);
        miFlip.setIcon(JaveIcons.FLIP_DYNAMIC_ICON);
        JMenuItem miMirrorDynamic = this.createMenuItem(mainPanel, MirrorDynamicAction.getInstance(), displayFontModel);
        miMirrorDynamic.setIcon(JaveIcons.MIRROR_DYNAMIC_ICON);
        JMenu miRotate = new JMenu("Rotate dynamic");
        miRotate.setIcon(JaveIcons.ROTATE_DYNAMIC_ICON);
        miRotate.add(new Rotate180Action(mainPanel));
        miRotate.add(new Rotate90RightAction(mainPanel));
        miRotate.add(new Rotate90LeftAction(mainPanel));
        JMenuItem miFlipStatic = this.createMenuItem(mainPanel, FlipStatic.getInstance(), displayFontModel);
        miFlipStatic.setIcon(JaveIcons.FLIP_STATIC_ICON);
        JMenuItem miMirrorStatic = this.createMenuItem(mainPanel, MirrorStatic.getInstance(), displayFontModel);
        miMirrorStatic.setIcon(JaveIcons.MIRROR_STATIC_ICON);
        JMenu miRotateStatic = new JMenu("Rotate static");
        miRotateStatic.setIcon(JaveIcons.ROTATE_STATIC_ICON);
        miRotateStatic.add(new Rotate180StaticAction(mainPanel));
        miRotateStatic.add(new Rotate90RightStaticAction(mainPanel));
        miRotateStatic.add(new Rotate90LeftStaticAction(mainPanel));
        JMenuItem miShake = this.createMenuItem(mainPanel, new ShakeLines(), displayFontModel);
        this.miRepairIllegalReplace = this.createMenuItem("Replace illegal characters");
        this.miRepairIllegalRemove = this.createMenuItem("Remove illegal characters");
        JMenuItem miRepairWrapped = new JMenuItem(new RepairWrapped(mainPanel));
        JMenuItem miInvert = this.createMenuItem(mainPanel, new Invert(), displayFontModel);
        JMenuItem miBrightness = this.createMenuItem(mainPanel, Brightness.getInstance(), displayFontModel);
        JMenuItem miCompress = this.createMenuItem(mainPanel, CompressExpand.getInstance(), displayFontModel);
        JMenu menuRepair = new JMenu("Try to Repair");
        menuRepair.add(this.miRepairIllegalReplace);
        menuRepair.add(this.miRepairIllegalRemove);
        menuRepair.addSeparator();
        menuRepair.add(miRepairWrapped);
        menuRepair.add(new JMenuItem(new RepairShakedLinesAction(mainPanel)));
        JMenu menuTransform = new JMenu("Transform");
        menuTransform.add(miFlip);
        menuTransform.add(miMirrorDynamic);
        menuTransform.add(miRotate);
        menuTransform.addSeparator();
        menuTransform.add(miFlipStatic);
        menuTransform.add(miMirrorStatic);
        menuTransform.add(miRotateStatic);
        this.menuModify = new SmartMenu("&Modify");
        this.menuModify.add(miRot13);
        this.menuModify.add(miToLowerCase);
        this.menuModify.add(miToUpperCase);
        this.menuModify.add(miAsciify);
        this.menuModify.add(miUnasciify);
        this.menuModify.addSeparator();
        this.menuModify.add(miCenter);
        this.menuModify.add(miCenterByTheLine);
        this.menuModify.add(miAlignRight);
        this.menuModify.add(miAlignLeft);
        this.menuModify.addSeparator();
        this.menuModify.add(menuTransform);
        this.menuModify.add(miInvert);
        this.menuModify.add(miBrightness);
        this.menuModify.addSeparator();
        this.menuModify.add(miShake);
        this.menuModify.add(menuRepair);
        this.menuModify.add(miAntiAlias);
        this.menuModify.addSeparator();
        this.menuModify.add(miCompress);
        String[] s = CharacterSets.getCharsetNames();
        if (s != null && s.length > 1) {
            int defaultCharsetIndex = CharacterSets.getDefaultCharsetIndex();
            this.menuCharacterSets = new JMenu("Character Set");
            this.miCharacters = new JCheckBoxMenuItem[s.length];
            bg = new ButtonGroup();
            for (i = 0; i < s.length; ++i) {
                final int index = i;
                this.miCharacters[i] = new JCheckBoxMenuItem(s[i], i == defaultCharsetIndex);
                this.miCharacters[i].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JaveMenuBar.this.setCurrentCharsetIndex(index, jave);
                        CharacterSets.setCurrentCharsetIndex(index);
                        jave.getMainPanel().repaint();
                    }
                });
                bg.add(this.miCharacters[i]);
                this.menuCharacterSets.add(this.miCharacters[i]);
                if (i != 0 && i != s.length - 2) continue;
                this.menuCharacterSets.addSeparator();
            }
        }
        this.menuView = new SmartMenu("&View");
        this.miZoomPlus = this.createMenuItem("Zoom in");
        this.miZoomMinus = this.createMenuItem("Zoom out");
        this.menuColor = new JMenu("Color");
        ColorScheme[] colorSchemes = ColorScheme.getAll();
        this.miColorSchemes = new JCheckBoxMenuItem[colorSchemes.length];
        bg = new ButtonGroup();
        for (i = 0; i < colorSchemes.length; ++i) {
            final ColorScheme scheme = colorSchemes[i];
            this.miColorSchemes[i] = new JCheckBoxMenuItem(colorSchemes[i].getName(), colorSchemes[i].getIcon());
            this.miColorSchemes[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    jave.performSetColorScheme(scheme);
                }
            });
            bg.add(this.miColorSchemes[i]);
            this.menuColor.add(this.miColorSchemes[i]);
        }
        this.menuView.add(this.miZoomPlus);
        this.menuView.add(this.miZoomMinus);
        this.menuView.addSeparator();
        this.menuView.add(ActionWidgetFactory.createToggleMenuItem(actions.getToolOptionsDialogToggleAction()));
        this.menuView.add(ActionWidgetFactory.createToggleMenuItem(actions.getRulerToggleAction()));
        this.menuView.add(ActionWidgetFactory.createToggleMenuItem(actions.getGridToggleAction()));
        this.menuView.add(ActionWidgetFactory.createToggleMenuItem(actions.getMarkIllegalToggleAction()));
        this.menuView.add(ActionWidgetFactory.createToggleMenuItem(actions.getConnectedLinesViewToggleAction()));
        if (this.menuCharacterSets != null) {
            this.menuView.add(this.menuCharacterSets);
        }
        this.menuView.addSeparator();
        this.menuView.add(this.menuColor);
        this.menuView.add(new ChooseDisplayFontAction(preferences.getDisplayFontModel()));
        this.menuView.add(new JavePreferencesAction(preferences, platePreferences));
        this.menuWindows = new SmartMenu("&Window");
        this.menuSelection = new SmartMenu("&Selection");
        this.menuSelection.setEnabled(false);
        this.miSelectionToBrush = this.createMenuItem("Use as Brush");
        this.miSelectionExpand = this.createMenuItem("Expand");
        this.miSelectionShrink = this.createMenuItem("Shrink to fit");
        this.miSelectionBrace = this.createMenuItem("Add brace");
        this.miSelectionDelete = this.createMenuItem("Delete");
        this.menuSelection.add(this.miSelectionToBrush);
        this.menuSelection.add(new SelectionToClipartAction(mainPanel, preferences));
        this.menuSelection.addSeparator();
        this.menuSelection.add(this.miSelectionExpand);
        this.menuSelection.add(this.miSelectionShrink);
        this.menuSelection.addSeparator();
        this.menuSelection.add(this.miSelectionBrace);
        this.menuSelection.addSeparator();
        this.menuSelection.add(this.miSelectionDelete);
        SmartMenu menuTools = new SmartMenu("&Tools");
        menuTools.add(actions.getCamelizerAction());
        menuTools.addSeparator();
        menuTools.add(actions.getImage2AsciiAction());
        menuTools.add(actions.getFigletAction());
        menuTools.add(actions.getClipartLibraryAction());
        menuTools.add(actions.getTextBoxAction());
        menuTools.add(actions.getMathematicalExpressionsAction());
        menuTools.addSeparator();
        menuTools.add(new FigletExportWizardAction(mainPanel, preferences));
        this.miRender3D = this.createMenuItem("Render 3D");
        this.miFunctionPlotter = this.createMenuItem("Function Plotter");
        this.miLife = this.createMenuItem("Game of Life Screensaver");
        this.miDoc2Watermark = this.createMenuItem("Set Content as Watermark");
        SmartMenu menuSpecial = new SmartMenu("S&pecial");
        menuSpecial.add(actions.getFractalAction());
        menuSpecial.add(this.miRender3D);
        menuSpecial.add(this.miFunctionPlotter);
        menuSpecial.addSeparator();
        menuSpecial.add(new AsctrisAction(jave));
        menuSpecial.add(new LabyrinthAction(jave));
        menuSpecial.addSeparator();
        menuSpecial.add(this.miLife);
        menuSpecial.addSeparator();
        menuSpecial.add(this.miDoc2Watermark);
        menuSpecial.addSeparator();
        menuSpecial.add(new DecodeSteganogramAction(mainPanel));
        this.miCrash = this.createMenuItem("Crash now");
        JMenu menuDebug = new JMenu("Debug");
        menuDebug.add(new SmartAction("Init configuration"){

            @Override
            protected void execute(Component parentComponent) {
                try {
                    JaveStartupRunnable.initConfigFiles(parentComponent);
                }
                catch (StartupException e) {
                    MessageDialogFactory.showMessageDialog(parentComponent, new Message("Error loading configuration files.", e));
                }
            }
        });
        menuDebug.addSeparator();
        menuDebug.add(this.miCrash);
        SmartMenu menuHelp = new SmartMenu("&Help");
        menuHelp.add(new OpenOnlineLocationAction("Online Documentation", "http://www.jave.de/docs/index.html"));
        menuHelp.addSeparator();
        menuHelp.add(menuDebug);
        menuHelp.addSeparator();
        menuHelp.add(new VersionCheckAction());
        menuHelp.add(actions.getAboutAction());
        this.add(fileMenu);
        this.add(animationMenu);
        this.add(menuEdit);
        this.add(this.menuModify);
        this.add(this.menuView);
        this.add(this.menuSelection);
        this.add(menuTools);
        this.add(menuSpecial);
        this.add(this.menuWindows);
        this.setHelpMenu(menuHelp);
        this.docOpenEnabledMenuItems.add(this.miClear);
        this.docOpenEnabledMenuItems.add(this.miSelectAll);
        this.docOpenEnabledMenuItems.add(this.miClose);
        this.docOpenEnabledMenuItems.add(this.miCloseAll);
        this.docOpenEnabledMenuItems.add(this.miReplace);
        this.docOpenEnabledMenuItems.add(this.miDoc2Watermark);
        this.docOpenEnabledMenuItems.add(miInvert);
        this.docOpenEnabledMenuItems.add(miCompress);
        this.docOpenEnabledMenuItems.add(miBrightness);
        this.updateColorMenu(currentColorSchemeModel.getColorScheme(), mainPanel.getActiveEditorModel().getActiveEditor());
        mainPanel.getActiveEditorModel().addChangeListener(new IChangeListener(){

            @Override
            public void stateChanged() {
                JaveMenuBar.this.updateWindowsMenu();
            }
        });
        this.updateWindowsMenu();
    }

    private final JMenuItem createMenuItem(String label) {
        JMenuItem mi = new JMenuItem(label);
        mi.addActionListener(this);
        return mi;
    }

    private final JMenuItem createMenuItem(JaveMainPanel mainPanel, JaveAlgorithm algorithm, FontModel displayFontModel) {
        return new JMenuItem(new JaveAlgorithmAction(mainPanel, displayFontModel, algorithm));
    }

    private void updateColorMenu(ColorScheme colorScheme, IDocumentEditor editor) {
        boolean enabled = colorScheme != null && editor.getType() == JaveDocumentType.TEXT;
        for (JCheckBoxMenuItem item : this.miColorSchemes) {
            item.setEnabled(enabled);
        }
        if (colorScheme == null) {
            return;
        }
        ColorScheme[] schemes = ColorScheme.getAll();
        for (int i = 0; i < this.miColorSchemes.length; ++i) {
            if (schemes[i] != colorScheme) continue;
            this.miColorSchemes[i].setSelected(true);
        }
    }

    public void setRevertEnabled(boolean what) {
        this.miRevert.setEnabled(what);
    }

    public void updateUndoRedoMenu(boolean canUndo, String undoAction, boolean canRedo, String redoAction) {
        this.miUndo.setEnabled(canUndo);
        this.miRedo.setEnabled(canRedo);
        if (canUndo) {
            this.miUndo.setText("Undo " + undoAction);
        } else {
            this.miUndo.setText("Undo");
        }
        if (canRedo) {
            this.miRedo.setText("Redo " + redoAction);
        } else {
            this.miRedo.setText("Redo");
        }
    }

    public void updateSelectionMenu(boolean hasSelection) {
        if (this.menuSelection.isEnabled() != hasSelection) {
            this.menuSelection.setEnabled(hasSelection);
        }
    }

    private void updateWindowsMenu() {
        this.menuWindows.removeAll();
        this.miPreviousWindow = new JMenuItem("Previous");
        this.miPreviousWindow.addActionListener(this);
        this.menuWindows.add(this.miPreviousWindow);
        this.miNextWindow = new JMenuItem("Next");
        this.miNextWindow.addActionListener(this);
        this.menuWindows.add(this.miNextWindow);
        this.menuWindows.addSeparator();
        int editorCount = this.jave.getMainPanel().getEditorCount();
        boolean docOpen = editorCount > 0;
        this.menuView.setEnabled(docOpen);
        this.menuColor.setEnabled(docOpen);
        this.menuModify.setEnabled(docOpen);
        if (this.docOpenEnabledMenuItems != null) {
            for (int i = 0; i < this.docOpenEnabledMenuItems.size(); ++i) {
                this.docOpenEnabledMenuItems.get(i).setEnabled(docOpen);
            }
        }
        this.miPreviousWindow.setEnabled(editorCount > 1);
        this.miNextWindow.setEnabled(editorCount > 1);
        if (!docOpen) {
            this.miRevert.setEnabled(false);
            return;
        }
        this.miRevert.setEnabled(this.jave.getMainPanel().getEditor().getFile() != null);
        String[] menuTitles = this.getMenuTitles();
        this.windowMenuItems = new JCheckBoxMenuItem[menuTitles.length];
        ButtonGroup bg = new ButtonGroup();
        for (int i = 0; i < menuTitles.length; ++i) {
            final int index = i;
            this.windowMenuItems[i] = new JCheckBoxMenuItem(menuTitles[i]);
            this.windowMenuItems[i].setSelected(this.jave.getMainPanel().getActiveEditorModel().getActiveEditor() == this.jave.getMainPanel().getEditor(i));
            this.windowMenuItems[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JaveMenuBar.this.jave.setCurrentDocument(index);
                }
            });
            bg.add(this.windowMenuItems[i]);
            if (i <= 9) {
                this.windowMenuItems[i].setMnemonic(windowShortcuts[i]);
            }
            this.menuWindows.add(this.windowMenuItems[i]);
        }
    }

    private String[] getMenuTitles() {
        JaveMainPanel mainPanel = this.jave.getMainPanel();
        String[] result = new String[mainPanel.getEditorCount()];
        for (int i = 0; i < mainPanel.getEditorCount(); ++i) {
            result[i] = i + 1 + " " + DocumentEditorTitleFactory.createShortEditorTitle(mainPanel.getEditor(i));
        }
        return result;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Window parentComponent = GuiUtilities.getWindowForComponent(evt);
        this.jave.getMainPanel().requestFocus();
        Object source = evt.getSource();
        if (source == this.miCrash) {
            this.jave.doDebugCrash();
            return;
        }
        if (source == this.miSelectionToBrush) {
            this.jave.doSelectionToBrush();
            return;
        }
        if (source == this.miSelectionShrink) {
            this.jave.doSelectionShrink();
            return;
        }
        if (source == this.miSelectionExpand) {
            this.jave.doSelectionExpand();
            return;
        }
        if (source == this.miSelectionDelete) {
            this.jave.doSelectionDelete();
            return;
        }
        if (source == this.miSelectionBrace) {
            this.jave.doSelectionBraces();
            return;
        }
        if (source == this.miReplace) {
            this.jave.doReplaceCharacter();
            return;
        }
        if (source == this.miRepairIllegalRemove) {
            this.jave.doRepairIllegalRemove();
            return;
        }
        if (source == this.miRepairIllegalReplace) {
            this.jave.doRepairIllegalReplace();
            return;
        }
        if (source == this.miLife) {
            ColorScreenSaver s = new ColorScreenSaver(this.jave.getFrame());
            return;
        }
        if (source == this.miDoc2Watermark) {
            this.jave.doDoc2Watermark();
            return;
        }
        if (source == this.miRender3D) {
            this.jave.doRender3D();
            return;
        }
        if (source == this.miFunctionPlotter) {
            this.jave.doFunctionPlotter();
            return;
        }
        if (source == this.miUndo) {
            this.jave.doUndo();
            return;
        }
        if (source == this.miRedo) {
            this.jave.doRedo();
            return;
        }
        if (source == this.miRevert) {
            this.jave.doRevert(parentComponent);
            return;
        }
        if (source == this.miZoomPlus) {
            this.jave.doZoomPlus();
            return;
        }
        if (source == this.miZoomMinus) {
            this.jave.doZoomMinus();
            return;
        }
        if (source == this.miSelectAll) {
            this.jave.selectAll();
            return;
        }
        if (source == this.miNextWindow) {
            this.jave.doNextDocument();
            return;
        }
        if (source == this.miPreviousWindow) {
            this.jave.doPreviousDocument();
            return;
        }
        if (source == this.miClose) {
            this.jave.doClose(parentComponent);
            return;
        }
        if (source == this.miCloseAll) {
            this.jave.doCloseAll(parentComponent);
            return;
        }
        System.err.println("JaveMenuBar: source unknown in actionPerformed!" + source);
    }

    private void setCurrentCharsetIndex(int index, JavEApplication jave) {
        CharSetsConfiguration configuration = CharSetsConfiguration.getInstance();
        if (index == configuration.getUserDefinedIndex()) {
            FontModel fontModel = new FontModel(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
            AsciiTextAreaProperties textAreaProperties = new AsciiTextAreaProperties(fontModel);
            String text = configuration.getCharSetChatacters(index);
            AsciiTextArea taSet = new AsciiTextArea(new Dimension(60, 5), textAreaProperties);
            taSet.setText(text);
            final JPanel panel = new JPanel(new GridDialogLayout(1, false));
            panel.add(new JLabel("Legal Characters:"));
            panel.add(taSet.getContent());
            panel.add(new JLabel("(The Character [space] is always included)"));
            AbstractDialogPage page = new AbstractDialogPage(""){

                @Override
                public IBasicMessage createCurrentMessage() {
                    return this.getDefaultMessage();
                }

                @Override
                public JComponent createContent() {
                    return panel;
                }

                @Override
                public String getTitle() {
                    return "User Defined Character Set";
                }
            };
            UserDialog userDialog = new UserDialog((Component)jave.getFrame(), new DefaultDialogConfiguration<IDialogPage>((IDialogPage)page, DialogButtonConfigurationFactory.createOkOnly()){

                @Override
                public boolean isHeaderPanelVisible() {
                    return false;
                }
            });
            userDialog.show();
            if (!userDialog.isCanceled()) {
                configuration.setCharsetCharacters(index, " " + taSet.getText());
            }
        }
    }
}

