/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.actions;

import de.jave.jave.JavEApplication;
import de.jave.jave.actions.ButtonToolbarBuilder;
import de.jave.jave.actions.JaveActions;
import de.jave.jave.icon.JaveIcons;
import java.awt.Component;
import javax.swing.JComponent;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.action.SmartAction;

public class JaveTopToolbar {
    private final JComponent content;
    private final SmartAction undoAction;
    private final SmartAction redoAction;

    public JaveTopToolbar(final JavEApplication jave, JaveActions actions) {
        Ensure.ensureArgumentNotNull(jave);
        this.undoAction = new SmartAction(JaveIcons.UNDO_ICON){

            @Override
            protected void execute(Component parentComponent) {
                jave.doUndo();
            }
        };
        this.undoAction.setToolTipText("Undo");
        this.redoAction = new SmartAction(JaveIcons.REDO_ICON){

            @Override
            protected void execute(Component parentComponent) {
                jave.doRedo();
            }
        };
        this.redoAction.setToolTipText("Redo");
        SmartAction zoomPlusAction = new SmartAction(JaveIcons.ZOOM_PLUS_ICON){

            @Override
            protected void execute(Component parentComponent) {
                jave.doZoomPlus();
            }
        };
        zoomPlusAction.setToolTipText("Zoom in");
        SmartAction zoomMinusAction = new SmartAction(JaveIcons.ZOOM_MINUS_ICON){

            @Override
            protected void execute(Component parentComponent) {
                jave.doZoomMinus();
            }
        };
        zoomMinusAction.setToolTipText("Zoom out");
        ButtonToolbarBuilder builder = new ButtonToolbarBuilder();
        builder.add(actions.getQuickStartAction());
        builder.add(actions.getNewDocumentAction());
        builder.add(actions.getNewAnimationAction());
        builder.addSeparator();
        builder.add(actions.getBrowseAction());
        builder.add(actions.getOpenAction());
        builder.add(actions.getSaveAction());
        builder.addSeparator();
        builder.add(actions.getExportAction());
        builder.addSeparator();
        builder.add(actions.getCutAction());
        builder.add(actions.getCopyAction());
        builder.add(actions.getPasteAsNewSelectionAction());
        builder.addSeparator();
        builder.add(this.undoAction);
        builder.add(this.redoAction);
        builder.addSeparator();
        builder.add(actions.getResizeAction());
        builder.addSeparator();
        builder.add(actions.getFigletAction());
        builder.add(actions.getImage2AsciiAction());
        builder.add(actions.getCamelizerAction());
        builder.add(actions.getClipartLibraryAction());
        builder.add(actions.getTextBoxAction());
        builder.add(actions.getMathematicalExpressionsAction());
        builder.addSeparator();
        builder.add(zoomMinusAction);
        builder.add(zoomPlusAction);
        builder.addSeparator();
        builder.add(actions.getAboutAction());
        this.content = builder.createPanel();
    }

    public JComponent getContent() {
        return this.content;
    }

    public void updateUndoRedo(boolean canUndo, boolean canRedo) {
        this.undoAction.setEnabled(canUndo);
        this.redoAction.setEnabled(canRedo);
    }
}

