/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.actions.export;

import de.jave.gui.io.ExtensionFileFilter;
import de.jave.gui.io.SmartFileFilter;
import de.jave.lib.CharacterPlate;
import de.jave.lib.net.HtmlUtilities;
import java.util.StringTokenizer;
import net.disy.commons.core.util.Ensure;

public class ResultConverter {
    private final ExtensionFileFilter fileFilter;
    private final String name;
    private final String blockStart;
    private final String lineStart;
    private final String blockEnd;
    private final boolean html;

    public ResultConverter(String name, ExtensionFileFilter fileFilter, String blockStart, String lineStart, String blockEnd, boolean html) {
        Ensure.ensureArgumentNotNull(name);
        Ensure.ensureArgumentNotNull(fileFilter);
        this.name = name;
        this.fileFilter = fileFilter;
        this.lineStart = lineStart;
        this.blockStart = blockStart;
        this.blockEnd = blockEnd;
        this.html = html;
    }

    public String getName() {
        return this.name;
    }

    public String convert(CharacterPlate plate) {
        StringBuilder result = new StringBuilder();
        result.append(this.blockStart);
        String text = plate.toString();
        StringTokenizer st = new StringTokenizer(text, "\n\r", true);
        boolean flag = true;
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (flag) {
                result.append(this.lineStart);
            }
            flag = !flag || t.equals("\n") || t.equals("\r");
            if (this.html) {
                t = HtmlUtilities.encode(t);
            }
            result.append(t);
        }
        result.append(this.blockEnd);
        return result.toString();
    }

    public SmartFileFilter getFileFilter() {
        return this.fileFilter;
    }
}

