/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.algorithm;

import de.jave.jave.algorithm.JaveAlgorithm;
import de.jave.lib.CharacterPlate;

public class AlignLeft
extends JaveAlgorithm {
    private static AlignLeft instance;

    private AlignLeft() {
    }

    public static synchronized AlignLeft getInstance() {
        if (instance == null) {
            instance = new AlignLeft();
        }
        return instance;
    }

    @Override
    public String getUndoRedoName() {
        return "align left";
    }

    @Override
    public String getMenuItemLabel() {
        return "Align left";
    }

    @Override
    public CharacterPlate apply(CharacterPlate plate) {
        int width = plate.getWidth();
        int height = plate.getHeight();
        for (int y = 0; y < height; ++y) {
            int left;
            char[] line = plate.getLine(y).toCharArray();
            for (left = 0; left < width && line[left] == ' '; ++left) {
            }
            if (left >= width || left <= 0) continue;
            for (int x = 0; x < width; ++x) {
                if (x >= width - left - 1) {
                    plate.setForce(x, y, ' ');
                    continue;
                }
                plate.setForce(x, y, line[x + left]);
            }
        }
        return plate;
    }
}

