/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.algorithm;

import de.jave.jave.JaveSelection;
import de.jave.jave.algorithm.JaveAlgorithm;
import de.jave.lib.area.BooleanArea;

public class FlipStatic
extends JaveAlgorithm {
    private static FlipStatic instance;

    private FlipStatic() {
    }

    public static synchronized FlipStatic getInstance() {
        if (instance == null) {
            instance = new FlipStatic();
        }
        return instance;
    }

    @Override
    public String getUndoRedoName() {
        return "flip static";
    }

    @Override
    public String getMenuItemLabel() {
        return "Flip static";
    }

    @Override
    public JaveSelection apply(JaveSelection plate) {
        Object[] t;
        int y;
        int h = plate.getHeight();
        BooleanArea mask = plate.getMask();
        if (mask != null) {
            boolean[][] m = mask.getContent();
            for (y = 0; y < h / 2; ++y) {
                t = m[y];
                m[y] = m[h - y - 1];
                m[h - y - 1] = t;
            }
        }
        char[][] ch = plate.getContent().getContent();
        for (y = 0; y < h / 2; ++y) {
            t = ch[y];
            ch[y] = ch[h - y - 1];
            ch[h - y - 1] = (char[])t;
        }
        return plate;
    }
}

