/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.algorithm;

import de.jave.image.Rotation;
import de.jave.image2ascii.RotationUi;
import de.jave.jave.JaveSelection;
import de.jave.jave.actions.AbstractJaveUndoableAction;
import de.jave.jave.actions.enablestrategy.IJaveDocumentEditorActionEnabledStrategy;
import de.jave.jave.actions.enablestrategy.TextAndAnimationEditorEnabledStrategy;
import de.jave.jave.algorithm.GeneralAlgorithm;
import de.jave.jave.algorithm.Rotate180StaticAction;
import de.jave.jave.plate.JaveMainPanel;
import java.awt.Component;
import java.awt.Dimension;

public class Rotate180Action
extends AbstractJaveUndoableAction {
    public Rotate180Action(JaveMainPanel mainPanel) {
        super(mainPanel, "180 degrees", new RotationUi().getIcon(Rotation.UPSIDE_DOWN));
    }

    @Override
    public String getActionName() {
        return "rotate 180";
    }

    @Override
    protected JaveSelection apply(Component parentComponent, JaveSelection selection) {
        selection = Rotate180StaticAction.applyTo(selection);
        char[][] ch = selection.getContent().getContent();
        Dimension size = selection.getSize();
        for (int y = 0; y < size.height; ++y) {
            for (int x = 0; x < size.width; ++x) {
                if (ch[y][x] < ' ' || ch[y][x] > '~') continue;
                ch[y][x] = GeneralAlgorithm.getRotate180().charAt(ch[y][x] - 32);
            }
        }
        return selection;
    }

    @Override
    protected IJaveDocumentEditorActionEnabledStrategy getEnabledStrategy() {
        return TextAndAnimationEditorEnabledStrategy.getInstance();
    }
}

