/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.clipart;

import de.jave.jave.clipart.ClipartGroup;
import de.jave.jave.clipart.ClipartGroupItem;
import de.jave.jave.clipart.ClipartManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import net.disy.commons.core.util.Ensure;

public class ClipartGroupListModel
extends AbstractListModel {
    private final ClipartManager clipartManager;
    private final List<ClipartGroup> temporaryGroups = new ArrayList<ClipartGroup>();

    public ClipartGroupListModel(ClipartManager clipartManager) {
        Ensure.ensureArgumentNotNull(clipartManager);
        this.clipartManager = clipartManager;
    }

    @Override
    public ClipartGroupItem getElementAt(int index) {
        if (index < this.clipartManager.getGroupCount()) {
            return new ClipartGroupItem(this.clipartManager.getGroup(index), true);
        }
        return new ClipartGroupItem(this.temporaryGroups.get(index - this.clipartManager.getGroupCount()), false);
    }

    @Override
    public int getSize() {
        return this.clipartManager.getGroupCount() + this.temporaryGroups.size();
    }

    public void add(ClipartGroup newGroup) {
        this.temporaryGroups.add(newGroup);
        this.fireIntervalAdded(newGroup, this.getSize() - 1, this.getSize() - 1);
    }

    public int getItemIndex(ClipartGroup value) {
        for (int index = 0; index < this.clipartManager.getGroupCount(); ++index) {
            ClipartGroup group = this.clipartManager.getGroup(index);
            if (!group.equals(value)) continue;
            return index;
        }
        for (int i = 0; i < this.temporaryGroups.size(); ++i) {
            if (!this.temporaryGroups.get(i).equals(value)) continue;
            return this.clipartManager.getGroupCount() + i;
        }
        return -1;
    }
}

