/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.figlet.export;

import de.jave.figlet.file.BaseFolderFigFileResource;
import de.jave.figlet.file.IFigFileResource;
import de.jave.figlet.util.FigException;
import de.jave.jave.Plate;
import de.jave.jave.figlet.FigletConfiguration;
import de.jave.jave.figlet.export.FigletExportModel;
import de.jave.jave.figlet.export.FigletExportWatermarkPainter;
import de.jave.jave.figlet.export.FigletExportWizardPageManager;
import de.jave.jave.figlet.export.FigletFileExporter;
import de.jave.jave.plate.IDocumentEditor;
import de.jave.jave.plate.selection.SelectionAlgorithms;
import de.jave.jave.preferences.JaveApplicationPreferences;
import de.jave.jave.watermark.IWatermarkPainter;
import java.awt.Component;
import java.awt.Rectangle;
import java.io.File;
import java.text.MessageFormat;
import net.disy.commons.core.message.Message;
import net.disy.commons.core.message.MessageType;
import net.disy.commons.core.model.BooleanModel;
import net.disy.commons.core.model.listener.IChangeListener;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.dialog.message.MessageDialogFactory;
import net.disy.commons.swing.dialog.message.MessageDialogUtilities;
import net.disy.commons.swing.dialog.message.YesNoCancel;
import net.disy.commons.swing.dialog.wizard.AbstractWizardConfiguration;
import net.disy.commons.swing.dialog.wizard.IWizardPage;

public class FigletExportWizard
extends AbstractWizardConfiguration {
    private static final String SUCCEED_MESSAGE = "Your new FIGlet font has been saved into JavE''s font folder as:\n      {0}\nThe font is now available in the category 'New Fonts'.\n\nPlease consider making your font public by informing the\npeople on the newsgroup alt.ascii-art or JavE's program author\n     markus@jave.de.\n\nDon't forget to backup a copy of this font so you will not\naccidently lose it!";
    private FigletExportWizardPageManager pageManager;
    private final FigletExportModel model;
    private final BooleanModel gridVisibilityModel;
    private final boolean rememberGrid;
    private final Plate plate;
    private final IWatermarkPainter painter;

    public FigletExportWizard(IDocumentEditor editor, JaveApplicationPreferences preferences) {
        Ensure.ensureArgumentNotNull(editor);
        this.plate = editor.getPlate();
        if (this.plate.hasSelection()) {
            Rectangle r = this.plate.getSelectionRegion();
            SelectionAlgorithms.dropSelection(editor);
            this.model = new FigletExportModel(this.plate, preferences);
            this.model.setCharacterWidth(r.width);
            this.model.setCharacterHeight(r.height);
            this.model.setCharacterDescent(1);
        } else {
            this.model = new FigletExportModel(this.plate, preferences);
        }
        this.painter = new FigletExportWatermarkPainter(this.model);
        this.gridVisibilityModel = this.plate.getPlatePreferences().getGridVisibilityModel();
        this.rememberGrid = this.gridVisibilityModel.getValue();
        this.gridVisibilityModel.setValue(false);
        this.plate.addWatermarkPainter(this.painter);
        this.model.addChangeListener(new IChangeListener(){

            @Override
            public void stateChanged() {
                FigletExportWizard.this.plate.repaint();
            }
        });
    }

    @Override
    public void addPages() {
        this.pageManager = new FigletExportWizardPageManager(this, this.model);
    }

    @Override
    public IWizardPage getStartingPage() {
        return this.pageManager.getStartingPage();
    }

    @Override
    public IWizardPage getNextPage(IWizardPage page) {
        return this.pageManager.getNextPage(page);
    }

    @Override
    public IWizardPage getPreviousPage(IWizardPage page) {
        return this.pageManager.getPreviousPage(page);
    }

    @Override
    public boolean performFinish(Component parentComponent) {
        YesNoCancel answer;
        this.resetPlateView();
        IFigFileResource fileResource = FigletConfiguration.getInstance().getFigDriver().getFileLibrary().getFileResource();
        BaseFolderFigFileResource folderResource = (BaseFolderFigFileResource)fileResource;
        File folder = folderResource.getBaseFolder();
        File file = new File(folder, this.model.getName() + ".flf");
        if (file.exists() && (answer = MessageDialogUtilities.showYesNoCancelDialog(parentComponent, new Message("JavE", "The font '" + this.model.getName() + "' already exists.\nDo you want to replace the existing file?", MessageType.WARNING))) != YesNoCancel.YES) {
            return false;
        }
        FigletFileExporter.export(this.model, file);
        try {
            FigletConfiguration.getInstance().getFigDriver().getFileLibrary().initialize();
        }
        catch (FigException e) {
            e.printStackTrace();
        }
        String filePath = file.getAbsoluteFile().getAbsolutePath();
        String message = MessageFormat.format(SUCCEED_MESSAGE, filePath);
        MessageDialogFactory.showMessageDialog(parentComponent, new Message("JavE FIGlet font export assistant", message, MessageType.INFORMATION));
        return true;
    }

    private void resetPlateView() {
        this.gridVisibilityModel.setValue(this.rememberGrid);
        this.plate.removeWatermarkPainter(this.painter);
        this.plate.repaint();
    }

    @Override
    public boolean isHelpAvailable() {
        return false;
    }

    @Override
    public boolean performCancel(Component parentComponent) {
        this.resetPlateView();
        return true;
    }
}

