/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.plate;

import de.jave.asciimation.editor.AnimationEditorModel;
import de.jave.asciimation.editor.AnimationEditorPanel;
import de.jave.jave.DocumentListener;
import de.jave.jave.JavEApplication;
import de.jave.jave.Plate;
import de.jave.jave.PlateDocument;
import de.jave.jave.browser.JaveDocumentType;
import de.jave.jave.plate.AbstractDocumentEditor;
import de.jave.jave.plate.ToolManager;
import de.jave.jave.preferences.AnimationExportPreferences;
import de.jave.jave.preferences.ColorScheme;
import de.jave.jave.preferences.JaveApplicationPreferences;
import de.jave.jave.preferences.PlatePreferences;
import de.jave.javeplayer.JaveAnimationFile;
import de.jave.lib.CharacterPlate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.disy.commons.core.io.FileModel;
import net.disy.commons.core.model.ObjectModel;
import net.disy.commons.core.model.listener.IChangeListener;
import net.disy.commons.core.util.Ensure;

public class AnimationDocumentEditor
extends AbstractDocumentEditor {
    private final Plate plate;
    private final JComponent content;
    private final AnimationEditorPanel animationEditorPanel;
    private final String stopGapName;

    public AnimationDocumentEditor(String stopGapName, JaveAnimationFile animationFile, JavEApplication jave, final PlateDocument document, PlatePreferences platePreferences, JaveApplicationPreferences preferences, ToolManager toolManager, AnimationExportPreferences animationExportPreferences, FileModel currentDirectoryModel) {
        Ensure.ensureArgumentNotNull(stopGapName);
        Ensure.ensureArgumentNotNull(animationFile);
        Ensure.ensureArgumentNotNull(jave);
        Ensure.ensureArgumentNotNull(platePreferences);
        Ensure.ensureArgumentNotNull(toolManager);
        Ensure.ensureArgumentNotNull(currentDirectoryModel);
        this.stopGapName = stopGapName;
        document.setFile(animationFile.getFile());
        if (animationFile.getFrameCount() > 0) {
            document.setContent(new CharacterPlate(animationFile.getFrame(0).getContent()));
        }
        document.setColorScheme(ColorScheme.BLACK_ON_WHITE);
        this.plate = new Plate(document, jave, platePreferences, toolManager, preferences.getDisplayFontModel(), new ObjectModel<ColorScheme>(preferences.getDefaultColorSchemeModel().getValue()));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.plate.getComponent(), "Center");
        AnimationEditorModel model = new AnimationEditorModel();
        model.setAnimationFile(animationFile);
        this.animationEditorPanel = new AnimationEditorPanel(model, currentDirectoryModel, this.plate, preferences, animationExportPreferences);
        panel.add((Component)this.animationEditorPanel.getContent(), "South");
        this.content = panel;
        this.animationEditorPanel.getCurrentFrameIndexModel().addChangeListener(new IChangeListener(){

            @Override
            public void stateChanged() {
                AnimationDocumentEditor.this.updatePlateContent();
            }
        });
        this.animationEditorPanel.getModel().addChangeListener(new IChangeListener(){

            @Override
            public void stateChanged() {
                AnimationDocumentEditor.this.updatePlateContent();
            }
        });
        document.addDocumentListener(new DocumentListener(){

            @Override
            public void documentChanged() {
                AnimationDocumentEditor.this.animationEditorPanel.getModel().setCurrentFrameContent(document.getContent());
            }

            @Override
            public void documentShowing() {
            }

            @Override
            public void documentHiding() {
            }

            @Override
            public void documentClosing() {
            }
        });
    }

    private void updatePlateContent() {
        JaveAnimationFile animationFile = this.animationEditorPanel.getModel().getAnimationFile();
        int currentFrameIndex = this.animationEditorPanel.getCurrentFrameIndexModel().getCurrentFrameIndex();
        this.plate.setContent(new CharacterPlate(animationFile.getFrame(currentFrameIndex).getContent()));
    }

    @Deprecated
    public AnimationEditorPanel getAnimationEditorPanel() {
        return this.animationEditorPanel;
    }

    @Override
    public Plate getPlate() {
        return this.plate;
    }

    @Override
    public JComponent getContent() {
        return this.content;
    }

    @Override
    public JaveDocumentType getType() {
        return JaveDocumentType.ANIMATION;
    }

    public AnimationEditorModel getModel() {
        return this.animationEditorPanel.getModel();
    }

    @Override
    public boolean isModified() {
        return this.getModel().isModified();
    }

    @Override
    public File getFile() {
        return this.getModel().getAnimationFile().getFile();
    }

    @Override
    public String getStopGapName() {
        return this.stopGapName;
    }
}

