/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.rendering;

import de.jave.ascii.plate.CharacterMetrics;
import de.jave.jave.Plate;
import de.jave.jave.pixelplate.PixelPlate;
import de.jave.jave.preferences.ColorScheme;
import de.jave.lib.CharacterPlate;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;

public class PixelPlateRenderer {
    public static void paintBackground(Graphics g, ColorScheme colorScheme, Plate plate, PixelPlate pixelPlate, Point plateOrigin) {
        int charWidth = plate.getCharWidth();
        int charHeight = plate.getCharHeight();
        int x1 = pixelPlate.getOriginX() * charWidth + plateOrigin.x;
        int y1 = pixelPlate.getOriginY() * charHeight + plateOrigin.y;
        g.setColor(colorScheme.getColorSelectionBackground());
        g.fillRect(x1, y1, pixelPlate.getWidth() * charWidth, pixelPlate.getHeight() * charHeight);
        g.setColor(colorScheme.getColorSelectionText());
        g.drawRect(x1, y1, pixelPlate.getWidth() * charWidth, pixelPlate.getHeight() * charHeight);
    }

    public static void paint(Graphics g, Plate plate, ColorScheme colorScheme, PixelPlate pixelPlate, Point plateOrigin) {
        PixelPlateRenderer.paint(g, plate, colorScheme, false, pixelPlate, plateOrigin);
    }

    public static void paint(Graphics g, Plate plate, ColorScheme colorScheme, boolean debug, PixelPlate pixelPlate, Point plateOrigin) {
        CharacterMetrics characterMetrics = plate.getCharacterMetrics();
        int charWidth = characterMetrics.getWidth();
        int charHeight = characterMetrics.getHeight();
        int fontAscent = characterMetrics.getAscent();
        int x1 = pixelPlate.getOriginX() * charWidth + plateOrigin.x;
        int y1 = pixelPlate.getOriginY() * charHeight + plateOrigin.y;
        if (debug) {
            double dy = (double)charHeight / (double)pixelPlate.getRasterY();
            double dx = (double)charWidth / (double)pixelPlate.getRasterX();
            for (int y = 0; y < pixelPlate.getHeight(); ++y) {
                for (int x = 0; x < pixelPlate.getWidth(); ++x) {
                    if (pixelPlate.getPixels(x, y) == 0) continue;
                    for (int xx = 0; xx < pixelPlate.getRasterX(); ++xx) {
                        for (int yy = 0; yy < pixelPlate.getRasterY(); ++yy) {
                            if ((pixelPlate.getPixels(x, y) & 1 << yy + xx * pixelPlate.getRasterY()) > 0) {
                                g.setColor(Color.red);
                                g.drawRect(x1 + 3 + (int)((double)(x * charWidth) + (double)xx * dx), y1 + 3 + (int)((double)(y * charHeight) + (double)yy * dy), 1, 1);
                                continue;
                            }
                            g.setColor(Color.black);
                            g.drawLine(x1 + 3 + (int)((double)(x * charWidth) + (double)xx * dx), y1 + 3 + (int)((double)(y * charHeight) + (double)yy * dy), x1 + 3 + (int)((double)(x * charWidth) + (double)xx * dx), y1 + 3 + (int)((double)(y * charHeight) + (double)yy * dy));
                        }
                    }
                }
            }
            return;
        }
        g.setColor(colorScheme.getColorToolPreview());
        CharacterPlate result = pixelPlate.getResult();
        CharacterPlate displayResult = result.getClone();
        displayResult.replace('\u0000', ' ');
        displayResult.replace('\u00a0', ' ');
        plate.paintPreview(g, displayResult, colorScheme, 0, 0, pixelPlate.getOriginX(), pixelPlate.getOriginY());
        int plateWidth = plate.getDocumentWidth();
        int plateHeight = plate.getDocumentHeight();
        g.setColor(colorScheme.getColorToolPreviewDelete());
        for (int y = 0; y < pixelPlate.getHeight(); ++y) {
            for (int x = 0; x < pixelPlate.getWidth(); ++x) {
                char ch;
                if (result.get(x, y) != ' ' && result.get(x, y) != '\u00a0') continue;
                int xx = pixelPlate.getOriginX() + x;
                int yy = pixelPlate.getOriginY() + y;
                if (xx < 0 || yy < 0 || xx >= plateWidth || yy >= plateHeight || (ch = plate.getChar(xx, yy)) == ' ') continue;
                g.drawString(String.valueOf(ch), x1 + x * charWidth, y1 + fontAscent + y * charHeight);
            }
        }
    }
}

