/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.tool.fill;

import de.jave.ascii.plate.ITextContentListener;
import de.jave.ascii.plate.textareabased.AsciiTextArea;
import de.jave.ascii.plate.textareabased.AsciiTextAreaProperties;
import de.jave.jave.AsciiGradients;
import de.jave.jave.algorithm.fill.FillMatchMode;
import de.jave.jave.algorithm.fill.FillMode;
import de.jave.jave.algorithm.fill.GradientStyle;
import de.jave.jave.algorithm.fill.GradientStyleUi;
import de.jave.jave.pattern.Pattern;
import de.jave.jave.pattern.PatternDialog;
import de.jave.jave.plate.MouseCharacterModel;
import de.jave.jave.plate.MouseCharacterPanel;
import de.jave.jave.preferences.JaveApplicationPreferences;
import de.jave.jave.tool.fill.FillMatchModeUi;
import de.jave.jave.tool.fill.FillModeUi;
import de.jave.jave.tool.fill.FillOptions;
import de.jave.javeplayer.AsciiPacker;
import de.jave.lib.gui.GuiUtilities;
import de.jave.text.TextTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.disy.commons.core.message.IBasicMessage;
import net.disy.commons.core.message.Message;
import net.disy.commons.core.message.MessageType;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.dialog.message.MessageDialogFactory;
import net.disy.commons.swing.dialog.userdialog.DefaultDialogConfiguration;
import net.disy.commons.swing.dialog.userdialog.UserDialog;
import net.disy.commons.swing.dialog.userdialog.page.AbstractDialogPage;
import net.disy.commons.swing.dialog.userdialog.page.IDialogPage;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;
import net.disy.commons.swing.layout.util.ButtonPanelBuilder;
import net.disy.commons.swing.layout.util.LayoutDirection;
import net.disy.commons.swing.layout.util.LayoutUtilities;
import net.disy.commons.swing.ui.ObjectUiListCellRenderer;

public class FillOptionsPanel {
    private final JComboBox chMatchMode;
    private final JComboBox chGradient;
    private final AsciiTextArea patternTextArea;
    private final JComboBox gradientComponent;
    private final JCheckBox cbDither;
    private final JTabbedPane tabbedPane;
    private PatternDialog patternDialog;
    private final JComponent content;
    private final FillOptions options;
    private final MouseCharacterModel mouseCharacterModel;

    public FillOptionsPanel(final FillOptions options, MouseCharacterModel mouseCharacterModel, final JaveApplicationPreferences applicationPreferences) {
        Ensure.ensureArgumentNotNull(options);
        Ensure.ensureArgumentNotNull(mouseCharacterModel);
        Ensure.ensureArgumentNotNull(applicationPreferences);
        this.options = options;
        this.mouseCharacterModel = mouseCharacterModel;
        this.patternTextArea = new AsciiTextArea(new Dimension(10, 6), new AsciiTextAreaProperties());
        this.patternTextArea.setText(TextTools.toString(options.getPattern().getContent()));
        this.patternTextArea.addTextContentListener(new ITextContentListener(){

            @Override
            public void textContentChanged() {
                options.setPattern(new Pattern(AsciiPacker.encode(TextTools.toCharField(FillOptionsPanel.this.patternTextArea.getText()))));
            }
        });
        this.gradientComponent = AsciiGradients.createComponent();
        options.setGradient(this.getSelectedGradient());
        this.gradientComponent.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                options.setGradient(FillOptionsPanel.this.getSelectedGradient());
            }
        });
        this.chMatchMode = new JComboBox<FillMatchMode>(FillMatchMode.values());
        this.chMatchMode.setRenderer(new ObjectUiListCellRenderer(new FillMatchModeUi()));
        this.chMatchMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                options.setMatchMode((FillMatchMode)((Object)FillOptionsPanel.this.chMatchMode.getSelectedItem()));
            }
        });
        this.chGradient = new JComboBox<GradientStyle>(GradientStyle.values());
        this.chGradient.setRenderer(new ObjectUiListCellRenderer(new GradientStyleUi()));
        this.chGradient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                options.setGradientStyle((GradientStyle)((Object)FillOptionsPanel.this.chGradient.getSelectedItem()));
            }
        });
        this.cbDither = new JCheckBox("dither", options.isDither());
        this.cbDither.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                options.setDither(FillOptionsPanel.this.cbDither.isSelected());
            }
        });
        JPanel gradientOptionsPanel = new JPanel(new GridDialogLayout(2, false));
        gradientOptionsPanel.add((Component)new JLabel("Gradient:"), GridDialogLayoutData.RIGHT);
        gradientOptionsPanel.add(this.gradientComponent);
        gradientOptionsPanel.add((Component)new JLabel("Style:"), GridDialogLayoutData.RIGHT);
        gradientOptionsPanel.add(this.chGradient);
        gradientOptionsPanel.add(this.cbDither);
        gradientOptionsPanel.setBorder(LayoutUtilities.getDefaultEmptyBorder());
        SmartAction choosePatternAction = new SmartAction("Choose..."){

            @Override
            protected void execute(Component parentComponent) {
                FillOptionsPanel.this.performChoosePattern(parentComponent);
            }
        };
        SmartAction addPatternAction = new SmartAction("Add..."){

            @Override
            protected void execute(Component parentComponent) {
                String authorName = applicationPreferences.getAuthorName();
                JTextField tfAuthor = new JTextField(authorName, 15);
                JTextField tfName = new JTextField("", 20);
                final JPanel p = new JPanel(new GridDialogLayout(2, false));
                p.add((Component)new JLabel("Pattern Name:"), GridDialogLayoutData.RIGHT);
                p.add((Component)tfName, GridDialogLayoutData.FILL_HORIZONTAL);
                p.add((Component)new JLabel("Author:"), GridDialogLayoutData.RIGHT);
                p.add((Component)tfAuthor, GridDialogLayoutData.FILL_HORIZONTAL);
                AbstractDialogPage page = new AbstractDialogPage(""){

                    @Override
                    public IBasicMessage createCurrentMessage() {
                        return this.getDefaultMessage();
                    }

                    @Override
                    public JComponent createContent() {
                        return p;
                    }

                    @Override
                    public String getTitle() {
                        return "Add as new pattern";
                    }
                };
                UserDialog userDialog = new UserDialog(parentComponent, new DefaultDialogConfiguration<IDialogPage>((IDialogPage)page){

                    @Override
                    public boolean isHeaderPanelVisible() {
                        return false;
                    }
                });
                userDialog.show();
                if (userDialog.isCanceled()) {
                    return;
                }
                String name = tfName.getText();
                String author = tfAuthor.getText();
                if (name.trim().length() == 0) {
                    MessageDialogFactory.showMessageDialog(parentComponent, new Message("JavE", "The specified name is not a correct name for a pattern.", MessageType.ERROR));
                    return;
                }
                Pattern newPattern = new Pattern(name, options.getPattern().getCode(), author);
                PatternDialog dialog = FillOptionsPanel.this.getPatternDialog(parentComponent);
                dialog.addPattern(newPattern);
                FillOptionsPanel.this.showPatternDialog(parentComponent);
            }
        };
        ButtonPanelBuilder builder = new ButtonPanelBuilder(LayoutDirection.VERTICAL);
        builder.add(addPatternAction);
        builder.add(choosePatternAction);
        JPanel patternOptionsPanel = new JPanel(new BorderLayout());
        patternOptionsPanel.add((Component)this.patternTextArea.getContent(), "Center");
        patternOptionsPanel.add((Component)builder.createPanel(), "East");
        patternOptionsPanel.setBorder(LayoutUtilities.getDefaultEmptyBorder());
        JPanel solidPanel = new JPanel(new GridDialogLayout(1, false));
        solidPanel.add(new MouseCharacterPanel(mouseCharacterModel).getContent());
        solidPanel.setBorder(LayoutUtilities.getDefaultEmptyBorder());
        this.tabbedPane = new JTabbedPane();
        FillModeUi fillModeUi = new FillModeUi();
        this.tabbedPane.addTab(fillModeUi.getLabel(FillMode.SOLID), solidPanel);
        this.tabbedPane.addTab(fillModeUi.getLabel(FillMode.PATTERN), patternOptionsPanel);
        this.tabbedPane.addTab(fillModeUi.getLabel(FillMode.GRADIENT), gradientOptionsPanel);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int index = FillOptionsPanel.this.tabbedPane.getSelectedIndex();
                FillMode mode = FillMode.values()[index];
                options.setFillMode(mode);
            }
        });
        JPanel pMatchMode = new JPanel(new GridDialogLayout(2, false));
        pMatchMode.add((Component)new JLabel("Match Mode:"), GridDialogLayoutData.RIGHT);
        pMatchMode.add((Component)this.chMatchMode, GridDialogLayoutData.FILL_HORIZONTAL);
        JPanel optionsPanel = new JPanel(new GridDialogLayout(1, false));
        optionsPanel.add((Component)this.tabbedPane, GridDialogLayoutData.FILL_BOTH);
        optionsPanel.add((Component)pMatchMode, GridDialogLayoutData.FILL_HORIZONTAL);
        this.content = optionsPanel;
    }

    public JComponent getContent() {
        return this.content;
    }

    private char[] getSelectedGradient() {
        String s = (String)this.gradientComponent.getSelectedItem();
        char[] ch = s.toCharArray();
        if (ch.length == 0) {
            ch = new char[]{this.mouseCharacterModel.getCharacter1()};
        }
        return ch;
    }

    private void performChoosePattern(Component parentComponent) {
        this.showPatternDialog(parentComponent);
    }

    private void showPatternDialog(Component parentComponent) {
        PatternDialog dialog = this.getPatternDialog(parentComponent);
        dialog.show();
        if (!dialog.isCanceled()) {
            this.setPattern(dialog.getSelectedPattern());
        }
    }

    private PatternDialog getPatternDialog(Component parentComponent) {
        if (this.patternDialog == null) {
            this.patternDialog = new PatternDialog(parentComponent);
            this.patternDialog.getDialog().pack();
            GuiUtilities.centerOnScreen(this.patternDialog.getDialog());
        }
        return this.patternDialog;
    }

    private void setPattern(Pattern pattern) {
        this.patternTextArea.setText(TextTools.toString(AsciiPacker.decode(pattern.getCode())));
        this.options.setPattern(pattern);
    }
}

