/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.tool.rectanglealgorithmic;

import de.jave.gfx.GfxTools;
import de.jave.jave.JavEApplication;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.MixCharactersPanel;
import de.jave.jave.RectangleAlgorithm;
import de.jave.jave.Tool;
import de.jave.jave.icon.JaveIcons;
import de.jave.jave.pixelplate.PixelPlate;
import de.jave.jave.pixelplate.PixelPlateMode;
import de.jave.jave.plate.JaveMainPanel;
import de.jave.jave.preferences.ColorScheme;
import de.jave.jave.rectangle.RectangleStylePanel;
import de.jave.jave.rendering.PixelPlateRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.disy.commons.swing.mousecursor.CursorId;
import net.disy.commons.swing.mousecursor.CursorProvider;

public class RectangleAlgorithmicTool
extends Tool {
    private Point location1;
    private Point location2;
    private RectangleStylePanel rectangleStylePanel;

    public RectangleAlgorithmicTool(JaveMainPanel plate, JavEApplication asciiPainter) {
        super(plate, asciiPainter);
    }

    @Override
    public String getName() {
        return "Rectangle Algorithmic";
    }

    @Override
    public Icon getIcon() {
        return JaveIcons.TOOL_RECTANGLE_ALGORITHMIC_ICON;
    }

    @Override
    public JComponent createOptionsComponent() {
        this.rectangleStylePanel = new RectangleStylePanel(this.getMouseCharacterModel());
        this.rectangleStylePanel.addItemListener(this);
        JPanel optionsPanel = new JPanel(new BorderLayout(2, 3));
        optionsPanel.add((Component)this.rectangleStylePanel.getContent(), "Center");
        optionsPanel.add((Component)new MixCharactersPanel(this.getMixCharactersModel()).getContent(), "South");
        return optionsPanel;
    }

    @Override
    public void takeToHand() {
        this.setCursor(CursorProvider.getInstance().getCursor(CursorId.CROSSHAIR_SELECTION));
    }

    @Override
    public void putAside(boolean nextToolIsSelectionTool) {
    }

    @Override
    public void paintCursorFeature(Graphics2D g, Point plateOrigin, ColorScheme colorScheme) {
        if (this.location1 == null || this.location2 == null) {
            return;
        }
        if (this.markPlate == null) {
            return;
        }
        Point location3 = RectangleAlgorithmicTool.getQuadraticLocation(this.location1, this.location2, shiftDown);
        Rectangle r = RectangleAlgorithmicTool.getRectangleFor(this.location1, location3);
        this.showStatus("(" + r.x + "," + r.y + ") -> (" + (r.x + r.width - 1) + "," + (r.y + r.height - 1) + ")" + " = (" + r.width + "," + r.height + ")");
        this.markPlate.clear();
        char[] chars = this.rectangleStylePanel.getCurrentChars();
        if (this.rectangleStylePanel.isUnderLineStyle()) {
            --r.y;
            ++r.height;
        }
        RectangleAlgorithm.drawRectangle(this.markPlate, r, chars);
        boolean debug = false;
        this.markPlate.convert();
        PixelPlateRenderer.paint(g, this.getPlate(), colorScheme, false, this.markPlate, plateOrigin);
        Point p = this.getScreenPointFor(r.x, r.y);
        g.setColor(colorScheme.getColorToolHelping());
        GfxTools.drawBrokenRectangle(g, p.x, p.y, r.width * this.getPlate().getCharWidth(), r.height * this.getPlate().getCharHeight());
        if (r.width - 2 > 0 && r.height - 2 > 0) {
            GfxTools.drawBrokenRectangle(g, p.x + this.getPlate().getCharWidth(), p.y + this.getPlate().getCharHeight(), (r.width - 2) * this.getPlate().getCharWidth(), (r.height - 2) * this.getPlate().getCharHeight());
        }
        g.setFont(JaveGlobalRessources.FONT_SMALL);
        g.drawString(r.width + "x" + r.height, p.x + 2, p.y - 2);
    }

    @Override
    public void mousePressed(Point point, Point location, MouseEvent evt) {
        if (location == null) {
            return;
        }
        shiftDown = evt.isShiftDown();
        this.location1 = location;
        this.location2 = location;
        this.markPlate = new PixelPlate(location.x - 15, location.y - 10, 30, 20);
        this.markPlate.setMode(PixelPlateMode.CHAR);
        this.repaintCursor();
    }

    @Override
    public void mouseReleased(Point point, Point location, MouseEvent evt) {
        if (this.location1 == null || location == null) {
            return;
        }
        if (this.markPlate != null) {
            this.setMixMode(this.isMix());
            this.markPlate.pasteResultInto(this.getPlate().getContent());
            this.getPlate().saveCurrentState("draw rectangle");
            this.getPlate().repaint();
            this.markPlate = null;
        }
        this.showStatus("(" + location.x + "," + location.y + ")");
    }

    @Override
    public void mouseDragged(Point point, Point location, MouseEvent evt) {
        if (location == null) {
            if (this.location2 != null) {
                this.location2 = null;
                this.repaintCursor();
            }
            return;
        }
        if (location.equals(this.location2)) {
            return;
        }
        this.location2 = location;
        this.repaintCursor();
    }

    @Override
    public void keyPressed(int code, KeyEvent evt) {
        if (code == 27) {
            this.location1 = null;
            this.location2 = null;
            this.markPlate = null;
            this.repaintCursor();
        }
    }
}

