/*
 * Decompiled with CFR 0.152.
 */
package de.jave.javeplayer;

public class AsciiPacker {
    protected AsciiPacker() {
    }

    public static String encodeOptimized(char[][] ch) {
        int h = ch.length;
        if (h == 0) {
            return "B0 0";
        }
        int w = ch[0].length;
        if (w == 0) {
            return "B0 " + h;
        }
        String code = AsciiPacker.encodeA(ch);
        String prefix = "A";
        String codeB = AsciiPacker.encodeB(ch);
        if (codeB.length() < code.length()) {
            prefix = "B";
            code = codeB;
        }
        return prefix + w + " " + h + " " + code;
    }

    private static String encodeB(char[][] ch) {
        StringBuffer sb = new StringBuffer();
        AsciiPacker.encodeB(sb, ch);
        return sb.toString();
    }

    private static String encodeA(char[][] ch) {
        StringBuffer sb = new StringBuffer();
        AsciiPacker.encodeA(sb, ch);
        return sb.toString();
    }

    public static String encode(char[][] ch) {
        int h = ch.length;
        if (h == 0) {
            return "B0 0";
        }
        int w = ch[0].length;
        if (w == 0) {
            return "B0 " + h;
        }
        StringBuffer sb = new StringBuffer(w * h + 10);
        if (w * h < 41) {
            sb.append('B');
            sb.append(w);
            sb.append(' ');
            sb.append(h);
            sb.append(' ');
            AsciiPacker.encodeB(sb, ch);
        } else {
            sb.append('A');
            sb.append(w);
            sb.append(' ');
            sb.append(h);
            sb.append(' ');
            AsciiPacker.encodeA(sb, ch);
        }
        return sb.toString();
    }

    public static final char[][] decode(String code) {
        if (code == null || code.length() < 4) {
            throw new RuntimeException("Unable to decode compressed ASCII:The compressed code doesn not seem to be valid!");
        }
        char algorithm = code.charAt(0);
        switch (algorithm) {
            case 'A': {
                return AsciiPacker.decodeA(code);
            }
            case 'B': {
                return AsciiPacker.decodeB(code);
            }
        }
        throw new RuntimeException("Unable to decode compressed ASCII: Algorithm '" + algorithm + "' not known by this program version! " + "Please download a new release.");
    }

    private static final char[][] decodeA(String code) {
        int length = code.length();
        int index = 1;
        int w = 0;
        char ch = code.charAt(index++);
        while (ch >= '0' && ch <= '9') {
            w *= 10;
            w += ch - 48;
            ch = code.charAt(index++);
        }
        int h = 0;
        ch = code.charAt(index++);
        while (ch >= '0' && ch <= '9') {
            h *= 10;
            h += ch - 48;
            ch = code.charAt(index++);
        }
        char[][] chars = new char[h][w];
        int x = 0;
        int y = 0;
        while (index < length) {
            if ((ch = code.charAt(index++)) != '%') {
                chars[y][x++] = ch;
                continue;
            }
            if ((ch = code.charAt(index++)) == '%') {
                chars[y][x++] = 37;
                continue;
            }
            if (ch == '0') {
                for (int i = x; i < w; ++i) {
                    chars[y][x++] = 32;
                }
                ++y;
                x = 0;
                continue;
            }
            int count = ch - 48;
            ch = code.charAt(index++);
            while (ch >= '0' && ch <= '9') {
                count *= 10;
                count += ch - 48;
                ch = code.charAt(index++);
            }
            if (ch == '%') {
                ch = code.charAt(index++);
            }
            for (int i = 0; i < count; ++i) {
                chars[y][x++] = ch;
            }
        }
        while (x < w) {
            chars[y][x++] = 32;
        }
        for (int yy = y + 1; yy < h; ++yy) {
            for (int xx = 0; xx < w; ++xx) {
                chars[yy][xx] = 32;
            }
        }
        return chars;
    }

    private static final char[][] decodeB(String code) {
        int index = 1;
        int w = 0;
        char ch = code.charAt(index++);
        while (ch >= '0' && ch <= '9') {
            w *= 10;
            w += ch - 48;
            ch = code.charAt(index++);
        }
        int h = 0;
        ch = code.charAt(index++);
        while (ch >= '0' && ch <= '9' && index < code.length()) {
            h *= 10;
            h += ch - 48;
            ch = code.charAt(index++);
        }
        char[][] chars = new char[h][w];
        int i = index;
        int l = code.length();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                chars[y][x] = i >= l ? 32 : code.charAt(i);
                ++i;
            }
        }
        return chars;
    }

    private static void encodeA(StringBuffer sc, char[][] ch) {
        int w = ch[0].length;
        if (w == 0) {
            return;
        }
        int h = ch.length;
        if (h == 0) {
            return;
        }
        int state = 1;
        int x = 1;
        int y = 0;
        char cc = ch[0][0];
        int count = 1;
        int eolCount = 0;
        block5: while (state != -1) {
            switch (state) {
                case 1: {
                    if (y >= h) {
                        if (cc != ' ') {
                            AsciiPacker.printA(sc, cc, count);
                        }
                        state = -1;
                        continue block5;
                    }
                    if (x >= w) {
                        if (cc != ' ') {
                            AsciiPacker.printA(sc, cc, count);
                        }
                        eolCount = 1;
                        state = 2;
                        x = 0;
                        ++y;
                        continue block5;
                    }
                    if (ch[y][x] == cc) {
                        ++count;
                        ++x;
                        continue block5;
                    }
                    AsciiPacker.printA(sc, cc, count);
                    cc = ch[y][x];
                    ++x;
                    count = 1;
                    continue block5;
                }
                case 2: {
                    if (y >= h) {
                        state = -1;
                        continue block5;
                    }
                    if (x >= w) {
                        ++eolCount;
                        x = 0;
                        ++y;
                        continue block5;
                    }
                    if (ch[y][x] == ' ') {
                        count = 1;
                        cc = ch[y][x];
                        ++x;
                        state = 3;
                        continue block5;
                    }
                    AsciiPacker.printACR(sc, eolCount);
                    cc = ch[y][x];
                    ++x;
                    count = 1;
                    state = 1;
                    continue block5;
                }
                case 3: {
                    if (y >= h) {
                        state = -1;
                        continue block5;
                    }
                    if (x >= w) {
                        ++eolCount;
                        x = 0;
                        ++y;
                        state = 2;
                        continue block5;
                    }
                    if (ch[y][x] == ' ') {
                        ++count;
                        ++x;
                        continue block5;
                    }
                    AsciiPacker.printACR(sc, eolCount);
                    AsciiPacker.printA(sc, ' ', count);
                    cc = ch[y][x];
                    ++x;
                    count = 1;
                    state = 1;
                    continue block5;
                }
            }
        }
    }

    private static final void printACR(StringBuffer sb, int count) {
        for (int i = 0; i < count; ++i) {
            sb.append('%');
            sb.append('0');
        }
    }

    private static final void printA(StringBuffer sb, char ch, int count) {
        if (count > 2) {
            sb.append('%');
            sb.append(count);
            if (ch >= '0' && ch <= '9') {
                sb.append('%');
                sb.append(ch);
            } else if (ch == '%') {
                sb.append('%');
                sb.append('%');
            } else {
                sb.append(ch);
            }
        } else if (count == 2) {
            if (ch == '%') {
                sb.append('%');
                sb.append('%');
                sb.append('%');
                sb.append('%');
            } else {
                sb.append(ch);
                sb.append(ch);
            }
        } else if (ch == '%') {
            sb.append('%');
            sb.append('%');
        } else {
            sb.append(ch);
        }
    }

    private static void encodeB(StringBuffer sc, char[][] chars) {
        int size;
        int h = chars.length;
        for (int y = 0; y < h; ++y) {
            sc.append(chars[y]);
        }
        for (size = sc.length(); size > 0 && sc.charAt(size - 1) == ' '; --size) {
        }
        sc.setLength(size);
    }
}

