/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.core.io;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DecimalFormat;

public class IOUtilities {
    private static final DecimalFormat DECIMAL_FORMAT_3 = new DecimalFormat("000");
    private static final DecimalFormat DECIMAL_FORMAT_2_1 = new DecimalFormat("00.0");
    private static final DecimalFormat DECIMAL_FORMAT_1_2 = new DecimalFormat("0.00");
    private static final DecimalFormat DECIMAL_FORMAT_1_3 = new DecimalFormat("0.000");
    public static final long ONE_KB = 1024L;
    public static final long ONE_MB = 0x100000L;
    public static final long ONE_GB = 0x40000000L;

    private IOUtilities() {
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String readString(Reader reader) throws IOException {
        StringBuffer buffer = new StringBuffer();
        char[] buf = new char[1024];
        int numChars = 0;
        while ((numChars = reader.read(buf)) > 0) {
            buffer.append(buf, 0, numChars);
        }
        return buffer.toString();
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        IOUtilities.copyStream(in, out, 4096);
    }

    public static void copyStream(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int numChars;
        byte[] buffer = new byte[bufferSize];
        while ((numChars = in.read(buffer)) > 0) {
            out.write(buffer, 0, numChars);
        }
    }

    public static void copyStream(Reader reader, Writer writer) throws IOException {
        IOUtilities.copyStream(reader, writer, 4096);
    }

    public static void copyStream(Reader in, Writer out, int bufferSize) throws IOException {
        int numChars;
        char[] buffer = new char[bufferSize];
        while ((numChars = in.read(buffer)) > 0) {
            out.write(buffer, 0, numChars);
        }
    }

    public static InputStream toInputStream(String input) {
        return new ByteArrayInputStream(input.getBytes());
    }

    public static String toString(InputStream inputStream, String encoding) throws IOException {
        InputStreamReader reader = encoding == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, encoding);
        StringWriter writer = new StringWriter();
        IOUtilities.copyStream(reader, writer);
        return writer.toString();
    }

    public static final String byteCountToDisplaySize(long size) {
        if (size / 0x40000000L > 0L) {
            return IOUtilities.asThreeSignificantCiffersString((double)size / 1.073741824E9) + " GB";
        }
        if (size / 0x100000L > 0L) {
            return IOUtilities.asThreeSignificantCiffersString((double)size / 1048576.0) + " MB";
        }
        if (size / 1024L > 0L) {
            return IOUtilities.asThreeSignificantCiffersString((double)size / 1024.0) + " KB";
        }
        return size + " bytes";
    }

    private static final String asThreeSignificantCiffersString(double value) {
        if (value < 1.0) {
            return DECIMAL_FORMAT_1_3.format(value);
        }
        if (value < 10.0) {
            return DECIMAL_FORMAT_1_2.format(value);
        }
        if (value < 100.0) {
            return DECIMAL_FORMAT_2_1.format(value);
        }
        return DECIMAL_FORMAT_3.format(value);
    }
}

