/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.core.text;

import net.disy.commons.core.text.ITextAlignmentVisitor;

public enum TextAlignment {
    CENTER("Center", 0){

        @Override
        public void accept(ITextAlignmentVisitor visitor) {
            visitor.visitCenter(this);
        }
    }
    ,
    LEFT("Left", 2){

        @Override
        public void accept(ITextAlignmentVisitor visitor) {
            visitor.visitLeft(this);
        }
    }
    ,
    RIGHT("Right", 4){

        @Override
        public void accept(ITextAlignmentVisitor visitor) {
            visitor.visitRight(this);
        }
    };

    private final String description;
    private final int swingConstant;

    private TextAlignment(String description, int swingConstant) {
        this.description = description;
        this.swingConstant = swingConstant;
    }

    public int getIdValue() {
        return this.swingConstant;
    }

    public String toString() {
        return this.description;
    }

    public abstract void accept(ITextAlignmentVisitor var1);

    public static TextAlignment[] getAll() {
        return TextAlignment.values();
    }

    public static TextAlignment getByIdValue(int swingValue) {
        for (TextAlignment alignment : TextAlignment.getAll()) {
            if (alignment.getIdValue() != swingValue) continue;
            return alignment;
        }
        throw new IllegalArgumentException("No TextAlignment for swingValue " + swingValue + " defined");
    }

    protected Object readResolve() {
        return TextAlignment.getByIdValue(this.getIdValue());
    }

    public static TextAlignment getByDescription(String description) {
        for (TextAlignment alignment : TextAlignment.values()) {
            if (!alignment.getDescription().equals(description)) continue;
            return alignment;
        }
        throw new IllegalArgumentException("No TextAlignment defined for description " + description);
    }

    public static TextAlignment getByCaseInsensitiveDescription(String description) {
        String lowerCasedDescription = description.toLowerCase();
        for (TextAlignment alignment : TextAlignment.values()) {
            if (!alignment.getDescription().toLowerCase().equals(lowerCasedDescription)) continue;
            return alignment;
        }
        throw new IllegalArgumentException("No TextAlignment defined for description " + description);
    }

    public String getDescription() {
        return this.description;
    }
}

