/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.dialog.message;

import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JComponent;
import net.disy.commons.core.message.IMessage;
import net.disy.commons.core.message.Message;
import net.disy.commons.core.message.MessageType;
import net.disy.commons.core.model.BooleanModel;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.dialog.BasicDialogResources;
import net.disy.commons.swing.dialog.message.MessageUserDialogConfiguration;
import net.disy.commons.swing.dialog.message.YesNoCancel;
import net.disy.commons.swing.dialog.userdialog.UserDialog;
import net.disy.commons.swing.dialog.userdialog.buttons.DialogButtonConfigurationFactory;
import net.disy.commons.swing.dialog.userdialog.buttons.IDialogButtonConfiguration;

public class MessageDialogUtilities {
    public static boolean showDialog(Component parent, IMessage message, IDialogButtonConfiguration buttonConfiguration) {
        MessageUserDialogConfiguration configuration = new MessageUserDialogConfiguration(message, buttonConfiguration);
        UserDialog userDialog = new UserDialog(parent, configuration);
        userDialog.show();
        return !userDialog.isCanceled();
    }

    public static YesNoCancel showYesNoCancelDialog(Component parent, IMessage message) {
        final BooleanModel noPressedModel = new BooleanModel(false);
        IDialogButtonConfiguration buttonConfiguration = DialogButtonConfigurationFactory.createYesCancel();
        MessageUserDialogConfiguration configuration = new MessageUserDialogConfiguration(message, buttonConfiguration){

            @Override
            public JComponent[] createAdditionalButtons() {
                return new JComponent[]{new JButton(new SmartAction(BasicDialogResources.NO_TEXT){

                    @Override
                    protected void execute(Component parentComponent) {
                        noPressedModel.setValue(true);
                        this.getDialogContainer().requestFinish();
                    }
                })};
            }
        };
        UserDialog userDialog = new UserDialog(parent, configuration);
        userDialog.show();
        if (userDialog.isCanceled()) {
            return YesNoCancel.CANCEL;
        }
        if (noPressedModel.getValue()) {
            return YesNoCancel.NO;
        }
        return YesNoCancel.YES;
    }

    public static boolean confirmUserOperation(Component parent, String message, String title) {
        return MessageDialogUtilities.showYesNoDialog(parent, new Message(title, message, MessageType.QUESTION));
    }

    public static boolean showYesNoDialog(Component parent, IMessage message) {
        return MessageDialogUtilities.showDialog(parent, message, DialogButtonConfigurationFactory.createYesNo());
    }

    public static boolean showOkCancelDialog(Component parent, Message message) {
        return MessageDialogUtilities.showDialog(parent, message, DialogButtonConfigurationFactory.createOkCancel());
    }
}

