/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.dialog.progress;

import java.lang.reflect.InvocationTargetException;
import net.disy.commons.core.progress.DefaultRunnableExecuter;
import net.disy.commons.core.progress.ICancelable;
import net.disy.commons.core.progress.IInterruptableRunnableWithProgress;
import net.disy.commons.core.progress.INonInterruptableRunnableWithProgress;
import net.disy.commons.core.progress.IProgressMonitor;
import net.disy.commons.core.progress.IRunnableExecuter;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.dialog.progress.IProgressComponent;
import net.disy.commons.swing.dialog.progress.InternalProgressDialogModel;

public class ProgressMonitorExecutor {
    public static final int DEFAULT_MILLISECONDS_UNTIL_DIALOG_POPUP = 500;
    private final IProgressComponent progressComponent;
    private final InternalProgressDialogModel model;
    private int millisecondsUntilDialogPopup = 500;
    private static IRunnableExecuter defaultExecuter = new DefaultRunnableExecuter("runWithProgress");

    public static void setDeaultExecuter(IRunnableExecuter defaultExecuter) {
        Ensure.ensureArgumentNotNull(defaultExecuter);
        ProgressMonitorExecutor.defaultExecuter = defaultExecuter;
    }

    public ProgressMonitorExecutor(InternalProgressDialogModel model, IProgressComponent progressComponent) {
        this.model = model;
        this.progressComponent = progressComponent;
    }

    public void setMillisecondsUntilDialogPopup(int millisecondsUntilDialogPopup) {
        this.millisecondsUntilDialogPopup = millisecondsUntilDialogPopup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(final INonInterruptableRunnableWithProgress runnable, final IProgressMonitor monitor) throws InvocationTargetException {
        Runnable actualRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    runnable.run(monitor);
                }
                catch (InvocationTargetException e) {
                    ProgressMonitorExecutor.this.model.crashed(e);
                }
                catch (RuntimeException e) {
                    ProgressMonitorExecutor.this.model.crashed(e);
                }
                catch (Error e) {
                    ProgressMonitorExecutor.this.model.crashed(e);
                }
                catch (Throwable e) {
                    ProgressMonitorExecutor.this.model.crashed(new InvocationTargetException(e));
                }
                finally {
                    InternalProgressDialogModel e = ProgressMonitorExecutor.this.model;
                    synchronized (e) {
                        ProgressMonitorExecutor.this.model.finished();
                        ProgressMonitorExecutor.this.model.notifyAll();
                    }
                    ProgressMonitorExecutor.this.progressComponent.dispose();
                }
            }
        };
        defaultExecuter.execute(actualRunnable);
        try {
            InternalProgressDialogModel internalProgressDialogModel = this.model;
            synchronized (internalProgressDialogModel) {
                if (!this.model.isFinished()) {
                    this.model.wait(this.millisecondsUntilDialogPopup);
                }
            }
            if (!this.model.isFinished()) {
                this.progressComponent.show();
            }
            this.model.throwThrowableIfAny();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("InterruptedException during non interruptable progress", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(final IInterruptableRunnableWithProgress runnable, final IProgressMonitor progressMonitor, final ICancelable cancelable) throws InterruptedException, InvocationTargetException {
        Runnable actualRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    runnable.run(progressMonitor, cancelable);
                }
                catch (InterruptedException e) {
                    ProgressMonitorExecutor.this.model.interrupted(e);
                }
                catch (InvocationTargetException e) {
                    ProgressMonitorExecutor.this.model.crashed(e);
                }
                catch (RuntimeException e) {
                    ProgressMonitorExecutor.this.model.crashed(e);
                }
                catch (Error e) {
                    ProgressMonitorExecutor.this.model.crashed(e);
                }
                catch (Throwable e) {
                    ProgressMonitorExecutor.this.model.crashed(new InvocationTargetException(e));
                }
                finally {
                    InternalProgressDialogModel e = ProgressMonitorExecutor.this.model;
                    synchronized (e) {
                        ProgressMonitorExecutor.this.model.finished();
                        ProgressMonitorExecutor.this.model.notifyAll();
                    }
                    ProgressMonitorExecutor.this.progressComponent.dispose();
                }
            }
        };
        defaultExecuter.execute(actualRunnable);
        InternalProgressDialogModel internalProgressDialogModel = this.model;
        synchronized (internalProgressDialogModel) {
            if (!this.model.isFinished()) {
                this.model.wait(this.millisecondsUntilDialogPopup);
            }
        }
        if (!this.model.isFinished()) {
            this.progressComponent.show();
        }
        this.model.throwThrowableIfAny();
    }
}

