/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.layout.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.disy.commons.swing.layout.util.ButtonPanelBuilder;
import net.disy.commons.swing.layout.util.LayoutDirection;

public class LayoutUtilities {
    private static final int DEFAULT_SCREEN_RESOLUTION = 96;
    public static final Dimension TOOLBAR_BUTTON_SIZE = new Dimension(22, 21);
    private static final EmptyBorder DEFAULT_EMPTY_BORDER = new EmptyBorder(LayoutUtilities.getDpiAdjusted(5), LayoutUtilities.getDpiAdjusted(6), LayoutUtilities.getDpiAdjusted(5), LayoutUtilities.getDpiAdjusted(6));

    @Deprecated
    public static JPanel buildButtonPanel(Component[] components) {
        if (components == null || components.length == 0) {
            throw new IllegalArgumentException("At least one component has to be specified for laying out as Button panel.");
        }
        ButtonPanelBuilder builder = new ButtonPanelBuilder(LayoutDirection.HORIZONTAL);
        for (int i = 0; i < components.length; ++i) {
            builder.add(components[i]);
        }
        return builder.createPanel();
    }

    public static int getScreenResolution() {
        try {
            return Toolkit.getDefaultToolkit().getScreenResolution();
        }
        catch (Exception e) {
            return 96;
        }
    }

    public static int getComponentSpacing() {
        return LayoutUtilities.getComponentSpacing(LayoutUtilities.getScreenResolution());
    }

    public static int getComponentSpacing(int screenResolutionInDpi) {
        return LayoutUtilities.getDpiAdjusted(6, screenResolutionInDpi);
    }

    public static int getDpiAdjusted(int pixels, int screenResolutionInDpi) {
        return pixels * screenResolutionInDpi / 96;
    }

    public static int getDpiAdjusted(int pixels) {
        return pixels * LayoutUtilities.getScreenResolution() / 96;
    }

    public static int getComponentGroupsSpacing() {
        return LayoutUtilities.getComponentGroupsSpacing(LayoutUtilities.getScreenResolution());
    }

    public static int getComponentGroupsSpacing(int screenResolutionInDpi) {
        return LayoutUtilities.getDpiAdjusted(11, screenResolutionInDpi);
    }

    public static Border getDefaultEmptyBorder() {
        return DEFAULT_EMPTY_BORDER;
    }

    public static BorderLayout createDefaultBorderLayout() {
        return new BorderLayout(LayoutUtilities.getComponentSpacing(), LayoutUtilities.getComponentSpacing());
    }
}

