/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.smarttable.filtered;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.disy.commons.core.list.IListModel;
import net.disy.commons.core.model.ObjectModel;
import net.disy.commons.core.model.listener.IChangeListener;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.core.util.IBlock;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;
import net.disy.commons.swing.layout.grid.GridDialogLayoutDataFactory;
import net.disy.commons.swing.list.AsynchronousFilteredListModel;
import net.disy.commons.swing.list.ListSelectionMode;
import net.disy.commons.swing.mousecursor.util.CursorUtilities;
import net.disy.commons.swing.smarttable.ITableColumnViewSettings;
import net.disy.commons.swing.smarttable.SmartTable;
import net.disy.commons.swing.smarttable.filtered.ClearFilterTextFieldAction;
import net.disy.commons.swing.smarttable.filtered.ObjectUiStringFilter;
import net.disy.commons.swing.table.ListTableModel;
import net.disy.commons.swing.text.TextWidgetFactory;
import net.disy.commons.swing.toolbar.ToolBarUtilities;
import net.disy.commons.swing.ui.IObjectUi;

public class FilterableListTable<T> {
    private final ObjectModel<T> selectionModel;
    private final JTextField filterTextField;
    private final AsynchronousFilteredListModel<T> filteredListModel;
    private final SmartTable table;
    private final JComponent content;

    public FilterableListTable(IListModel<T> listModel, final ObjectModel<T> selectionModel, final IObjectUi<T>[] objectUis, String[] columnNames, ITableColumnViewSettings[] tableColumnViewSettings) {
        this.selectionModel = selectionModel;
        Ensure.ensureArgumentNotNull(objectUis);
        Ensure.ensureArgumentArrayContentsNotNull(objectUis);
        final ObjectModel<String> filterTextModel = new ObjectModel<String>();
        this.filterTextField = TextWidgetFactory.createTextField(filterTextModel, 20);
        filterTextModel.addChangeListener(new IChangeListener(){

            @Override
            public void stateChanged() {
                FilterableListTable.this.filteredListModel.setFilter(new ObjectUiStringFilter(objectUis, (String)filterTextModel.getValue()));
            }
        });
        this.filteredListModel = new AsynchronousFilteredListModel<T>(listModel);
        ListTableModel<T> tableModel = new ListTableModel<T>(this.filteredListModel, columnNames);
        this.table = new SmartTable(tableModel, tableColumnViewSettings);
        this.table.setSelectionMode(ListSelectionMode.SINGLE_SELECTION);
        this.table.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selectedRowIndex = FilterableListTable.this.table.getSelectedRowIndex();
                selectionModel.setValue(selectedRowIndex == -1 ? null : (Object)FilterableListTable.this.filteredListModel.getItem(selectedRowIndex));
            }
        });
        CursorUtilities.attachWaitCursorForBusyModel(this.table.getContent(), this.filteredListModel.getBusyModel());
        JPanel panel = new JPanel(new GridDialogLayout(3, false));
        panel.add(new JLabel("Filter:"));
        panel.add(this.filterTextField);
        panel.add(ToolBarUtilities.createToolBarButton(new ClearFilterTextFieldAction(this.filterTextField, filterTextModel)));
        panel.add((Component)this.table.getContent(), GridDialogLayoutDataFactory.createHorizontalSpanData(3, GridDialogLayoutData.FILL_BOTH));
        this.content = panel;
        this.updateSelection();
    }

    public void enableEnterActionsOnFilter(final IBlock applySelection) {
        this.filterTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    if (FilterableListTable.this.getFilteredListModel().getItemCount() == 1) {
                        FilterableListTable.this.applySingleFilterResult(applySelection);
                    } else {
                        FilterableListTable.this.leaveFilter();
                    }
                    e.consume();
                }
            }
        });
    }

    protected void leaveFilter() {
        this.table.requestFocus();
        if (this.table.getSelectionModel().isSelectionEmpty() && this.getFilteredListModel().getItemCount() > 0) {
            this.table.getSelectionModel().setSelectionInterval(0, 0);
            this.table.getTable().setEditingRow(0);
        }
    }

    protected void applySingleFilterResult(IBlock applySelection) {
        this.table.getSelectionModel().setSelectionInterval(0, 0);
        this.updateSelection();
        applySelection.execute();
        this.clearFilter();
        this.filterTextField.requestFocus();
    }

    public JComponent getContent() {
        return this.content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSelection() {
        T selectedValue = this.selectionModel.getValue();
        if (selectedValue == null) {
            this.table.getTable().getSelectionModel().clearSelection();
            return;
        }
        AsynchronousFilteredListModel<T> asynchronousFilteredListModel = this.filteredListModel;
        synchronized (asynchronousFilteredListModel) {
            int index = this.filteredListModel.indexOf(selectedValue);
            if (index == -1) {
                this.table.getTable().getSelectionModel().clearSelection();
                return;
            }
            this.table.scrollToAndSelect(index);
        }
    }

    public void addDoubleClickActionListener(ActionListener listener) {
        this.table.addSelectionActionListener(listener);
    }

    public void requestFocus() {
        this.table.assureSelectionVisible();
        this.filterTextField.requestFocus();
    }

    public void clearFilter() {
        this.filterTextField.setText("");
    }

    protected JTextField getFilterTextField() {
        return this.filterTextField;
    }

    protected IListModel<T> getFilteredListModel() {
        return this.filteredListModel;
    }

    protected ListSelectionModel getSelectionModel() {
        return this.table.getSelectionModel();
    }
}

