/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.toolbar;

import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JToolBar;
import net.disy.commons.core.grouped.IGroupedItem;
import net.disy.commons.core.grouped.IStructuredItemAddable;
import net.disy.commons.core.grouped.SeparatorGroupItemStructureBuilder;
import net.disy.commons.swing.toolbar.ToolBarUtilities;

public class GroupedToolBarBuilder {
    private final JToolBar toolBar;
    private final SeparatorGroupItemStructureBuilder<String, AbstractButton> structureBuilder = new SeparatorGroupItemStructureBuilder();

    public GroupedToolBarBuilder() {
        this(ToolBarUtilities.createEmptyToolBar());
    }

    public GroupedToolBarBuilder(JToolBar toolbar) {
        this.toolBar = toolbar;
    }

    public GroupedToolBarBuilder add(IGroupedItem<String, Action> item) {
        this.add(item.getGroupId(), item.getItem());
        return this;
    }

    public GroupedToolBarBuilder add(String groupId, Action action) {
        this.add(groupId, ToolBarUtilities.createToolBarButton(action));
        return this;
    }

    public GroupedToolBarBuilder add(String groupId, AbstractButton button) {
        this.structureBuilder.add(groupId, button);
        return this;
    }

    public JToolBar getToolBar() {
        this.structureBuilder.addAllItemsTo(new IStructuredItemAddable<AbstractButton>(){

            @Override
            public void add(AbstractButton item) {
                GroupedToolBarBuilder.this.toolBar.add(item);
            }

            @Override
            public void addSeparator() {
                GroupedToolBarBuilder.this.toolBar.addSeparator();
            }
        });
        return this.toolBar;
    }
}

