/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.ui;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.icon.DisabledIconDecorator;
import net.disy.commons.swing.ui.IObjectUi;

public class ObjectUiListCellRenderer
extends DefaultListCellRenderer {
    private final IObjectUi ui;

    public ObjectUiListCellRenderer(IObjectUi ui) {
        Ensure.ensureArgumentNotNull(ui);
        this.ui = ui;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        Icon icon = this.ui.getIcon(value);
        if (icon != null && !list.isEnabled()) {
            icon = new DisabledIconDecorator(icon);
        }
        this.setIcon(icon);
        this.setDisabledIcon(icon == null ? null : new DisabledIconDecorator(icon));
        this.setText(this.ui.getLabel(value));
        this.setToolTipText(this.ui.getToolTipText(value));
        return this;
    }
}

