/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db;

import java.io.Serializable;
import java.util.BitSet;

public class Marker
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 0L;
    private boolean m_marked = false;
    private BitSet[] m_chains = null;

    public Marker() {
        this(0);
    }

    public Marker(int nChains) {
        this.m_chains = new BitSet[nChains];
        int i = 0;
        while (i < nChains) {
            this.m_chains[i] = new BitSet(32);
            ++i;
        }
    }

    public Marker(Marker m) {
        this.m_marked = m.m_marked;
        this.m_chains = new BitSet[m.m_chains.length];
        int i = 0;
        while (i < m.m_chains.length) {
            this.m_chains[i] = (BitSet)m.m_chains[i].clone();
            ++i;
        }
    }

    public Object clone() {
        Marker m = new Marker();
        m.m_marked = this.m_marked;
        m.m_chains = new BitSet[this.m_chains.length];
        int i = 0;
        while (i < this.m_chains.length) {
            m.m_chains[i] = (BitSet)this.m_chains[i].clone();
            ++i;
        }
        return m;
    }

    public boolean isMarked() {
        return this.m_marked;
    }

    public void mark(boolean status) {
        this.m_marked = status;
        int i = 0;
        while (i < this.m_chains.length) {
            this._getChain(i).clear();
            ++i;
        }
    }

    public void mark() {
        this.mark(true);
    }

    public int numberOfChains() {
        return this.m_chains.length;
    }

    public boolean hasMarkedPrimitives(int chain) {
        if (!this.m_marked) {
            return false;
        }
        this._checkChain(chain);
        return !this._getChain(chain).isEmpty();
    }

    public boolean primitiveMarked(int chain, int index) {
        if (!this.m_marked) {
            return false;
        }
        this._checkChain(chain);
        return this._getChain(chain).get(index);
    }

    public void markPrimitive(int chain, int index, boolean status) {
        if (!this.m_marked) {
            return;
        }
        this._checkChain(chain);
        this._getChain(chain).set(index, status);
    }

    public void markPrimitive(int chain, int index) {
        this.markPrimitive(chain, index, true);
    }

    public void clearChain(int chain) {
        if (!this.m_marked) {
            return;
        }
        this._checkChain(chain);
        this._getChain(chain).clear();
    }

    public int chainLength(int chain) {
        this._checkChain(chain);
        return this.m_marked ? this._getChain(chain).length() : 0;
    }

    private void _checkChain(int chain) {
        if (chain < 0 || chain > this.m_chains.length) {
            throw new IllegalArgumentException();
        }
    }

    private BitSet _getChain(int chain) {
        return this.m_chains[chain];
    }
}

