/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db.att;

import cib.cad.db.att.AttributeManager;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;

public class DefineTextSize
implements Cmd {
    private String m_toString = null;
    private String m_svName = null;
    private double m_svValue;
    private boolean m_override = false;
    private double m_overridenValue;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        String name;
        Kernel krnl = (Kernel)context;
        AttributeManager atm = AttributeManager.getAttributeManager();
        if (atm.containsTextSize(name = krnl.readString(Messages.getString("db.att.DefineTextSize.0")))) {
            this.m_override = true;
            this.m_overridenValue = atm.getTextSize(name);
            krnl.readOK(Messages.getString("db.att.DefineTextSize.1"), Messages.getString("db.att.DefineTextSize.2"), String.valueOf(Messages.getString("db.att.DefineTextSize.3")) + name + Messages.getString("db.att.DefineTextSize.4") + atm.getTextSize(name) + Messages.getString("db.att.DefineTextSize.5"), 10);
        }
        double value = krnl.readDouble(Messages.getString("db.att.DefineTextSize.6"));
        try {
            atm.addTextSize(name, value);
        }
        catch (Exception e) {
            System.out.println(String.valueOf(Messages.getString("db.att.DefineTextSize.7")) + value + Messages.getString("db.att.DefineTextSize.8"));
            throw new CmdAbortedException();
        }
        this.m_svName = name;
        this.m_svValue = value;
        this.m_toString = String.valueOf(Messages.getString("db.att.DefineTextSize.9")) + name + Messages.getString("db.att.DefineTextSize.10") + value + Messages.getString("db.att.DefineTextSize.11");
        System.out.println(this);
        if (this.m_override) {
            krnl.getUserInterface().repaintUserInterface();
        }
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        AttributeManager atm = AttributeManager.getAttributeManager();
        if (!this.m_override) {
            atm.removeTextSize(this.m_svName);
        } else {
            atm.addTextSize(this.m_svName, this.m_overridenValue);
            krnl.getUserInterface().repaintUserInterface();
        }
    }

    @Override
    public void redoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        AttributeManager atm = AttributeManager.getAttributeManager();
        atm.addTextSize(this.m_svName, this.m_svValue);
        if (this.m_override) {
            krnl.getUserInterface().repaintUserInterface();
        }
    }

    @Override
    public boolean changesState() {
        return true;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }
}

