/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db.att;

import cib.cad.db.Database;
import cib.cad.db.att.Attributes;
import cib.cad.db.comp.Component;
import cib.cad.db.layer.Layer;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.ObservableSet;
import cib.util.coll.ReverseAccessMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ModifyAttributesByLayer
implements Cmd {
    protected Map<Component, Attributes> m_map = new HashMap<Component, Attributes>();
    private String m_toString = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ReverseAccessMap<Component, Layer> layerMap = db.getLayerMap();
        ObservableSet<Component> selSet = db.getSelectSet();
        if (selSet.isEmpty()) {
            System.out.println(Messages.getString("db.att.ModifyAttributesByLayer.0"));
            return;
        }
        for (Component comp : selSet) {
            this.m_map.put(comp, comp.getAttributes());
            if (!layerMap.containsKey(comp)) continue;
            comp.setAttributes(((Layer)layerMap.get(comp)).getAttributes());
        }
        this.m_toString = String.valueOf(Messages.getString("db.att.ModifyAttributesByLayer.1")) + selSet.size() + Messages.getString("db.att.ModifyAttributesByLayer.2");
        System.out.println(this);
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        if (selSet.isEmpty()) {
            System.out.println(Messages.getString("db.att.ModifyAttributesByLayer.3"));
            return;
        }
        Iterator it = selSet.iterator();
        HashMap<Component, Attributes> map = new HashMap<Component, Attributes>();
        while (it.hasNext()) {
            Component comp = (Component)it.next();
            map.put(comp, comp.getAttributes());
            comp.setAttributes(this.m_map.get(comp));
        }
        this.m_map = map;
    }

    @Override
    public void redoCmd(Object context) {
        this.undoCmd(context);
    }

    @Override
    public boolean changesState() {
        return true;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }
}

