/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db.att;

import cib.cad.db.Database;
import cib.cad.db.att.AttributeSelectors;
import cib.cad.db.att.Attributes;
import cib.cad.db.comp.Component;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.ObservableSet;
import java.util.HashMap;
import java.util.Map;

public class ModifyFontFamily
implements Cmd {
    protected Map<Component, Attributes> m_map = new HashMap<Component, Attributes>();
    private String m_toString = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        if (selSet.isEmpty()) {
            System.out.println(Messages.getString("db.att.ModifyFontFamily.0"));
            return;
        }
        AttributeSelectors ats = AttributeSelectors.getSelectors(krnl);
        String attr = ats.fontFamily();
        for (Component comp : selSet) {
            Attributes svat = comp.getAttributes();
            this.m_map.put(comp, svat);
            Attributes at = new Attributes(svat);
            at.setFontFamily(attr);
            comp.setAttributes(at);
        }
        this.m_toString = String.valueOf(Messages.getString("db.att.ModifyFontFamily.1")) + selSet.size() + Messages.getString("db.att.ModifyFontFamily.2");
        System.out.println(this);
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        for (Component comp : selSet) {
            Attributes svat = comp.getAttributes();
            comp.setAttributes(this.m_map.get(comp));
            this.m_map.put(comp, svat);
        }
    }

    @Override
    public void redoCmd(Object context) {
        this.undoCmd(context);
    }

    @Override
    public boolean changesState() {
        return !this.m_map.isEmpty();
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }
}

